package NWS::Brocade;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Brocade.pm,v 1.6 2004/05/28 19:16:10 ccadieux Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use strict;
use Ilist;
use PDM;
use NWS;
sub revision {'$Revision: 1.6 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v, $x);
  my($PORTS);
  my($wwn) = $rep->get('id.wwn');

  my $power_cnt = 0;
  for ($x = 1; $x <= 4; $x++) {
    next if(!$rep->{"sensor.power-supply.$x.name"});
    $power_cnt++;
  }

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn               ],
                    [WWN  		=> $wwn               ],
                    [SystemName         => $rep->get('id.name')],
                    [OtherIdentifyingInfo  => "wwn=$wwn"      ],
                    [IP 		=> $rep->get('id.ip')],
                    [FruCount 		=> $rep->get('port.count')+1+ $power_cnt],
		    [FruPowerCount 	=> $power_cnt],
                    [SysRevision        => $rep->get('swSystem.swFirmwareVersion')],
                    [BootInfo           => $rep->get('swSystem.swBootDate')],
                    [Caption            => "Brocade"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 			=> $rep->get("id.wwn")],
                  [Name			=> $rep->get("id.wwn")],
                  [Manufacturer 	=> "SUN" ],
                  [Model 		=> "Brocade_". $rep->get('port.count')],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 		=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);

  $PORTS =  $rep->get('port.count');


  for ($i = 0; $i < $PORTS; $i++) {
    $dd = $class->newPort($rep,"port.$i" , $i);
    $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "port$i"],
                   ]);
    push (@pil, @$dd);
    push (@pil, $a);
  }

  my $j = 1;
  foreach my $el ('temperature','fan','power-supply') {
    for ($x = 1; $x <= 20; $x++) {
       my $name = $rep->{"sensor.$el.$x.info"};
       next if (!$name);
       my $comp = "sensor.$el.$x";
       $dd = $class->newFru($rep, $comp);
       next if (!$dd);
       $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => $comp ],
                   ]);
       $j++;
       push (@pil, @$dd, $a);

    }
  }


  return Ilist->new(\@pil);
}


sub newPort {
  my($class, $rep, $cd, $no) = @_;
  my(@il, $p1, $c1, $a1);
  
  my($status) = $rep->get("${cd}.state.OpStatus");

  my($serial_no) = $rep->get("id.wwn") .  "." . $cd;

  my($map) = PDM->getDeviceStateMap("brocade.availability");

  my($state) =  $map->get("state.OpStatus." . $rep->get("$cd.state.OpStatus") );

  $p1 = CIM::Instance->new('NWS_SwitchPort',  [
                    [Admin        => $rep->get("${cd}.state.AdmStatus")],
                    [Mode         => $rep->get("${cd}.state.LinkState")],
                    [Operational  => $rep->get("${cd}.state.OpStatus")],

             [SystemName          => "Brocade" . $rep->get("port.count") ],
             [DeviceID            => $serial_no ],
             [Name                => $serial_no ],
             [StatusInfo          => $status    ],
             [RemoteWWN           => $rep->get("$cd.link_wwn") ],
             [Status              => $state     ],
             [LossOfSignalCounter => 0          ],
             [LossOfSyncCounter   => 0          ],
             [CRCErrors           => $rep->get("$cd.error.RxCrcs") ], 
             [InvalidTransmissionWords => 0     ],
             [FramesTooShort      => 0          ],
             [FramesTooLong       => 0          ],
                 
                    ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable 	=> "Yes"],
                [Replaceable 	=> "Yes"],
                [Tag 		=> $serial_no],
                [Name  		=> $serial_no],
                [SerialNumber 	=> $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

sub newFru {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my $serial_no = $rep->get('id.wwn');

  return undef if (!$serial_no);

  $serial_no .= ".$cd";

  my $status  = $rep->get("$cd.status") || "UNKNOWN";
  my $add_info = $rep->get("$cd.value") || "N/A";

  my $id = $rep->get("$cd.name") || $cd;
  $id =~ s/ /_/g;

  $p1 = CIM::Instance->new("NWS_Fru", [
                [SystemName 	    => $id     ],
                [DeviceID 	    => $serial_no],
                [Name     	    => $serial_no],
                [Status             => $status   ],
		[StatusInfo         => $status   ],
                [Type               => "sensor"  ],
                [FruId              => $id       ],
                [OtherIdentifyingInfo => $add_info ],
                 ]);
  push(@il,$p1);
  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable     => "Yes"],
                [Tag	        => $serial_no],
                [Name    	=> $id],
                    ]);


  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

1;
