package NWS::DSP;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: DSP.pm,v 1.13 2004/06/16 21:10:45 edunning Exp $

use Report;
use CIM::Instance;
use Data::Dumper;
use Agent::DSP;
use strict;
use Ilist;
use PDM;
use Report;
use NWS;
sub revision {'$Revision: 1.13 $'}

sub newSystem {
  my ($class, $rep) = @_;
  my(@pil, $i, $dd, $a, $j, $k, $k1, $v);
  my($PORTS);
  my($wwn) = $rep->get('id.wwn');
  my $sol_id;
  my $renv = System->get_renv();

  my($p1) = CIM::Instance->new('NWS_System',[
                    [Name 		=> $wwn               ],
                    [SystemName         => $rep->get('id.name')],
                    [OtherIdentifyingInfo  => "wwn=$wwn"      ],
                    [IP 		=> $rep->get('id.ipno')],
                    [FruCount 		=> $rep->get('totals.fru')],
                    [Caption            => "DSP"],
                ]);

  my($p2) = CIM::Instance->new('CIM_PhysicalFrame', [
                  [Tag 		=> $rep->get("id.wwn")],
                  [Name		=> $rep->get("id.wwn")],
                  [Manufacturer	=> "SUN" ],
                  [Model 	=> "PSX1000" ],
                  ]);

  my($a2) = CIM::Instance->new('CIM_ComputerSystemPackage', [
                  [Antecedent            => $p1],
                  [Dependent             => $p2],
                  ]);

  my($l1) = NWS->location($rep);
  
  my($al1) = CIM::Instance->new('NWS_PhysicalFrameLocation', [
                  [Element 				=> $p2],
                  [PhysicalLocation 	=> $l1],
                  ]);
               
  push (@pil, $p1, $p2, $a2, $l1, $al1);


  my($m, $p);
  for ($m=3; $m <= 10; $m++) {
    for ($p=1; $p <= 16; $p++) {
       $i = "m${m}p$p";
       next if (!$rep->{"fibrePort.$i.PortWwn"});
       $dd = $class->newPort($rep,"fibrePort.$i");
       $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent => $dd->[1]],
                   [LocationWithinContainer => "port.$i"],
                   ]);
       push (@pil, @$dd);
       push (@pil, $a);
     }
  }

  my ($side, $m, $i);
  foreach my $module (Agent::DSP->module_list()) {
   foreach $side ('Front','Rear') {
    for ($m=1; $m <= 10; $m++) {
       $i = "$side$m";
       next if (!$rep->get("$module.$i.Class"));
       my $dd = $class->newModule($rep,"$module.$i");
       if ($dd) {
          $a = CIM::Instance->new('CIM_Container', [
                   [GroupComponent  => $p2],
                   [PartComponent   => $dd->[1]],
                   [LocationWithinContainer => "$module.$i"],
                   ]);

          push (@pil, @$dd);
          push (@pil, $a);
       }
     }
   }
  }

  
  return Ilist->new(\@pil);
}


sub newPort {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1);
  
  my $status    = $rep->get("$cd.PortState");
  my $serial_no = $rep->get("$cd.PortWwn");

  my $map       = PDM->getDeviceStateMap("dsp.availability");
  my $state     =  $map->get("portState." . $rep->get("$cd.PortState"));

  $p1 = CIM::Instance->new('NWS_SwitchPort',  [
                    [Admin        => $status],
                    [Mode         => $rep->get("${cd}.HardwareState")],
                    [SystemName   => "DSP"],
                    [DeviceID     => $serial_no ],
                    [Name         => $serial_no ],
                    [StatusInfo   => $status],
                    [Status       => $state ],
                    [PortType     => $rep->get("$cd.PortType") ],
                    [FcClass      => $rep->get("$cd.FcClassOperational") ],
                    [FcSpeed      => $rep->get("$cd.FcSpeedOperational") ],
                    [TypeName     => $rep->get("$cd.TypeName") ],
                    [ModuleType   => $rep->get("$cd.ModuleType") ],
                    ]);

  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable 	=> "Yes"],
                [Replaceable  	=> "Yes" ],
                [Tag 		=> $serial_no],
                [Name  		=> $serial_no],
                [SerialNumber   => $serial_no],
                    ]);

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                [Antecedent => $c1],
                [Dependent => $p1],
                    ]);
                    
  push(@il,$a1);

  return Ilist->new(\@il);

}

sub moduleKey {
  my($class, $rep, $cd) = @_;

  my $key = $rep->get("$cd.PartNumber");
  $key   .= "." . $rep->get("$cd.SerialNumber") if ($rep->get("$cd.SerialNumber"));
  return $key;
}

# card.0.cardNum

sub newModule {
  my($class, $rep, $cd) = @_;
  my(@il, $p1, $c1, $a1, $c2, $a2);

  my $serial_no = $class->moduleKey($rep, $cd);

  return undef if (!$rep->get("$cd.PartNumber"));

  my $status = $rep->get("$cd.State");

  $p1 = CIM::Instance->new('NWS_Module', [
                [SystemName     => "PSX1100-" . $rep->get("$cd.Type")],
                [DeviceID       => $serial_no],
                [Name           => $serial_no],
                [StatusInfo     => $status],
                [Type           => $rep->get("$cd.Type")      ],
                [Class          => $rep->get("$cd.Class")     ],
                [Status         => 1 ],
                 ]);
  push(@il,$p1);

  $c1 = CIM::Instance->new('CIM_Card', [
                [Removable      => "No"],
                [Replaceable    => "No"],
                [Tag            => $serial_no],
                [Name           => $serial_no],
                [SerialNumber   => $rep->get("$cd.SerialNumber") ],
                [Manufacturer   => "SUN"],
                [Model          => $rep->get("$cd.PartNumber")],
                [Version        => $rep->get("$cd.HWRev"). "," . $rep->get("$cd.PCBRev")],
                [Type           => $rep->get("$cd.Type")      ],
                [Class          => $rep->get("$cd.Class")     ],
                [OtherIdentifyingInfo => $rep->get("$cd.Type") . ":" .$rep->get("$cd.Class")],
                ]
                );

  push(@il, $c1);
  $a1 = CIM::Instance->new('CIM_Realizes', [
                    [Antecedent => $c1],
                    [Dependent => $p1],
                    ]);

  push(@il,$a1);

  return Ilist->new(\@il);

}


1;
