package Plugin;

use strict;

#!/usr/bin/perl  
#use strict;  	
#use vars qw/$path/;  
#BEGIN { $path = "/foo/bar" };  
#use lib $path;  
#print "Content-type: text/plain\n\n";  	 
#print join "\n", @INC;


sub path {
  my($class) = @_;
  my @path;
  my $BASE = System->get_home();
  opendir(D, "$BASE/Plugin");
  my @dirs = readdir(D); closedir(D);
  foreach my $d (@dirs) {
    next if (substr($d,0,1) eq ".");
    next if (!-d "$BASE/Plugin/$d");
    push(@path,  "$BASE/Plugin/$d");
  }
  return @path;
}

use vars qw($RES);

#
# find these resources to a common location
# save in HASH
# copy to System if $copy=1
#
sub findResources {
  my($class, $copy , $debug) = @_;

  return $RES if ($RES);

  my $BASE = System->get_home();
  opendir(D, "$BASE/Plugin");
  my @dirs = readdir(D); closedir(D);
  foreach my $d (@dirs) {
    next if (substr($d,0,1) eq ".");
    next if (!-d "$BASE/Plugin/$d");
    foreach my $section ('Tests=test','EGrid=grid','Map=map',
                   'Policies=policies','Fault=fault') {
        my($dir, $ext0) = split(/=/, $section);
        my $ext = ".$ext0";
        opendir(D, "$BASE/Plugin/$d/System/$dir");
        my @L = readdir(D); closedir(D);
        foreach my $l (@L) {
          if (substr($l,-length($ext)) eq $ext) {
             print "found Plugin/$d/System/$dir/$l  \n" if ($debug);
             if ($copy) {
                $class->copy("Plugin/$d/System/$dir/$l", "System/$d/$l");
             }
             $RES->{$ext0}{$l} = { file => "Plugin/$d/System/$dir/$l"};
          }
        }
    }
  }
  return $RES;
}


sub copy {
  my($class, $from , $to) = @_;
  my($l);
  if (open(O,$from) && open(W, ">$to")) {
    while ($l = <O>) {
      print W $l;
    }
    close(O); close(W);
  }

}


1;

