package Policies::Stats;

use System;
use strict;
use vars qw($STATS);

sub init {
  my($class) = @_;
  my $STATS = Util->deserialize("Policies_Stats");

}

sub sensekey {
  my($class, $key, $line, $pat) = @_;

  $class->init() if (!$STATS);
  if ($line =~ /$pat/) {
     my $sense1 = $1;
     my $sense2 = $1;
     my $sense3 = $1;
     $STATS->{"sensekey.$key.$sense1-$sense2-$sense3"}++;
  }
}


sub final {
   my($class) = @_;
   return if (!$STATS);

   Util->serialize($STATS, "Policies_Stats");

}

sub erase {
  my($class) = @_;

  my $dir = System->get_home() . "/DATA/Policies_Stats";
  $STATS = undef;
  unlink $dir;
}

sub text {
  my($class) = @_;
  my($out);
  return undef if (!$STATS);

  foreach my $k (sort keys %$STATS) {
     $out .= "$k=$STATS->{$k}\n";
  }
  
  return $out;
}



1;
