package RMgr;
use Lease;
use System;
use strict;

##########################
# RESOURCE MANAGER
# key = 
#

# key: device key
#page: page of information from the device
# age: acceptable age of the report
#  to: maximum time to wait for report
# fun: function to call
#
#  $rep = RM->readReport(\&INSTRUMENTATION, [$agent, $device], $device->{key}, "slice", 5, $http_to);

use vars qw($RM);

# use ResourceDB for caching.
#
sub readDB {
  my($class, $fun, $args, $key, $age, $to) = @_;

  my $RM = RasDB->new("ResourceDB");
  $to = $age + 10 if (!$to);
  my $hash = $RM->{hash};
  my $rep;
  $rep->{'rc.key'} = $key;
  my $start = time;
  while (1) {
      if (time - $start > $to) {
        $rep->{'rc.error'} = "Timeout: $to";
        last ;
      }
      if (!exists $hash->{$key} || time - $hash->{$key}{_RM_CREATED_} > $age) {
         my $lease;
         if ($lease = Lease->get($key, $to)) {
            my $start_time = time;
            $rep = &$fun(@$args);
            $rep->{_RM_CREATED_} = $start_time;
            $hash->{$key} = $rep;
            $lease->release($key);
            last;
         } else {
            sleep 3;
         }
      } else {
         $rep = $hash->{$key};
         last;
      }
  }
  return $rep;
}

# use RESOURCES for caching
# key used as filaname and lease_id
# key = t3:<serialno>:page
# returns a hash.
#
sub readReport {
  my($class, $fun, $args, $key, $age, $to) = @_;

  my $rep = {};
  $to = $age + 10 if (!$to);
  $rep->{'rc.key'} = $key;
  my $start = time;
  my $FILE  = "RESOURCES/$key";
  my $REP   = System->get_home() . "/DATA/$FILE";

  while (1) {
     if (time - $start > $to) {
        $rep->{'rc.error'} = "Timeout: $to";
        last ;
     }
     my @stats = stat("$REP.start");
     my $report_started = $stats[9] + 0;
     if (!-f $REP ||  $start - $report_started > $age) {
         my $lease;
         if ($lease = Lease->get($key, $to)) {
            open(W, ">$REP.start"); close(W);
            $rep = &$fun(@$args);
            Util->serialize($FILE, $rep);
            $lease->release($key);
            last;
         } else {
            sleep 3;
         }
     } else {
         $rep = Util->deserialize($FILE);
         last;
     }
  }
  return $rep;
}

1;
