package RasScheduler;
use Html::Screen;
use System;
use strict 'vars';
use Style;
use Util;
use vars qw ($DB);
use Mail;

$DB = "RasScheduler";


sub read {
  my($class) = @_;

  my $db = Util->deserialize($DB) || {};

  bless($db, "RasScheduler");
  return $db;
}

sub clear {
  my($class) = @_;
  unlink System->get_home() . "/DATA/$DB";
}

sub delete {
  my($db, $key) = @_;
  delete $db->{$key};
}


sub add {
  my($db, $command, $args, $freq, $time, $dow, $email, $desc) = @_;

  my $em = $email;
  $em =~ s/\W//g;
  $args .= Util->encode("&EM=$em");
  $db->{$args} = { command => $command,
                      desc => $desc, 
                       dow => $dow, 
                      freq => $freq,   # not used
                      email=> $email, 
                      time => $time, 
                  last_run => 0
                 };
}

sub write {
  my($db) = @_;

  Util->serialize($DB, $db);
}

use Http;
# run from rasagent
#
sub run {
 my($class) = @_;
 my $renv = System->get_renv();
 Style->init($renv);
 my $db = $class->read();

 my $start = Util->get_today();
 my $hour  = substr($start, 11,2) + 0;
  my ($today, $year, $month, $day) = Util->get_today_array();
 my ($jd, $dow, $wk) = Util->julian($year, $month, $day);

 foreach my $e (keys %$db) {
    my $el = $db->{$e};
    if ($hour < $el->{time}){
       # not time yet, skip this one
       next;
    }

    next if ($el->{dow} ne "99" && ($el->{dow} ne $dow) );

    next if ($jd == $el->{last_run}); #already been run today

    Debug->print2("RasScheduler: running $el->{command} / $el->{desc}");
    my $comm = $el->{command};  
    my $email = $el->{email};
    my $args = Util->decode($e);
    my $q = {};
    Http::parse($args, $q, 1);
    $q->{email} = 1;
    Http::loadPackage("", $comm);
    my $ix = rindex($comm, "::");
    my $run = substr($comm,0,$ix) . "::RUN";

    open(OLDOUT, ">&STDOUT");   open(OLDERR, ">&STDERR");
    open(STDOUT, '>/dev/null'); open(STDERR, '>/dev/null');
    select(STDOUT);
    &$run($q);
    my $report = &$comm($q);
    $report =~ s/<img /<ximg /g;
    close(STDOUT);              close(STDERR);
    open(STDOUT, ">&OLDOUT");   open(STDERR, ">&OLDERR");

    my $data = Util->email_html("Storage_ADE", "Scheduled Report $el->{desc}", $email, 
                                "Scheduled report from Storage_ADE\n\n Description: $el->{desc}\n    Command : $el->{command}\n      Date : $start \n", 
                                "scheduler.html", $report, "html"
                               );
    Mail->mailData($email, $data);
    Debug->info(TEXT => "ran scheduled report $comm $el->{desc}");

    $el->{last_run} = $jd;
    $el->{last_run_time} = time;

 }
 $db->write();
}

1;
