package Reports::Fru;
use Report;
use strict;
use vars qw($ERR $OK);
use Process;
use Modules;

sub log1 {
  my($l) = @_;
  open(W, ">>/tmp/x");
  print W "$l\n";
  close(W);
}


sub new {
  my($class, $new, $arg) = @_;
  my ($REP, $out, @LIST);
  my $renv = System->get_renv();

  my $filename = $arg->{filename} || "fru_report";
  my $F  = "/tmp/$filename";
  my $F1 = System->get_home() . "/DATA/$F";
  if (!$new) {
     $REP = Util->deserialize($F);
     return $REP;
  }
  unlink $F1;
  $ERR = "";
  my $list = Report->reportList();
  Modules->load("Agent");
  foreach my $k (sort keys %$list) {
       my $el = $list->{$k};
       my $type = $el->[1];
       my $host = $el->[0];
       my $name = $el->[4] || $k;
       my $date = $el->[2];
       my ($err, $VAR1) = Report->readReport($k, $host, 10);
       if (!$VAR1) {
          $out .= "$k: Invalid report\n";
          next;
       }
       if ($err) {
          $out .= $err;
          next;
       }
       my $module = "Agent::" . uc($type);
       if ($module->can("FRUS")) {
          my $rep = $module->FRUS($VAR1, $name);
          push(@LIST, @$rep);
       }
  }
  $REP = \@LIST;
  bless($REP, 'Reports::Fru');
  Util->serialize($F, $REP);
  $ERR = $out;
  Process->done("fru_report");
  return $REP;
}

$OK = ",online,ok,ok-on,ready-enabled,normal," .
      "online-online,o.k.,-,drive_inserted,n/a,global spare,dummy-disabled,on,standing by,notinstalled-enabled,"
      ;

sub health {
  my($class, $REP) = @_;
  my @NEW;
  foreach my $el  (@$REP) {
    my $st = Util->trim($el->[8]);
    next if (index($OK, lc(",$st,") ) >= 0);
    push(@NEW, $el);
  }
  return \@NEW;
}


sub summ1 {
  my($REP, $AG, $adm_group) = @_;
  my (@R,%R);
  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $dev  = $el->[1];
     my $typ  = $el->[2];

     my $vendor = $el->[4];
     my $model  = $el->[5];
     my $rev    = $el->[7];
     $R{"$name\t$dev\t$typ\t$vendor\t$model\t$rev"}++;
  }
  foreach my $el (sort keys %R) {
     my($name, $dev, $type, $vendor, $model, $rev) = split(/\t/, $el);
     my $tot = sprintf("%6d", $R{$el});
     push(@R, [$name, $dev, $type, $vendor, $model, $rev, $tot]);
  }
  return \@R;
}

sub summ2 {
  my($REP, $AG, $adm_group) = @_;

   my (%R, @R, $tot);
  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $dev  = $el->[1];
     my $typ  = $el->[2];

     my $vendor = $el->[4];
     my $model  = $el->[5];
     my $rev    = $el->[7];
     $R{"$dev\t$typ\t$vendor\t$model\t$rev"}++;
  }
  foreach my $el (sort keys %R) {
     my($dev, $type, $vendor, $model, $rev) = split(/\t/, $el);
     my $no = sprintf("%6d", $R{$el});
     my $lnk = $no; # "<a href=<a href=$Http::WEBPROC?GO=GUI::FruReport::summ3>$no</a>";
     push(@R, [$dev, $type, $vendor, $model, $rev, $lnk]);
     $tot += $no;
  }
  return(\@R, $tot);
}

sub battery {
  my($REP, $AG, $adm_group) = @_;
  my (@R,%R);
  my $tot;
  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $dev  = $el->[1];
     my $typ  = $el->[2];
     my $fru  = $el->[3];
     next if ($typ ne "power.battery");
     $tot++;
     my $rev    = $el->[7];
     my $bat_age = $el->[10];
     my $dis = &print_age($bat_age);
     push(@R, ["<sort ".sprintf("%7.7d", $bat_age + 10000).">$dis", $name,$fru]);
  }
  return (\@R, $tot);
}

# age is hours

sub print_age {
  my($age) = @_;
  if ($age == 0) {
     return "Data Not Available";
  } elsif ($age < 0) {
     my $days = 0 - int($age / 24);
     return "<b>PAST REPLACEMENT DATE (by $days days)";
  } else {
     my $days = int($age / 24);
     my $dd = "$days days " if ($days > 0);
     my $hours = $age - $days * 24;
     if ($days < 38) {
       return "<b>$dd $hours hrs";
     } else {
       return "$dd $hours hrs";
     }
  }
}


sub reboot {
  my($REP, $AG, $adm_group) = @_;
  my (@R,%R);
  my ($tot, %SUM);
  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $typ  = $el->[2];
     my $cat  = $el->[1];
     next if ($typ ne "controller");
     $SUM{"$cat\t$name"} = $el->[10];
  }
  foreach my $el (keys %SUM) {
     my($type, $name) = split(/\t/, $el);
     $tot++;
     push(@R, [$type, $name, sprintf("%7.7d", $SUM{$el})]);
  }
  return (\@R, $tot);
}

# arg->{ucl}, return only frus that are abovr UCL

sub temperature {
  my($REP,$AG, $adm_group, $arg) = @_;
  my (@R, %T, $tot);
  my (@Temp);
  my $ucl_only = $arg->{ucl};

  foreach my $el (@$REP) {
    my $temp = $el->[9];
    my $name = $el->[0];
    next if ($adm_group && ($AG->{$name} ne $adm_group));
    next if (!$temp);
    $temp = 100 if ($temp > 100);
    $temp = 0   if ($temp < 0);
    push(@Temp, $el->[9]);
  }

  my($std, $avg, $lcl, $ucl) = Math->std_dev(\@Temp);

  if ($ucl_only) {
    foreach my $el (@$REP) {
      my $name = $el->[0];
      next if ($adm_group && ($AG->{$name} ne $adm_group));
      my $dev  = $el->[1];
      my $typ  = $el->[2];
      my $fru  = $el->[3];
      next if (!defined $el->[9]);

      my $temp = int($el->[9]);
      $temp = 0 if ($temp <= 0 );
      $temp = 100 if ($temp >= 100);
      if ($temp >= $ucl) {
        push(@R, $el); 
        $tot++;
      }
    }
    return (\@R, $tot, $std, $avg, $lcl, $ucl);
  }
     
# return a temperature distribution

  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $dev  = $el->[1];
     my $typ  = $el->[2];
     my $fru  = $el->[3];
     next if (!defined $el->[9]);

     my $temp = int($el->[9]);
     $temp = 0 if ($temp <= 0 );
     $temp = 100 if ($temp >= 100);
     $T{$name}[$temp]++;
  }
  my($x);
  foreach my $name (sort keys %T) {
     my $val = $T{$name};
     my ($list, $low, $high);
     $low = 1000;
     for ($x=0; $x <= $#$val; $x++) {
         my $v = $val->[$x];
         $low  = $x if ($v && $x < $low);
         $high = $x if ($v && $x > $high);
         $v = "X" if ($v > 9);
         if ($x <= $lcl || $x >= $ucl) {
           $v = "<b><font color=red>$v</font></b>";
         } elsif ($x == int($avg+ 0.5)) {
           $v = "<b><font color=blue>$v</font></b>";
         }
         $list .= $val->[$x] ? $v : " ";
     }
     $tot++;
     push(@R, [$name, "<pre>$list", $low, $high]);
  }
  return (\@R, $tot, $std, $avg, $lcl, $ucl);
}


sub glist {
  my($REP,$AG, $adm_group, $arg) = @_;
  my (@R, %T, $tot);
  my (@Glist);
  my $ucl_only = $arg->{ucl};

  foreach my $el (@$REP) {
    my $temp = $el->[11];
    my $name = $el->[0];
    next if ($adm_group && ($AG->{$name} ne $adm_group));
    push(@Glist, $el->[11]);
  }

  my($std, $avg, $lcl, $ucl) = Math->std_dev(\@Glist);

  if ($ucl_only) {
    foreach my $el (@$REP) {
      my $name = $el->[0];
      next if ($adm_group && ($AG->{$name} ne $adm_group));
      my $dev  = $el->[1];
      my $typ  = $el->[2];
      my $fru  = $el->[3];
      my $glist = $el->[11];
      $glist    = 50 if ($glist > 50);
      if ($glist >= $ucl) {
        push(@R, $el); 
        $tot++;
      }
    }
    return (\@R, $tot, $std, $avg, $lcl, $ucl);
  }
     
# return a temperature distribution

  foreach my $el (@$REP) {
     my $name = $el->[0];
     next if ($adm_group && ($AG->{$name} ne $adm_group));
     my $dev  = $el->[1];
     my $typ  = $el->[2];
     my $fru  = $el->[3];
     my $glist = $el->[11];
     $glist    = 50 if ($glist > 50);
     $T{$name}[$glist]++;
  }
  my($x);
  foreach my $name (sort keys %T) {
     my $val = $T{$name};
     my ($list);
     my $high = 0;
     my $low  = 1000;
     for ($x=0; $x <= $#$val; $x++) {
         my $v = $val->[$x];
         $low  = $x if ($v && $x < $low);
         $high = $x if ($v && $x > $high);
         $v = "X" if ($v > 9);
         if ($x <= $lcl || $x >= $ucl) {
           $v = "<b><font color=red>$v</font></b>";
         } elsif ($x == int($avg+ 0.5)) {
           $v = "<b><font color=blue>$v</font></b>";
         }
         $list .= $val->[$x] ? $v : " ";
     }
     $tot++;
     push(@R, [$name, "<pre>$list", $low, $high]);
  }
  return (\@R, $tot, $std, $avg, $lcl, $ucl);
}

1;

