package Revision::3510;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::3510;
use PDM::ConfigFile;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.3510"}
sub description {"Sun StorEdge 3510  FC array firmware/disk"}
sub type {"3510"}


sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my(@R);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;

  my $dtype = $class->getLocalType();
  my $agent= "Agent::".$dtype;
  foreach my $dev (@$devs) {
      next if ($dev->{type} ne $dtype);
      next if (!Util->isMineToMonitor($dev));
      my ($wwn, $err, $report) = $agent->INSTRUMENTATION($dev);
      if ($err eq "BUSY") {
         my $info = "The $dtype device is busy, please run revision check later";
         push(@R,[$dtype, $dev->{name}, 'ERR', undef, undef,undef,undef, $info]);
      } elsif ($err =~ /not accessible/){
         my $info = "The $dtype device is not accessible, please check system setup ";
         push(@R,[$dtype, $dev->{name}, 'ERR', undef, undef,undef,undef, $info]); 
      } else {
         my $r1 = $class->REVISION($Matrix,  $InstalledPatches, $dev, $report, $dtype);
         push(@R, @$r1);
      }
  }
  if ($#R < 0) {
      push(@R,[$dtype, 'N/A', 'ERR', undef, undef,undef,undef,"No $dtype device, please check system setup"]);
  }
  return \@R;
  
}

# runs on only one device, dev is from the configFile
#
sub REVISION {
  my( $class, $Matrix, $InstalledPatches, $dev, $rep, $type) = @_;
  my ( $mat, @R , @R1);
  my $mat = $Matrix->{$type};    
  my ($vendor, $model, $tem1, $tem2, $firm_rev);

  my $firm_rev = $rep->{'info.firmware_version'};
  my $dev_type = $type;

  push(@R, $class->check_firmware("$dev_type"."_Controller_FW",undef,$firm_rev, $dev, $mat, "firmrev", undef,undef));
 
  foreach my $el (keys %$rep) {
      if (($el =~ /components.disk/) && ($el =~ /product_revision/)) {
         my $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $vendor = $rep->{"$pre.manufacturer"};
         my $model  = $rep->{"$pre.model"};
         my $val    = $rep->{"$pre.product_revision"};

         if ($model) {  #  $model = '' means dummy disk, skip it
            push(@R1,$class->checkDiskFirmware_3510($Matrix, $InstalledPatches, $vendor, $model, $val,$dev,$pre,$dev_type));
         }
     } elsif ($el =~ /ses.(\d+).idx/) {
         my   $ix = rindex($el, ".");
         my $pre = substr($el, 0, $ix);
         my $ses_rev = $rep->{"$pre.rev"};
         push(@R, $class->check_firmware("$dev_type"."_SES_FW", undef, $ses_rev, $dev, $mat, "rev", undef,$pre));
         my $pld = $rep->{"$pre.pld"};
         push(@R, $class->check_firmware("$dev_type"."_SES_PLD_FW",undef, $pld, $dev, $mat, "pld", undef, $pre));     
     }
  }

  my @SR1 = sort { $a->[1] cmp $b->[1] } @R1 ;
 
  push (@R, @SR1);
  return \@R;
}

sub checkDiskFirmware_3510 {
     my($class,$mat, $patch,$vendor, $model, $val, $dev,$elem ,$type) = @_;
     return $class->checkDiskFirmwareM($mat, $patch, $vendor, $model, $val,$dev,$elem,$type);
}

sub getLocalType {
    return &type();

}

1;
