package Revision::Switch_2G;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;
use Agent::SWITCH2;

use PDM::ConfigFile;
use Logic::SWITCH;
#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub class {"oob.switch2"}
sub description {"Sun StorEdge network 2Gb FC switch-8 and switch-16"}
sub type {"switch2"}

#IP:     172.20.67.191
#HW:     a03
#PROM:   30300
#FLASH:  b30345
#WWN:    100000c0dd006fc9
#MAC:    00c0dd006fc8

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
  my( $l, @R, $out);
   my ($wwn, $swtype, $userLabel);
  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read;
  my $se_version = System::get_se_version();

  foreach my $dev (@$devs) {
      my $r1;
      next if (!Util->isMineToMonitor($dev));
      next if  ($dev->{type} !~ "switch");

      if ($dev->{userLabel} eq "Switch2")  {  # host---switch case
         $r1 = $class->REVISION( $Matrix, $InstalledPatches, $dev);
         push(@R, @$r1);
      } elsif ( !$dev->{userLabel}) {    # sp-----switch case
         ($wwn, $swtype, $userLabel) = Logic::SWITCH->find_wwn($dev->{ip});
         if ( $userLabel eq "Switch2") {  # 2G switch  continue
             if ($se_version eq "2.3.1")  {
                 my $type = "231";
                 $r1 = $class->special_rev_check ($Matrix, $InstalledPatches, $dev, $type);
                 push(@R, @$r1);
             } elsif ($se_version eq "2.3.2") {
                 my $type = "232";
                 $r1 = $class->special_rev_check ($Matrix, $InstalledPatches, $dev, $type);
                 push(@R, @$r1);
             } elsif ($se_version eq "2.3.3") {
                 my $type = "233";
                 $r1 = $class->special_rev_check ($Matrix, $InstalledPatches, $dev, $type);
                 push(@R, @$r1);
             } else {             
                 $r1 = $class->REVISION( $Matrix, $InstalledPatches, $dev);
                 push(@R, @$r1);
             }
         }
      }

  }
  if ($#R < 0) {
      push(@R,["Switch_2G",'N/A','WARNING',undef, undef,undef,undef, "No 2Gb qlogic switch are present, please check system"]);
  }
  return \@R;
}

sub REVISION {
  my($class, , $Matrix, $InstalledPatches, $dev) = @_;
  my( $l, @R, %VERSION, $out);
  my $TO = 20;
  my $mat = $Matrix->{SWITCH_2G};
  my $info = "No infomation in the matrix you chose, please choose the latest vision matrix to run. If the problem still exists, please contact your SUN representative";
  my $info2 = "Cannot get version from this switch, please contact your SUN representative";
  my $el = $mat->{enc};

  if (!$el) {
     push(@R,["Switch_2G",$dev->{name},'ERR',undef, undef,undef,undef,$info]); 
  } else {
    my $out = Agent::SWITCH2->getVersion($dev, $TO );
    if (!$out->{Active_Firmware_image}) {
#     Debug->err(TEXT => "Cannot get version from switch $dev->{ip}");
     push (@R,["Switch",$dev->{name},'ERR',undef, undef,undef,undef,$info2]);
     # next;
     return \@R;
    }

   my $flash = $out->{Active_Firmware_image};
   
   push(@R, $class->switch_Compare("Switch", $flash, $dev, $mat, "enc"));
  }
   return \@R;
}

sub special_rev_check {
    my($class, , $Matrix, $InstalledPatches, $dev, $type) = @_;
    my($class, , $Matrix, $InstalledPatches, $dev) = @_;
    my( $l, @R, %VERSION, $out, $mat);
    my $TO = 20;
    if ($type eq "231") {
       $mat = $Matrix->{SPIMAGE_231};
    } elsif ($type eq "232") {
       $mat = $Matrix->{SPIMAGE_232};
    } else {
       $mat = $Matrix->{SPIMAGE_233};
    }
    my $info = "No infomation in the matrix you chose, please choose the latest vision matrix to run. If the problem still exists, please contact your SUN representative";
  my $info2 = "Cannot get version from this switch, please contact your SUN representative";
  my $el = $mat->{switch_2G_SP};

  if (!$el) {
     push(@R,["Switch_2G",$dev->{name},'ERR',undef, undef,undef,undef,$info]);
  } else {
    my $out = Agent::SWITCH2->getVersion($dev, $TO );
    if (!$out->{Active_Firmware_image}) {
#     Debug->err(TEXT => "Cannot get version from switch $dev->{ip}");
     push (@R,["Switch",$dev->{name},'ERR',undef, undef,undef,undef,$info2]);
     # next;
     return \@R;
    }

   my $flash = $out->{Active_Firmware_image};
  
   push(@R, $class->switch_Compare("Switch", $flash, $dev, $mat, "switch_2G_SP"));
  }
   return \@R;


}


1;



