package Revision::V880DISK;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base 'Revision';
use System;
use Util;

#
#  PASS, LOW, HIGH, NI (not installed), ERR

sub description {"Sun Fire V880 Disk Firmware"}
sub class {"oob.V880DISK"}
sub type {"v880disk"}

sub RUN {
  my($class, $Matrix, $InstalledPatches) = @_;
 
  ########################################
  # create a Daktari enclosure list      #
  ######################################## 
  my $di = run_dak_inquiry();
  my @dak_enc_list;
  my @R;

   if ($#dak_enc_list<=0) {
    push(@R,["V880Disk",'N/A','WARNING',undef, undef,undef,undef, "No v880 disks are present, please check system setup"]);
       return \@R;
  }

  foreach my $line (@$di) {
        if (($line =~ /Name/) && ($line =~ /SUNWGS INT FCBPL/)){
              my($v1,$v2,$v3,$v4)=split(/:/,Util->ltrim($line));            
              my ($box_name,$v5,$v6) = split(/\s+/,$v2);
#              print "$box_name\n";
              push(@dak_enc_list, $box_name);
        }
  }

  my $enc_ptr = \@dak_enc_list; 
  my $rc1 = $class->checkDakFirmware($Matrix, $InstalledPatches,$enc_ptr);
  my $rc2 = $class->checkDak_Disk_Firmware($Matrix, $InstalledPatches,$enc_ptr);
  return [@$rc1,@$rc2];
}

my $DI;
sub run_dak_inquiry() {
   my ($var) = @_;
   my($l, @L);
   my $F = "luxadm probe";
   open(O, "$F 2>&1|");
   while ($l = <O>) {
    push(@L, $l);
  }
  close(O);
  $DI = \@L;
  sleep(1);
  return $DI;
}

sub checkDak_Disk_Firmware{
    my($class, $Matrix, $InstalledP, $dak_list) = @_;
    my $dak_disk_fw = $Matrix->{DAKTARI_DISK_FW};
    my $category = "V880_DISK_FW";
    my $T0=60;
    my($luxcmd) = System->find_luxadm;
    my @L;
    my $tem1;
    my $tem2;
    my $tem3;
    my $dev_wwn;
    my ($l, @Li);
    foreach my $box (@$dak_list){
        my $file = "luxadm display $box";
        my $done = 0;
        if (open(tem, "$file 2>&1|")) {
               while ($l = <tem>){
                      next if (($l !~ /On/) || ( $l =~ /failed/ ) );
                      ($tem1, $tem2, $tem3, $dev_wwn) = split (/\s+/, $l); 
                      push (@Li, $dev_wwn);
#                      print "$dev_wwn\n";
               }
               close(tem);
        }
        else{
#               print "err\n";
        }
    }
    my $mylist = \@Li; 
    #########################################################
    #  At this point, we have all dak wwn in the list Li    # 
    #########################################################
   
   foreach my $device (@$mylist) {
         my($err,$com) = Util->run_command("$luxcmd display  $device 2>&1", "luxdakdisk.txt", $T0);
         if ($err){
                  push(@L, [$category, $device, 'ERR', undef, undef,undef,undef, "luxadm display command failed"]);
         } else {
                my $curr_fw;
                my $req_fw;
                my $vendor;
                my $comp;
                my $prod;
                foreach my $l (@$com) {
                           
                     if ($l =~ /Revision/){
                         $l =~ s/^\s+//; # strip the leading white space
                         ($tem1, $curr_fw) = split (/\s+/,$l);
                     } elsif ($l =~ /Vendor/) {
                         $l =~ s/^\s+//; # strip the leading white space
                         ($tem1, $vendor) = split (/\s+/,$l);
                     } elsif ($l =~ /Product/) {
                         $l =~ s/^\s+//; # strip the leading white space
                         ($tem1, $tem2, $prod) = split (/\s+/,$l);
                     }
                }     
                my $key= "$vendor:$prod:DAKTARI";
                if ( $dak_disk_fw->{$key} ){
                     my $d = $dak_disk_fw->{$key};
                     my $req_fw = $d->[0];
                     my $req_patch = $d->[2];
                     
                     $comp = $class->compareDiskFwLevels($curr_fw, $req_fw);
                     if ( $comp==0) {
                                push(@L, [$category, $device,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                     } elsif ($comp>0) {
                                push(@L, [$category, $device,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                     } elsif ($comp<0){
                                push(@L, [$category, $device,'DOWNREV',$curr_fw, $req_fw,undef,$req_patch,undef]);
                     }
               }else{
#                    print "err\n";
               }
     
         }
   }
   return \@L;
      
    
}


sub checkDakFirmware {
       my($class, $Matrix, $InstalledP, $dak_list) = @_;
       my $dak_fw = $Matrix->{Daktari};
       my $category = "Sun Fire V880 Product Revision";
       my $key = "firm";
       my $T0=60;
       my($lux) = System->find_luxadm;
       my @L;
       my $d = $dak_fw->{$key};
       my $req_fw = $d->[0];
       my $patch  = $d->[1];
       my $desc =   $d->[2];

       my $os_level = $class->get_s8_level();
       foreach my $box (@$dak_list){
               my($err,$com) = Util->run_command("$lux display  $box 2>&1", "luxdak.txt", $T0);
               if ($err){
                      push(@L, [$category, $box, 'ERR', undef, undef,undef,undef, "luxadm display command failed"]);
               } else {
                       foreach my $l (@$com) {
                             next if ($l !~ /FW Revision/);
                             my ($v1,$v2,$v3) = split (/:/, $l);
                             my ($curr_fw, $rest) = split (/\s+/,$v2);
                             my $comp;
                             $comp = $class->compareFwLevels($curr_fw, $req_fw);
                             if ( $comp==0) {
                                  push(@L, [$category, $box,'PASS',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ($comp>0) {
                                  push(@L, [$category, $box,'UPREV',$curr_fw, $req_fw,undef,undef,undef]);
                             } elsif ($comp<0){
                                  if (($os_level == 9) || ($os_level >= 8)) { # solaris 9 or solaris 8 update level is 7 later, no need to patch
                                      push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw,undef,"N/A","No patch available, please contact your SUN representative"]);
                                  } elsif ($os_level == -1) { # can not get os update level
                                      push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw,undef,"N/A","No patch available, please contact your SUN representative"]);
                                  } else {  # os 8 update level 4,5,6 ,7  
                                      push(@L, [$category, $box,'DOWNREV',$curr_fw, $req_fw,undef,$patch, $desc]);
                                  } 
                             }

                      }
             }
       }

       return \@L;
}


1;

