package Service::Advisor;
use Html;
use strict 'vars';
use Html::Screen;
use Report;
use System;
use Service::Fru;
use Advisor;
use LockManager;
use Events;

sub user_name {
  my $ip   = $ENV{REMOTE_ADDR} || $ENV{REMOTE_USER};
  my @A = split(/\./, $ip);
  my $ruser = System->get_ruser();
  return lc($ruser->{userid}) . "_" .  $A[$#A];
}

sub reserve_status {
  
  my $L = Labels->read("Service::Advisor");
  my $lock = LockManager->new();
  my $locki = $lock->exists("system", 1) || {};
  if ($locki->{pid}) {
    my ($app, $key, $desc, $start, $mins, $ip, $name) = split(/\|/, $locki->{info});  
    my $hours = int($mins / 60);
    return Html->warning($L->expand(already_reserved => $name,$start,$hours,$desc));
  }
}
  

sub reserve {
  my($q) = @_;
  print Html->body();
  #foreach my $e (keys %$q) {print "$e = $q->{$e}<br>"}
  my $G = Labels->read();
  if ($q->{WIN}) {
    print Html->header2("service.wizard.reserve", undef, undef, undef, 
           { popup => $q->{WIN}, noHelp => 1 });
  } else {
    print Html->header2("service.wizard.reserve", undef, undef, undef, {noDoc => 1});
  }

  my $L = Labels->read("Service::Advisor");
  #foreach my $e (keys %ENV) {print "$e=$ENV{$e}<br>"}
  my $reserved;

  if ($q->{ACTION_release}) {
    my $lock = LockManager->new();
    my $current = $lock->read("system");
    my $rc = $lock->unlock("system");
    print Html->info($L->{now_released});
    Events->saveEvent("SL", $current->{info}); # service-release

  } elsif ($q->{ACTION_reserve} || $q->{ACTION_force}) {
    if (!$q->{name} || !$q->{desc}) {
      print Html->warning($L->{enter_all});
    } else {
      my $lock = LockManager->new();
      my $time = 60*60 * ($q->{expires}||1);
      my $ip   = $ENV{REMOTE_ADDR} || $ENV{REMOTE_USER};
      
      my $mins = $q->{expires} * 60;
      $q->{desc} =~ s/\|//g;
      my $info = "service|$q->{key}|$q->{desc}|" . Util->get_today() . "|$mins|$ip|$q->{name}";
      my $rc = $lock->lock("system", $time, 0, $info, {force => $q->{ACTION_force}});
      if ($rc) {
         print Html->info($L->expand(now_reserved => $q->{name},$q->{expires}));
         Events->saveEvent("SR", $info); # service-reserve
         $reserved = 1;
      } else {
         my $err = $LockManager::ERR || $L->{already};
         print Html->error($err);
      }
    }
  }

  my $lock = LockManager->new();
  my $locki = $lock->exists("system") || {};
  my ($app,$key, $desc, $start, $mins, $ip, $name) = split(/\|/, $locki->{info});  # name|desc|date
  my $hours = int($mins / 60);
  my $user  = &user_name();
  if ($locki->{pid} && $key eq $user) {
    print Html->warning($L->{currently_own});
    my $scr = Html::Screen->new();
    $scr->add(" <form method=post>
      <input type=hidden name=GO value=Service::Advisor::reserve>
      <input type=hidden name=WIN value=$q->{WIN}>
      <input type=hidden name=key value=$q->{key}>
     ");

    $scr->table( { title => $L->{title_release} , labelWidth => "40%" },
     [
     [ f =>  $L->{name}, $name ],
     [ f =>  $L->{date}, $start],
     [ f =>  $L->{desc}, $desc ],
     [ f =>  $L->{expires}, $hours . " " . $L->{hrs} ],
     ]); 
    $scr->button2( [
     [ l => 'ACTION_release',    $L->{submit_release} ],
     ]);
    $scr->add("</form>");
    print $scr->out();
    return;
  }
  my $already;
  if (!$reserved && $locki->{pid}) {
    print Html->warning($L->expand(warn1 => $name, $start, $hours, $desc));
    $already = 1;
  }
  my $user_name = &user_name(); 
  my $scr = Html::Screen->new();

  $scr->add(" <form method=post>
      <input type=hidden name=key value=$user_name>
      <input type=hidden name=GO value=Service::Advisor::reserve>");

  my $expires = Html->makeSelect("expires", "1|2|3|4|5|6|12|24");
  my $mand    = "&nbsp;<font color=red size=+2>*</font>";


  $scr->table( { title => $L->{title2} , labelWidth => "40%" },
   [
   [ f =>  $L->{name}, "<input type=text size=20 name=name value=\"$user_name\">$mand" ],
   [ f =>  $L->{desc}, "<input type=text size=30 name=desc>$mand" ],
   [ f =>  $L->{expires}, $expires . $L->{hrs} ],
   ]);

  $scr->button2( [
   [ l => 'ACTION_reserve',    $L->{submit_reserve} , $already],
   [ l => 'ACTION_force',    $L->{submit_force} ,     !$already],
   ]);
   
  $scr->add("</form>");
  print $scr->out();

}



sub clean_req {
  my($q) = @_;
  foreach my $e (keys %$q) {
     my $v = $q->{$e};
     my $i = rindex($v, "\t");
     if ($i > 0) {
      $q->{$e} = substr($v,$i+1);
     }
     if (substr($e,0,9) eq "ACTION_NP") {
        my($pk, $fun) = Advisor::parse(substr($e,10), $q);
        $q->{SVC_PAGE} = $fun;
     }
  }
  foreach my $e (keys %$q) {
     #print "$e=$q->{$e}<br>";
  }
}

sub helpW {
  my($q) = @_;
  $q->{WINDOW} = 1;
  &help($q);
}

sub help {
  my($q) = @_;

  my $renv = System->get_renv();
  print Html->body();
  &clean_req($q);
  my $page = $q->{SVC_PAGE};
  my $from = $q->{FROM};
  my $node = $q->{NODE};

  my $nav   = Navigation->read(1, "service");
  my $node  = $nav->node($node);
  my $LB = Labels->read("Service::Advisor");

  my $crumbs ;
  if ($from) {
     $crumbs .= "$from > "; #"<a href=/rashttp?GO=Service::Advisor::help&SVC_PAGE=$from>$from</a> > ";
  }

  my $l1 = $q->{menu};
  my $args = {noTitle => 1, noCrumb => 1, noDoc => 1, noTabs => 1};

  # FRU ALREADY SELECTED
  if ($q->{_SELECTED}) {
     ($q->{KEY}, $q->{FRU}, $q->{DEV_NAME}) = split(/\:/, $q->{_SELECTED});

  # THERE IS A FRU_TYPE, CALL THE FRU-SELECTOR SCREEN 
  } elsif ($q->{fru_type}) {#  && !$q->{fru}) {
    print Html->header2($l1, undef, $node->{title}, undef, {noDoc => 1} );
    print "<table border=0 width=$Style::WIDTH><tr><td>$LB->{info}</table>";
    $q->{_BACK} = "Service::Advisor::help";
    Service::Fru::select($q);
    return;
  }
  # SHOW THE ADVISOR PAGE

  if (index($page, "::") > 0)  {
     my($file0, $file1) = Advisor::parse($page, $q);
     eval "require $file0";
     &$file1($q);
     return;
  }

  print Html->header2($l1, $Style::WIDTH, $node->{title}, undef, {noDoc => 1}) if (!$q->{WINDOW});

  print Advisor->functions();
  print "
  <table border=0 cellspacing=0 cellpadding=0><tr><td><form></table>
  <input type=hidden name=GO value=Service::Advisor::help></center>";
  foreach my $e (keys %$q) {
     next if ($e eq "SVC_PAGE" || $e eq "FROM" || $e eq "GO" || substr($e,0,6) eq "COOKIE");
     next if (substr($e,0,7) eq "ACTION_");
     print "<input type=hidden name=$e value=\"$q->{$e}\">";
  }
  #foreach my $e (keys %$q) {print "$e=$q->{$e}<br>"}


  my $wiz = {};
  my $opage = Html->readHtdocs($page);
  $opage    = Advisor->process($opage, $page, $wiz, $q);
  
  if ($wiz->{max}) {  # WIZARD
     my $step = $q->{STEP} || 1;
     &wizard($opage, $step, $wiz, $page, $q);
     
  } else {
     print $opage;
  }
  print "</form>";
  if ($renv->{service_debug}) {
    print "<table border=0 width=$Style::WIDTH><tr><td align=right>$crumbs $page</table>";
  }
}

           
  

sub wizard {
  my($text, $step, $wiz, $page, $q) = @_;
  my ($x, $out); 

  my $delim = " | ";
  $delim    = "<br>";
  my $header = "<table border=0 cellspacing=0 cellpadding=2><tr><td>";
  my $args = Html->makeArgs($q, "SVC_PAGE,STEP,SECTION");

  for ($x=1; $x <= $wiz->{max}; $x++) {
    my ($b, $bold, $link);
    my $desc = $wiz->{$x};

    if ($x == $step) {
      $header .= "<b>$x-$desc</b>";
    } else {
      $link = "<a href=/rashttp?GO=Service::Advisor::help$args&SVC_PAGE=$page&STEP=$x&SECTION=$q->{SECTION} class=t10><font color=blue>$x-$desc</font></a>";
      $header .= $link;
    }
    if ($x < $wiz->{max}) {
       $header .= $delim;
    }
  }
  for ($x=$wiz->{max}; $x <= 20; $x++) {
       $header .= "<br>";
  }
  $header .= "</table>&nbsp;";
  my $PAGE;
  my @L = split(/\n/, $text);
  my $first = 1;
  my ($in);
  foreach my $l (@L) {
    if ($l =~ /<svc step=(\d+) name/) {
       my $st = $1;
       if ($first) {
          #$PAGE .= $head;  
          $first = 0; 
       }
       $in = $st;
    } elsif (!$in) {
       $PAGE .= $l;
    } elsif ($in == $step) {
       $PAGE .= $l;
    }
  }

  my ($prev, $next);
  if ($step > 1) {
     $prev = "<a href=/rashttp?GO=Service::Advisor::help$args&SECTION=$q->{SECTION}&SVC_PAGE=$page&STEP=" . ($step-1) . ">Prev Step</a>";
  }
  if ($step < $wiz->{max}) {
     $next = "<a href=/rashttp?GO=Service::Advisor::help$args&SVC_PAGE=$page&SECTION=$q->{SECTION}&STEP=" . ($step+1) . ">Next Step</a>";
  }
  my $sep = " | " if ($prev && $next);
  my $footer = "&nbsp;<p>[ $prev $sep $next ]";

  #print "$header $PAGE $footer";
  print "<table border=0 width=$Style::WIDTH cellspacing=2 cellpadding=2>
          <tr><td width=10%>
                 <table border=1 cellspacing=0><tr><td nowrap>$header</table>
              </td>
              <td valign=top>$PAGE</b><br>$footer
              </td>
        </table>";

}


use GUI::Navigation;

sub menu {
  my($q) = @_;
  my ($out);
  print Html->body();
  print Html->header2($q->{menu}, undef, undef, {noTitle => 1});
  my $renv  = System->get_renv();
  my $ruser = System->get_ruser();
  my $role  = $ruser->{role};
  my $nav   = Navigation->read(1, "service");
  my $L     = Labels->read("Service::Advisor");
  my $G     = Labels->read();
  my $S     = Labels->read("Service::Util")->section("telnet");;

  my $nav1 = $nav->{$q->{ROOT}};
  if ($nav1->{info}{password}) {
     my $rc;
     if ($q->{_PASSW}) {
        require MIME::Base64;
        my $a = MIME::Base64::encode($q->{_PASSW});
        chomp($a);
        if ($a eq $nav1->{info}{password}) {
            $rc = 1;
        } else {
            $rc = 0;
            print Html->warning($L->{invalid});
        }
     }
     if (!$rc) {
        my $scr = Html::Screen->new();
        $scr->add(" <form  method=get>
           <input type=hidden name=GO value=Service::Advisor::menu>
           <input type=hidden name=ROOT value=\"$q->{ROOT}\">
           <input type=hidden name=menu value=\"$q->{menu}\">
                 ");

        $scr->table( { title => $G->{enter_pass}}, 
           [
           [ f => $S->{pass}, "<input type=password name=_PASSW size=20>"],
           ]);
        $scr->button2([
           [ l => 'ACTION', "Submit"],
           ]);
        $scr->add("</form>");
        print $scr->out();
        return;
     }
  }

  my($toc0,$cnt0) = &menu_($ruser, $renv, $nav, $q->{ROOT} || "ROOT", 0, $q);

  print "
   <table border=1 cellspacing=0 cellpadding=3 bgcolor=white width=$Style::WIDTH>
     <tr><td colspan=2 bgcolor=$Style::DARK><img src=/gif/dot_clear.gif height=6></td>$toc0
   </table>";
}

sub menu_ {
  my($ruser, $renv, $nav, $node, $level, $q) = @_;
  my($out, $cnt, $i);
  my $nav1 = $nav->{$node};
  my @O = split(/,/, $nav1->{order});

  my $last;
  for ($i=0; $i <= $#O; $i++) {
    my $el = $O[$i];
    my $item = $nav1->{items}{$el};
    my $sp = "&nbsp;&nbsp;&nbsp;" x ($level) if ($level > 0);

    my $act = Navigation::active($item, $ruser, $renv);
    next if ($act == 0);

    my $indent = $level == 0 ? "$sp" : "$sp-";

    if (substr($item->{url},0,1) eq ">") {
      my $t1;
      my $u = $item->{title};

      if ($level == 0) {
        $t1 = "<tr><td></td><tr bgcolor=$Style::LIGHT><td width=30%>$indent$u</td>";
        $t1 .= " <td>$item->{desc}</td>\n";
      } else {
        $t1 = "<tr><td width=30%>$indent$u</td>";
        $t1 .= " <td>$item->{desc}</td>\n";
      }
      my ($out0, $cnt0) = &menu_($ruser, $renv, $nav, substr($item->{url},1), $level+1, $q);
      $out .= $t1 if ($cnt0);
      $out .= $out0;
      $cnt+= $cnt0;

    } else {
      $cnt++;
      my $l1;
      if ($item->{title} ne $last) {
         $l1 = $item->{title}; $last = $item->{title};
      }
      $out .= "<tr><td width=30% align=right><b>$l1</td><td>$indent<a href=/rashttp?GO=$item->{url}&NODE=$node.$el&menu=$q->{menu}>$item->{desc}</a></td>";
    }
  }
  return ($out, $cnt);
}


1;
