package Service::Extract;
use strict;
use System;
use Process;

# return 0: already running
#        1: started

sub start {
   my($q) = @_;

   if (Util->findProcessByName("\/se_extract")) {
       return 0;
    }
    my $tt = "-t $q->{password}" if ($q->{password});
    my $command =  System->get_home() . "/sysbin/se_extract -r -d 2 $tt -b";
    system($command);
    sleep(1);
    return 1;
}

sub run {
  my($q) = @_;
  my $info;
  print Html->body();
  my $out = Html->header2("monitor.utilities.extract");
  my $deny  = Roles->verifyRole($q, "admin");


  my $G = Labels->read();
  my $LB = Labels->read("Service::Extract");
  my $LC = Labels->read("Service::Core");
  my $del = 0;

  if ($q->{ACTION_selected}) {
    foreach my $e (keys %$q) {
       if (substr($e,0,4) eq "del_") {
          my $f = substr($e,4);
          unlink $f;

	  $f =~ s/extract/log/;
	  $f =~ s/tar/txt/;
	  unlink $f;
          $del++;
       }
    }
  }
  if ($q->{ACTION_run}) {
    if (Util->findProcessByName("\/se_extract")) {
       print $out;
       print Html->warning($LB->{running});
       return;
    }
    my $tt = "-t $q->{password}" if ($q->{password});
    my $command =  System->get_home() . "/sysbin/se_extract -r -d 2 $tt -b";
    system($command);
    sleep(1);
    $info = Html->info($LB->{starting});
  }

  my ($status, $pid1) = Process->status(undef, "Extract");
  my ($run, $meta);
  if ($status =~ /Running/) {
     $meta = "<meta http-equiv=Refresh content=\"10;URL=$Http::WEBPROC?GO=Service::Extract::run\">";
     $run = "
        <tr><td align=right bgcolor=$Style::LIGHT>
            <table border=0><tr><td>$LB->{ex_st}:</table></td>
            <td colspan=2><b>&nbsp;$G->{running} ($G->{pid}=$pid1)";
  } else {
    $run = "
      <tr><td align=right bgcolor=$Style::LIGHT width=40%>$LB->{password}:</td>
      <td colspan=2> <input type=password name=password size=20>
      <tr><td colspan=3 bgcolor=$Style::BGCOLOR> " .
       Html::Screen->submitButton("ACTION_run", $LB->{submit_run}) ;
  }

  print <<EOF;
  $meta
  $out
<script>
    function win2(t) {
      var b = '$Http::WEBPROC?GO=Service::Extract::logfile&file=' + t;
      var O = window.open(b,'hist','menubar=no,resizable=yes,scrollbars=yes,width=600,height=600');
      O.focus();
    }
</script>
$info
<table border=1 cellspacing=0 cellpadding=2 bgcolor=white width=$Style::WIDTH>
  <tr bgcolor=$Style::DARK><td colspan=3>
      <form><input type=hidden name=GO value=Service::Extract::run>
      <font color=white><b>$LB->{start}</td>
   $run
EOF
  print "</table></form><br>";
  opendir(O, System->get_home() . "/DATA/Download/Solution");
  my @D = readdir(O); closedir(O);
  my $cnt;
  my (@array, $l, @L);

  foreach my $d (reverse sort @D) {
     if ($d =~ /extract_(.+)\.tar/) {
         my $d1    = $1;
         my $ix    = index($d1, "_");
         my $model = substr($d1, 0, $ix);
         my $date  = substr($d1, $ix+1);
         my $date2 = substr($date,0,13) . ":" . substr($date,13,2) .":" . substr($date,15,2);
         my $size  = Util->fileSize(System->get_home() . "/DATA/Download/Solution/$d");
         $size     = int($size/1000);
	 $size .= " K";

         my $url1 = "<a href=/Download/Solution/$d>$date2</a>";
         my $url2 = "[ <a href=javascript:win2('${model}_$date')>$LB->{review}</a> ]";
	 my $l = System->get_home() . "/DATA/Download/Solution/" . $d;
	 push(@array, [ "<input type=checkbox name=del_$l>", $url1, $size, $url2 ] );

         $cnt++;
     }
  }
  print "<tr><td colspan=3>$LB->{no_report}</td>" if (!$cnt);

  my $scr = Html::Screen->new();
  print Html->info("$del $LC->{file_del}") if $del;

  $scr->add(" <form><input type=hidden name=GO value=Service::Extract::run>");

  $scr->list($q, { title => "$LB->{download}", interactive => 1 },
    [
    [ c => "$LC->{delete}"],
    [ l => "$LB->{down}", "+" ],
    [ l => "$LB->{file}", "+" ],
    [ l => "$LB->{review}" ],
    ],
    \@array,
    [
      [ l => "ACTION_selected", "$LC->{del_sel}", $deny ],

    ]
    );
   $scr->add("</form>");
   print $scr->out();
}

sub logfile {
  my($q) = @_;

  print Html->body(undef, {color => "white"});
  my $LB = Labels->read("Service::Extract");

  print "</center>";
  print "<table border=0 width=100% bgcolor=$Style::LIGHT>
  <tr><td>&nbsp;<b>$LB->{log2}: $q->{file}</table>";

  open(O, System->get_home() . "/DATA/Download/Solution/log_$q->{file}.txt");
  my @l = <O>;
  close(O);
  print "<pre>";
  print join("", @l);
}

sub list {
  my(@L);
  opendir(O, System->get_home() . "/DATA/Download/Solution");
  my @D = readdir(O); closedir(O);
  my $cnt;
  foreach my $d (reverse sort @D) {
     if ($d =~ /extract_(.+)\.tar/) {
         my $d1    = $1;
         my $ix    = index($d1, "_");
         my $model = substr($d1, 0, $ix);
         my $date  = substr($d1, $ix+1);
       my $date2 = substr($date,0,13) . ":" . substr($date,13,2) .":" . substr($date,15,2);
         my $size  = Util->fileSize(System->get_home() . "/DATA/Download/Solution/$d");
         $size     = int($size/1000);

         push(@L, { download_url => "/Download/Solution/$d",
                    date => $date2,
                    log => "${model}_$date",
                    size => $size });

     }
  }
  return \@L;
}


1;
