package Service::Fru;
use Report;
use PDM::ConfigFile;
use strict 'vars';
#
# MAKE A LIST OF FRUS BASED on $q->{fru_type} and let user select one.
#



# INPUT
# $q->{fru_type} = t3.disk or dsp or t3.controller
# $q->{_BACK} = where to go after a selection is made
# OUTPUT
# set $q->{_SELECTED} after the form is accepted
# set $q->{_DEV} in the summary page
# set $q->{sel_$key:$fru:name}

sub select  {
  my($q) = @_;

  my ($type, $comp) = split(/\./, $q->{fru_type});
  my(@D, %D2);
  my($renv, $devs) = PDM::ConfigFile->read();
  foreach my $d (@$devs) {
     if ($d->{type} eq $type) {
        push(@D, "$d->{name}\t$d->{key}");
        $D2{$d->{key}} = $d;
     }
  }
  if ($q->{dev_summary}) {
     &device_summary($q, \@D, \%D2);
  } else {
     &detail_page($q, \@D, \%D2);
  }
}

sub device_summary {
  my($q, $D, $D2) = @_;

  my ($type, $comp) = split(/\./, $q->{fru_type});
  my $args = Html->makeArgs($q, "_SELECTED,dev_summary");
  my $LB = Labels->read("Service::Fru");

  my (@array, %F);

  foreach my $d0 (sort @$D) {
     my($d1,$d2) = split(/\t/, $d0);
     my $d = $D2->{$d2};
     my($u);
     for ($u=1; $u <= $d->{units}; $u++) {
       my $unit = $d->{key} . ":$u";
       my $url;
       if ($comp) {
         $url  = "<a href=/rashttp?GO=$q->{_BACK}&_DEV=$unit$args>unit$u</a>";
       } else {
         my $k = "$d->{key}:unit$u:$d->{name}";
         $url  = "<a href=/rashttp?GO=$q->{_BACK}&_SELECTED=$k$args>unit$u</a>";
       }
       push(@array, [ $d->{name}, $url,  $d->{ipno} ]);
     }
  }

  my $scr = Html::Screen->new();

  $q->{SORT} = 1 if (!$q->{SORT});

  $scr->list($q, { title => "$LB->{select_dev} [ $q->{fru_type} ] ", 
                   interactive => 1 },
    [
    [ l => $LB->{name}, "+sn"   ],
    [ l => $LB->{unit}, "+sn"   ],
    [ l => $LB->{ip},           ],
    ],
    \@array,
    );
   $scr->add("</form>");
   print $scr->out();

}


sub detail_page {
  my($q, $D, $D2) = @_;

  my (@array, %F);
  my $args = Html->makeArgs($q, "_SELECTED,");
  my ($type, $comp) = split(/\./, $q->{fru_type});
  my ($KEY, $UNIT) = split(/\:/, $q->{_DEV});

  my $nav   = Navigation->read(1, "service");
  my $node  = $nav->node($q->{NODE});

# foreach my $e (keys %$q) {print "$e=$q->{$e}<br>"}

  my $LB = Labels->read("Service::Fru");

  foreach my $d0 (sort @$D) {
     my($d1,$d2) = split(/\t/, $d0);
     my $d = $D2->{$d2};
     next if ($KEY && $KEY ne $d->{key});
     my $report = Report->readLocal("$d->{type}:$d->{key}");
     next if (!$report);
     my $rep = $report->value();
     if ($type eq "dsp") {
       foreach my $e (sort keys %$rep) {
         my $val = $rep->{$e};
         if ($e =~ /(.*)\.Type$/) {
           my $dfru = $1;
           my $fru = "$dfru";
           if (lc($val) =~ /$comp/) {
             my ($status, $model, $class);
             $class  = $rep->{"$fru.Class"};
             $status = $rep->{"$fru.State"};
             $model  =   $rep->{"$fru.PartNumber"} . "-" .  $rep->{"$fru.SerialNumber"};

             my $sel = "$d->{key}:$dfru:$d->{name}";
             my $url = "<a href=/rashttp?GO=$q->{_BACK}&_SELECTED=$sel$args>$dfru</a>";

             push(@array, [ $d->{name}, $url, $status, "<small>$model",$class]);
           }
         }
       }

     } elsif (index("6020,6120,t3", $type) >= 0) {
       my(@LL);
       foreach my $e (sort keys %$rep) {
         if ($e =~ /^$comp\.([^\.]+)\..+/) {
           my $fru = $1;
           my $fru2 = $fru;
           if (substr($fru,2,1) eq "d") {
              $fru2 = sprintf("%s%2.2d", substr($fru,0,3), substr($fru,3));
           }
           push(@LL, "$fru2|$fru");
         }
       }
       foreach my $ll (sort @LL) {
           my($sort,$fru) = split(/\|/, $ll);
           next if ($UNIT && substr($fru,1,1) ne $UNIT);
           my $dfru = $fru;

           if (!$F{$fru.$d->{key}}) {
             $F{$fru.$d->{key}} = 1;
             my ($status, $model);
             $status = $rep->{"$comp.$fru.fruStatus"} . "-" .  $rep->{"$comp.$fru.fruState"};
             if ($q->{status}) {
               my $s = $q->{status};
               if (substr($s,0,1) eq "!") {
                  next if (index($status,substr($s,1)) >= 0);
               } else {
                  next if (index($status,$s) < 0);
               }
             }
               $model  =   $rep->{"$comp.$fru.fruVendor"} . "-" .
                          $rep->{"$comp.$fru.fruModel"} . "-" .
                          $rep->{"$comp.$fru.fruSerialNo"};
             my $sel = "$d->{key}:$dfru:$d->{name}";
             my $url = "<a href=/rashttp?GO=$q->{_BACK}&_SELECTED=$sel$args>$dfru</a>";
             push(@array, [ $d->{name}, $url, $status, "<small>$model",$comp]);
           }
       }
     }
   }                                     
   my $scr = Html::Screen->new();

  $q->{SORT} = 1 if (!$q->{SORT});

  if ($#array < 0 && $node->{notfound}) {
    $scr->add("&nbsp;<br>");
    $scr->add(Html->error("<b>$node->{notfound}"));
  } else {
    $scr->list($q, { title => "$LB->{select_fru} [ $type.$comp ] ", 
                   interactive => 1 },
    [
    [ l => $LB->{name}, "+sn"   ],
    [ l => $LB->{fru},          ],
    [ l => $LB->{status},"+sn"  ],
    [ l => $LB->{model} , "+"   ],
    [ l => $LB->{comp},   "+"   ],
    ],
    \@array,
    );
    $scr->add("</form>");
  }

  print $scr->out();
}                                     

1;
