package Service::Viewer;
use Html;
use System;
use strict;
use Labels;
use MG::DSP;
use MG::T3;


sub list {
  my($q) = @_;
  my %COM = (
      sp   => [
           '/usr/bin/ps -ef',
           '/usr/sbin/df -k',
           '/opt/SUNWsefbru/bin/fbr -fb',
           '/usr/bin/rmformat -b fbk /dev/rdsk/c1t0d0s2',
              ],

      6020 => [
           'set,date,sys list',
           'fru list',
           'fru stat',
           'fru stat sys',
           'vol list,vol stat,vol mode',
           'proc list',
           'port list,port listmap',
           'route -r',
           'refresh -s',
           'ntp,ntp -v,ntp stats',
           'ls -l etc web',
           'fru statistic',
           'volslice list',
           'lun map list,lun wwn list,lun perm list',
           'hwwn list,hwwn listgrp',
           'disk version u1d01-14',
           'disk version u2d01-14',
           'disk version u3d01-14',
           'disk version u4d01-14',
           'disk version u5d01-14',
           'disk version u6d01-14',
           ],
      dsp => [ 
           'show version',
           'show chassis,show chassis eeprom',
           'show disks',
           'show environment',
           'show fc-servers',
           'show interfaces fibrechannel',
           'show module',
           'show storage fc-target',
           'redund -c',
           'more \STARTUP.LOG',
           'more \PTRACE.LOG',
           'more \PCRASH.TXT',
              ],
      );
  $COM{6120} = $COM{6020};

  print Html->body();
  print Html->header2("service.util.telnet");

  my ($renv, $devs, $notifs) = PDM::ConfigFile->read();
  my $h = Util->shortHostname($renv->{hostname});
  my $L= Labels->read("Service::Viewer");

  my ($list, @L, %DEV);
  foreach my $d (@$devs) {
    next if (index(",6120,6020,t3,dsp,", ",$d->{type},") < 0);
    $DEV{$d->{key}} = $d;
    push(@L, "$d->{name}:$d->{key}:$d->{type}:$d->{ipno}");
  }
  $DEV{"localhost"} = {ipno => "127.0.0.1", name => "sp"};
  push(@L, "$h-sp:localhost:sp:127.0.0.1");

  my($key, $type, $ipno);
  foreach my $n0 (sort @L) {
    my($n, $key0, $type0, $ipno0) = split(/\:/, $n0);
    if ($key0 eq $q->{key}) {
       $n = "<b>$n</b>";
       $type = $type0; $ipno = $ipno0, $key = $key0; 
    }
    $list .= " <a href=/rashttp?GO=Service::Viewer::list&key=$key0>$n</a> |";
  }
  chop($list) if ($list);
  print "<table border=1 cellspacing=0 cellpadding=2 width=$Style::WIDTH>
        <tr><td colspan=2 bgcolor=$Style::DARK>&nbsp;</td>";
  print "<tr><td bgcolor=$Style::LIGHT width=25% align=right><b> $L->{dev}:</td>
             <td>[ $list ]</td>";

  if (!$key) {
     print "</table>";
     return ;
  }
  my $sel = Html->makeSelect("command",  join("|", @{$COM{$type}}), $q->{command});

my $button = Html::Screen->submitButton("ACTION", $L->{run});
  print "<tr><td bgcolor=$Style::LIGHT width=25% align=right><form>
            <input type=hidden name=GO value=Service::Viewer::list>
            <input type=hidden name=key value=$q->{key}>
            <input type=hidden name=type value=$q->{type}>
            <b> $L->{com}:</td>
            <td>
            $sel
            $button
            </td></table></form>";

  if (!$q->{command}) {
     return ;
  }
  #foreach my $e (keys %$q) {print "$e = $q->{$e}<br>"}

  my $dev = $DEV{$key};
  if (!Util->ping($dev->{ipno})) {
     print "Error: Cannot ping $dev->{name}!<br>";
     return;
  }

  if ($type eq "sp") {
     my ($err, $com) = Util->run_command($q->{command}, undef, 30, {cache => 0} );
     print "</center><pre>" . join("\n", @$com) . "</pre>";

  } elsif (index("6020,6120,", $type) >= 0) {
     my $t3 = MG::T3->new($dev); 
     my($err, $t) = $t3->connect();
     if ($err) {
       print Html->error($err);
     } else {
       my($rc);
       my @L = split(/,/, $q->{command});
       $rc = $t3->runCommand(\@L);
       print $rc->html();
     }
  } elsif ($type eq "dsp") {
     my $t3 = MG::DSP->new($dev); 
     my($err, $t) = $t3->connect();
     if ($err) {
       print Html->error($err);
     } else {

       my($rc);
       my @L = split(/,/, $q->{command});
       $rc = $t3->runCommand(\@L);
       print $rc->html();

       $t3->runCommand(["exit"]);
     }
  }
  print "&nbsp;<p>&nbsp;";
        
}

1;
