package Snapshot;
use strict;
use System;


sub fixRenv {
  my($class, $renv) = @_;

  foreach my $l ('logfile','t300logfile','dsp_logfile', 'trap_messages') {
     my $file = $renv->{$l};
     next if (!$file);
     my $ix = rindex($file, "/");
     $renv->{$l} = System->get_snapshot() . "/" . substr($file, $ix+1);
  }
}

sub seekLogfile {
  my($class, $snap, $renv) = @_;

  foreach my $f ('logfile','t300logfile', 'dsp_logfile', 'trap_messages') {
     $snap->{"${f}_seek"} = (stat($renv->{$f}))[7];
  }
}



sub prepare {
  my($class, $rep) = @_;

  my $data;
  $rep = $rep->{_value};
  use Data::Dumper;
  $Data::Dumper::Indent = 1;

  foreach my $el (sort keys %$rep) {
     if (ref($rep->{$el})) {
       my $d = Dumper($rep->{$el});
       $data .= " '$el' => " . substr($d,7,-2)  . ",\n";
     } else {
       my $new = $rep->{$el};
       $new =~ s/'/\\'/g;
       $data .= " '$el' => '$new',\n";
     }
  }
  return $data;
 
}

#
# CALLED FROM RASAGENT TO SETUP A SNAPSHOT FOR EXECUTION
# -T 001         # fail
# -T 001,REPAIR
#
sub setup {
  my($class, $snap, $base) = @_;

  my($snap, $oper) = split(/,/, $snap);
  my $DATA = "/opt/SUNWstade/DATA";
  $oper = "FAIL" if (!$oper);
  $oper = uc($oper);

  my $BASE = $base || "/var/opt/SUNWstade/SNAP";
  Debug->print2("Use Snapshot '$BASE/$snap'");
  if (!-d "$BASE/$snap") {
    print "Error: Directory $BASE/$snap does not exists!\n";
    exit;
  }

  System->set_snapshot("$BASE/$snap/$oper");

  mkdir "$DATA/TEST_REPORTS", 0777;

  my $COPY = "$BASE/$snap/$oper";

  foreach my $d ('EDOCS',   'SEQUENCER',  'MAXEVENTS','CACHE',
                 'DEVICES', 'THRESHOLDS', 'TIMELAPSE','ALARMS' ) {
    unlink "$DATA/$d.db";
    unlink "$DATA/$d.db.lock";
  }
  unlink "$DATA/Events_1.1.sch";
  unlink "$DATA/Storage_1.1.sch";

  system("cp $COPY/Events.log $DATA");
  if (-f "$COPY/EventsSys.log") {
    system("cp $COPY/EventsSys.log $DATA");
  }
  if (-f "$COPY/SLAVE_DATA") {
    system("cp $COPY/SLAVE_DATA $DATA");
  }
  system("cp $BASE/$snap/rasagent.conf $DATA");
  if (-f "$BASE/$snap/Inventory.golden") {
    system("cp $BASE/$snap/Inventory.golden $DATA");
  }
  system("rm -f $DATA/topo/*");
  system("cp $BASE/$snap/topo/* $DATA/topo");
  system("rm -f $DATA/OLD_REPORTS/*:*");
 

  if ($oper eq "REPAIR") {
    system("cp $BASE/$snap/FAIL/OLD_REPORTS/*:*  $DATA/OLD_REPORTS" );
    &create_tests("$COPY/OLD_REPORTS",          "$DATA/TEST_REPORTS");
  } else {  # FAIL
    system("cp $BASE/$snap/BASE/OLD_REPORTS/*:*  $DATA/OLD_REPORTS" );
    &create_tests("$COPY/OLD_REPORTS",          "$DATA/TEST_REPORTS");
  }
}

sub create_tests {
 my($FROM, $TO) = @_;

   opendir(O, $FROM);
   my @files = readdir(O); closedir(O);
   foreach my $f (@files) {
     next if ( $f !~ /\:/);
     my $rep = Util->deserialize0("$FROM/$f");
     my $data = Snapshot->prepare($rep);
     open(O, ">$TO/$f");
     print O $data;
     close(O);
   }
}

use vars qw($OPER $DIR $DONE $PATH);


sub saveFile {
  my($class, $file, $data) = @_;
  my $path = $class->path();
  if ($path) {
     open(O, ">$path/$file");
     print O $data;
     close(O);
  }
}

sub appendFile {
  my($class, $file, $data, $arg) = @_;
  my $path = $class->path();
  my $nocomment = $arg->{nocomment};
  if ($path && $data) {
     open(O, ">>$path/$file");
     my $today = System->get_today();
     print O "$today  ==========================================\n" if (!$nocomment);
     print O $data;
     close(O);
  }
}


# return $DIRECTORY

sub path {
  my($class) = @_;
  my($line);
  return $PATH if ($DONE);
  $DONE = 1;

  my $file = System->get_home() . "/DATA/SNAP";
  if (open(O, $file)) {
     $line = <O>; 
     close(O);
     chomp($line);
     my($op, $dir) = split(/\=/, $line);
     $PATH = "$dir/" . uc($op);
     return $PATH;
  }
  return undef;
}


#
# 001/rasagent.conf
# 001/BASE/OLD_REPORTS/..
# 001/FAIL/TEST_REPORTS/..
# 001/FAIL/t300messages, dsp_message
# 001/FAIL/Events.log
# 001/REPAIR/TEST_REPORTS/..
# 001/REPAIR/Events.log
# 
#
# run at the end of storade on FAIL or REPAIR
#
sub process {
  my($class, $renv) = @_;
  my($line);
  return if (System->get_snapshot());

   my $file = System->get_home() . "/DATA/SNAP";
   if (open(O, $file)) {
     $line = <O>; 
     close(O);
     chomp($line);
     ($OPER, $DIR) = split(/\=/, $line);
   }

   return if (!$OPER);
   my $COPY = "$DIR/" . uc($OPER);
   my $snap = Util->deserialize0("$DIR/snapshot.conf");
   my $COUNT = "count_" . lc($OPER);
   $snap->{$COUNT}++;
   $snap->{hostid} = System->hostid();

   Debug->print2("Snapshot: Copying Reports and logfiles to $COPY...");

   my $DATA = "/opt/SUNWstade/DATA";

   $class->seekCopy("$DATA/Events.log", "$COPY/Events.log", 
                      $snap->{events_log_seek}, $snap->{$COUNT});

   $class->seekCopy("$DATA/EventsSys.log", "$COPY/EventsSys.log", 
                      $snap->{eventsSys_log_seek}, $snap->{$COUNT});

   if ($snap->{$COUNT} == 1) {
     system("cp $DATA/OLD_REPORTS/*:* $COPY/OLD_REPORTS");
   } else {
     system("cp $DATA/OLD_REPORTS/*:* $COPY/NEXT_REPORTS");
   }
   system("cp $DATA/ALARMS.db* $COPY");
   if (-f "$DATA/SLAVE_DATA") {
      system("cp $DATA/SLAVE_DATA $COPY");
   }
   if (-f "$DATA/SLAVE_DATA.2") {
     system("cp $DATA/SLAVE_DATA.2 $COPY");
   }

   my($line, $tell);
   foreach my $log ('logfile','t300logfile','dsp_logfile', 'trap_messages') {
      my $file = $snap->{$log};
      next if (!-f $file); 
      open(FILE, $file);
      seek(FILE, $snap->{"${log}_seek"}, 0);
      my $ofile = $file;
      my $ix = rindex($file, "/");
      $ofile = substr($file, $ix+1) if ($ix > 0);
      open(W, ">>$COPY/$ofile");
      print W "# $COUNT=$snap->{$COUNT}\n";
      for ($tell = tell(FILE); $line = <FILE>; $tell = tell(FILE)) {
         print W $line;
      }
      close(W);
   }
   $snap->{"date_". lc($OPER)} = Util->get_today();
   $snap->{"time_". lc($OPER)} = time;

   Snapshot->seekLogfile($snap, $renv);

   Util->serialize0("$DIR/snapshot.conf", $snap);

}

sub seekCopy {
  my($class, $from, $to, $seek, $count) = @_;
  my($tell, $line);
  open(FILE, $from);
  seek(FILE, $seek,0);
  open(W, ">>$to");
  print W "RUN-COUNT $count\n";
  for ($tell = tell(FILE); $line = <FILE>; $tell = tell(FILE)) {
     print W $line;
  }
  close(W);
}


1;
