package TO::Server;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use base 'TO::Node';
use strict;

sub leaf { 0 }

sub portLabel {
  my($class, $port) = @_;
  return "hba-$port"
}

sub new  { print "abstract" }
sub type { print "abstract" }
sub statusFunc { print "abstract" }



sub toString {
  my($h) = @_;
  my($x, $out, $hbasI);

  $out = "HOST  : '$h->{info}{name}'\n";

  my($ports) = $h->port();
  my($hbas) = $h->portInfo();
  my($hba, $port);

  for ($x=0; $x <= $#$hbas; $x++) {
     $hba = $hbas->[$x];
     $port = $ports->[$x];
     next if ($hba->{al_pa} == -1);
     $out .= "      HBA-$x: NodeWWN=$hba->{NodeWWN} \n".
             "             Path   =$hba->{path}  \n".
             "             LGroup =$hba->{LGroup} \n".
             "             Mode   =$hba->{path}, al_pa=$hba->{al_pa},\n";
     $out .= "             LINK_TO-> $port \n";
  }
  return $out;
}


sub iconLayout {
  my($ho) = @_;
  return "E0E0E0/NOTDEFINED.gif,_," ; 
}


sub diagramApplet {
  my($class, $name, $Comp, $to) = @_;

  my $node = $to->nodeByName($name);

  my $ports = $node->portInfo();

  my $o = "<table border=1 cellspacing=0 width=100% bgcolor=#303030>
  <tr><td>";
  
  

}

sub hostid {
  my($obj) = @_;
  return $obj->{info}{hostid};
}


sub boxName {
  my($obj) = @_;
  return $obj->key();
}

sub id {
  my($obj) = @_;

  my(@xx) = split(/:/, $obj->{info}{name});
  return "host '$xx[1]'";
}


sub getPortId {
  my($class, $port) = @_;   # 0 , 1 ...

  return "hba.$port";
}

1;
