package Tests::T3;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use strict;
use base "Tests";
use Tests::General;
use PDM::ConfigFile;
use Report;

#
# Ofdg
# preform executes right before the form is displayed, 
# used to set field values.
#
sub ofdg_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my($err, $t);
  my $config = PDM::ConfigFile->read();
  
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);
  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  my $ipaddr;
  if ((!$dev->{ipno})) {
     $err .= "No IP Address or hostname defined for this device ($key)";
     $ipaddr = "*** NOT DEFINED ***";
  } else {
     $ipaddr = $dev->{ipno};
  }
  
  my $pass = $class->getPassword($dev, \$err);

  my(%DATA) = ('#IPADDR' => $ipaddr,
                  '#USR' => 'root',
               '#PASSWD' =>  $pass,
              );

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);

  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);
}

#
# runs after the used submit the test form
# used to validate the test, refuse to run it etc..
#
sub ofdg_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  if (($t = $class->testRunning("*", $key))) {
     return "A test on $key already exists";
  }

  if ($q->{"opt_dev"} =~ /#IPADDR/ || !$q->{opt_dev}) {
     $err .= "Unable to obtain IP address. ";
  }

  if ($q->{"opt_passwd"} eq "#PASSWD" ) {
     $err .= "Must enter a valid password to run this test.";
  }
  return $err;
}


#
#  VolVerify
#
sub volverify_preForm {
  my($class, $command, $to, $node, $q) = @_;
  my ($err, $t);
  my $config = PDM::ConfigFile->read();
  
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);

  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }

  my $VolumeNames;
  (my $readerr, my $rep1) = Report->readReport("t3:$key", "*");
  if ($rep1) {
    my $v = $rep1->value();
    foreach my $token (keys %$v){
      if($token =~ /volName/){
        my ($precrap, $volID, $postcrap) = split(/\./,$token);
        if($v->{"volume.".$volID.".volStatus"} !~ /deleted/){
          $VolumeNames .= $v->{$token}."|";
        }
      }
    }
    chop $VolumeNames;
  } else {
    $err .= "$key: Unable to determine Volume Names ".$readerr;
    $VolumeNames="UNDEFINED";
  }

  my $ipaddr;
  if ((!$dev->{ipno})) {
     $err .= "No IP Address or hostname defined for this device ($key)";
     $ipaddr = "*** NOT DEFINED ***";
  }else{$ipaddr = $dev->{ipno};}
  
  my $pass = $class->getPassword($dev, \$err);

  my(%DATA) = ('#IPADDR' => $ipaddr, 
                  '#USR' => 'root',
               '#PASSWD' =>  $pass,
	       '#VOLNAMES' => $VolumeNames
              );


  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);
  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);

}

sub volverify_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  if (($t = $class->testRunning("*", $key))) {
     return "A test on $key already exists";
  }

  if ($q->{opt_dev} =~ /#IPADDR/ || !$q->{opt_dev}) {
     $err .= "Unable to obtain IP address. ";
  }

  if ($q->{opt_passwd} eq "#PASSWD") {
     $err .= "Must enter a valid password to run this test.";
  }
  return $err;
}

sub ondg_preForm{
  my($class, $command, $to, $node, $q) = @_;
  my($warning, $err, $t);
  my $config = PDM::ConfigFile->read();

  my $key = $node->key();
  my $dev = $config->deviceByKey($key);
  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }
  (my $readerr, my $rep1) = Report->readReport("t3:$key", "*");
  my $Controllers;
  if ($rep1) {
    my $v = $rep1->value();
    if($v->{"system.sysRevision"} < "030100"){
      $warning.="This diagnostic should not be ".
                "executed on this array. Firmware level 3.1 or ".
                "higher is required for this functionality. ";
    }
    for( my $i = 1; $i<=8; $i++){
      if(exists($v->{"controller.u".$i."ctr.fruStatus"})){
        if ($v->{"controller.u".$i."ctr.fruStatus"}ne"notInstalled"){
          $Controllers .= "u".$i."ctr|" ;
        }
        if ($v->{"controller.u".$i."ctr.fruStatus"}ne"ready"
                  && $v->{"controller.u".$i."ctr.fruStatus"}ne"notInstalled"){
          $err.=
           "u".$i."ctr is in ".$v->{"controller.u".$i."ctr.fruStatus"}." state";
        }
      }
    }
   $Controllers .= "all|" if $Controllers =~ /^u\dctr|u\dctr/;

  } else {
    $err .= "$key: Unable to determine Controller Names ".$readerr;
    $Controllers="UNDEFINED";
  }
  my $ipaddr;
  if ((!$dev->{ipno})) {
     $err .= "No IP Address or hostname defined for this device ($key)";
     $ipaddr = "*** NOT DEFINED ***";
  } else {
     $ipaddr = $dev->{ipno};
  }
  my $pass = $class->getPassword($dev, \$err);

  my(%DATA) = ('#IPADDR' => $ipaddr,
                  '#USR' => 'root',
                '#CTRL' => $Controllers,
               '#PASSWD' =>  $pass,
               '#WARN' =>  $warning,
              );

  my($gen_err, $get_data) = Tests::General->preForm($command,$to, $node, $q);

  $err .= $gen_err if ($gen_err);

  return ($err, \%DATA);
}

sub ondg_postForm {
  my($class, $command, $to, $node, $q) = @_;
  my($t, $err);
  my $config = PDM::ConfigFile->read();
  my $key = $node->key();

  if (($t = $class->testRunning("*", $key))) {
    return "A test on $key already exists";
  }

  if ($q->{"opt_dev"} =~ /#IPADDR/ || !$q->{opt_dev}) {
    $err .= "Unable to obtain IP address. ";
  }

  if ($q->{"opt_passwd"} eq "#PASSWD" ) {
    $err .= "Must enter a valid password to run this test.";
  }
  my $key = $node->key();
  my $dev = $config->deviceByKey($key);
  if (!$dev) {
     $err .= "Cannot find ($key) in Config. ";
  }
  (my $readerr, my $rep1) = Report->readReport("t3:$key", "*");
  if ($rep1) {
    my $v = $rep1->value();
    if($v->{"system.sysRevision"} < "030100"){
      $err    .="This diagnostic cannot not be ".
                "executed on this array. Firmware level 3.1 or ".
                "higher is required for this functionality. ";
    }
  }
  return $err;
}

1;
