package Timer;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

use Debug;
use strict;
use PDM;
use RasDB;

###########################################################
#  Timers
#  [NEW|YES|undef] = Timer->isXmins('timer1', 10 );
#  [NEW|YES|undef] = Timer->isXdays('timer1', 1);
#  [NEW|YES|undef] = Timer->isXhours('timer1', 1);
#   Timer->reset('timer1');        # erase the timer, will generate NEW next time.

#  [-1|$mins] = Timer->getTimer('timer1');
#   Timer->resetTimer('timer1');  # reset timer to now.
#
#  Answer the question: Has it been X days since  a certain event occured:
#  - If the question was never asked, the event is initialized and
#    the answer is 'NEW'.
#  - If it's been that long, answer 'YES', reset the event.
#    else answer undef.
###########################################################

use vars qw($DB);

sub resetTimer {
  my($class, $timer, $db_no) = @_;
  croak("No timer defined") if (!$timer);
  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $timer = "timers.$timer$db_no";

  $h->{$timer} = int(time/60);
  return 0;
}

# remove the timer entry from the timer file
#
sub clearTimer {
  my($class, $timer, $db_no) = @_;
  croak("No timer defined") if (!$timer);
  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $timer = "timers.$timer$db_no";

  delete $h->{$timer};
  return 0;
}


# returns the # of minutes of the timer.

sub getTimer {
  my($class, $timer, $db_no) = @_;
  my($now) = int(time/60);
  croak("No timer defined") if (!$timer);
  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $timer = "timers.$timer$db_no";

  if ($h->{$timer}) {
    return $now - $h->{$timer}; # return elapsed minutes
  } else {
    $h->{$timer} = $now;
    return -1;                   # return -1 minutes, NEW timer
  }
}


sub isXdays {
 my($timer, $event_name, $days, $db_no) = @_;
 my(@a,$year, $yday, $day);

 $days = 1 if (!$days);
 my($mins) = $days * 60 * 24;
 return $timer->_isX($event_name, $mins, $db_no);
}


sub isXhours {
 my($timer , $event_name, $hours, $db_no) = @_;
 my(@a,$year, $yday, $day);

 $hours = 1 if (!$hours);
 my($mins) = $hours * 60;
 return $timer->_isX($event_name, $mins, $db_no);

}

sub isXmins {
 my($timer , $event_name, $mins, $db_no) = @_;
 my(@a,$year, $yday, $day);

 $mins = 1 if (!$mins);

 return $timer->_isX($event_name, $mins, $db_no);

}

sub _isX {
 my($timer, $event_name, $mins, $db_no) = @_;

 my($t) = $timer->getTimer($event_name, $db_no);

 if ($t == -1) {
    return "NEW";
 } elsif ($t >= $mins) {
    Debug->print2("Timer '$event_name' is " . int($t/60) . " hour(s) old");
    $timer->resetTimer($event_name, $db_no);
    return "YES";
 } else {
    return undef;
 }
}

sub reset {
  my($timer, $event_name, $db_no) = @_;

  $DB    = RasDB->new("CACHE");
  my $h  = $DB->hash();
  $event_name = "timers.$event_name$db_no";

  $h->{$event_name} = 0;
}


1;
