#!/bin/sh
#
#
# ident "@(#)es-setup-esscp.sh 1.12     03/04/15 SMI"
#
# Copyright (c) 2000-2002 by Sun Microsystems, Inc
# All rights reserved.
#
#

#
# NOTE: A portion of this script is reproduced in the GUI setup script
# gui-xc-plt-update-cfg.sh.  Changes to this script may also need to be made
# to gui-xc-plt-update-cfg.sh.  The common code starts around the "module_add"
# portion of the this script.
#
# At some point, it may be best to place the common code into a single script
# that both es-setup-esscp.sh and gui-xc-plt-update-cfg.sh call, but at the
# time gui-xc-plt-update-cfg.sh was introduced, other projects (SunMC CLI setup
# and Smart Update) were dabbling in the area of setup and it was decided to
# keep es-setup-esscp.sh stable.
#


#
# for smart update, you must make certain that this script runs or fails without any user interaction
#

# only need to setup platform
/usr/bin/pkginfo -qi SUNWesscp
if [ $? -ne 0 ] ; then
	exit 0
fi

# this is needed, for a call to check_root in addon_setup
PROGNAME="$0"; export PROGNAME

if [ -n "${ESROOT}" ]; then
	if [ -r "${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh" ]; then
		. ${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh
		addon_setup SUNWesscp
	else
		# locale not setup
		/usr/bin/echo "${ESROOT}/addons/SunFire15K_12K/sbin/addon_common.sh not readable."
		exit 1
	fi
else
	# locale not setup
	/usr/bin/echo "Sun Management Center ESROOT not setup."
	exit 1
fi


#
# local variables
#
sc=`/usr/bin/hostname`
sc_spare=''
symon_conf="/etc/opt/SUNWsymon/symon.conf"
default_agent_port=161
default_platform_port=166
default_domain_port="161"
default_platform_family_name="Sun-Fire-15000-platform"
dot_family="Sun-Fire-15000-platform-group"
# This is the good dot
dot_oid="1.3.6.1.4.1.42.2.85.1.1.1"
dfile=dtable.toe
port_changed=0
oids_file="/var/opt/SUNWsymon/cfg/platform-oids-d.dat"
es_dt_label="Sun-Fire-15000"


check_port () {
	# $1 is port number
	port=$1
	echolog 'Verifying port number: ${port}.'
	/usr/bin/echo ${port} | /usr/bin/egrep '^[0-9]+$' >/dev/null
	result=$?
	if [ $result -ne 0 ]; then
		echolog 'invalid port number ${port}, port numbers must be numeric.'
		answer=0
		return 0
	fi

	/usr/bin/netstat -an -P udp | /usr/bin/grep -v grep | /usr/bin/egrep "[ 	]*\*\.${port}[ 	]+" >/dev/null
	result=$?
	if [ $result -eq 0 ]; then
		echolog 'Warning, port ${port} is currently in use.'
		echolog 'You need to either pick a different port, or'
		echolog 'insure that port ${port} is available when you next start Sun Management Center.'
		addon_ask_user 'Do still wish to use port ${port}?'
		if [ $answer -eq 0 ]; then
			return 0
		else
			echolog 'Remember to resolve the conflict on port ${port}'
			echolog 'prior to starting Sun Management Center.'
		fi
	fi
	answer="$port"
	return ${port}
}


get_port() {
	port=0
	while [ ${port} -eq 0 ]; do
		get_input_from_user 'enter new Sun Management Center Agent port:'
		check_port $answer
		port=$answer
	done
	return $port
}


get_failover () {

    if [ $SUMODE -eq 0 ]; then
	# interactive mode
	sc_spare=''
	done=0
	while [ ${done} -eq 0 ]; do
		echolog ''
		addon_ask_user 'Is this Sun Fire 15K/12K platform configured with a spare SC?'
		if [ $answer -ne 0 ] ; then
			echolog 'Please enter the alternate SC hostname \\(not ${sc}\\) for this platform.'
			get_input_from_user 'Alternate SC hostname:'
			if [ -n "${answer}" ]; then
				if [ "$answer" = "$sc" ] ; then
					echolog 'Error, please use the name of the other SC for this platform, not ${sc}.'
				else
					done=1
					sc_spare="$answer"
					echolog 'Remember on ${sc_spare} the Agent must be configured to use port ${agent_port}.'
					echolog 'Remember on ${sc_spare} the Platform Agent must be configured to use port ${platform_port}.'
					echolog ''
				fi
			fi
		else
			done=1
			echolog 'No alternate SC specified for ${sc}.'
		fi
	done
    else
	# smart update mode
	sc_spare=`get_value_from_cfgfile $SCPCFG sc_spare =`
	if [ $? -ne 0 ]; then
	    # error, config file does not have the required key
	    echolog 'Error: Cannot get spare SC name from config file.'
	    echolog 'Info: Will use default values for setup.'
	    sc_spare=""
	else
	  echolog 'Set Spare System Controller to ${sc_spare}'

	  echolog 'Remember on ${sc_spare} the Agent must be configured to use port ${agent_port}.'
	  echolog 'Remember on ${sc_spare} the Platform Agent must be configured to use port ${platform_port}.'
	  echolog ''
	fi
    fi
}



#
# interactive_platform_setup
#
interactive_platform_setup () {

    echolog ''
    # insure that platform domain-config.x is properly setup
    echolog 'Checking Sun Management Center Platform Agent configuration.'
    if [ -f "${VARDIR}/domain-config.x" ]; then

	    # just set the family type
	    $XPUT ${VARDIR}/domain-config.x platform.family_name "$default_platform_family_name"

	    # check the platformServer
	    platformServer=`$XGET ${VARDIR}/domain-config.x agent.agentServer`
	    if [ -z "$platformServer" ]; then
		    echolog 'Invalid Sun Management Center Agent setup.'
		    echolog '${VARDIR}/domain-config.x. agentServer not setup.'
		    exit 1
	    fi
	    $XPUT ${VARDIR}/domain-config.x platform.platformServer "$platformServer"

	    platform_port=`$XGET ${VARDIR}/domain-config.x platform.snmpPort`
	    if [ -z "${platform_port}" ]; then
		    # get the platform agent port

		    echolog 'The default port for the Sun Management Center Platform Agent is port ${default_platform_port}.'
		    addon_ask_user 'Do you wish to use the default Sun Management Center Platform Agent port ${default_platform_port}?'
		    if [ $answer -ne 0 ]; then
			    platform_port=$default_platform_port
		    else
			    get_port
			    platform_port=$answer
		    fi
		    $XPUT ${VARDIR}/domain-config.x platform.snmpPort "$platform_port"
		    # regenerate security keys
		    port_changed=1
	    else
		    # verify the existing agent port
		    check_port $platform_port
		    if [ $answer -eq 0 ]; then
			    get_port
			    platform_port=$answer
			    $XPUT ${VARDIR}/domain-config.x platform.snmpPort "$platform_port"
			    # regenerate security keys
			    port_changed=1
		    fi
	    fi
	    echolog 'Sun Management Center Platform Agent port: ${platform_port}'
    else
	    echolog 'Invalid Sun Management Center agent setup.'
	    echolog '${VARDIR}/domain-config.x does not exist.'
	    exit 1
    fi
}


#
# smart update platform setup verification
#
sumode_platform_verify () {
    echolog ''
    # insure that platform domain-config.x is properly setup
    echolog 'Checking Sun Management Center Platform Agent configuration.'
    if [ -f "${VARDIR}/domain-config.x" ]; then

	    # just set the family type
	    $XPUT ${VARDIR}/domain-config.x platform.family_name "$default_platform_family_name"

	    # check the platformServer
	    platformServer=`$XGET ${VARDIR}/domain-config.x agent.agentServer`
	    if [ -z "$platformServer" ]; then
		    echolog 'Invalid Sun Management Center Agent setup.'
		    echolog '${VARDIR}/domain-config.x. agentServer not setup.'
		    exit 1
	    fi
	    $XPUT ${VARDIR}/domain-config.x platform.platformServer "$platformServer"

	    platform_port=`$XGET ${VARDIR}/domain-config.x platform.snmpPort`
	    if [ -z "${platform_port}" ]; then
		# smart update mode, can not change ports.
		echolog 'Invalid Sun Management Center Agent setup.'
		exit 1
	    fi
	    echolog 'Sun Management Center Platform Agent port: ${platform_port}'
    else
	    echolog 'Invalid Sun Management Center agent setup.'
	    echolog '${VARDIR}/domain-config.x does not exist.'
	    exit 1
    fi
}



get_domain_ports () {

    echolog ''
    echolog 'The Platform agent will create a composite object that includes'
    echolog 'Sun Management Center agents loaded on Sun Fire 15K/12K domains.'

    if [ $SUMODE -eq 0 ]; then
	#interactive mode
	# query for domain ports

	query_port=1
	while [ ${query_port} -ne 0 ]; do
		echolog ''
		echolog 'The default port to be checked for Sun Fire 15K/12K Domains is: ${default_domain_port}.'
		echolog ''
		addon_ask_user 'Do you want change the port that will be checked?'
		if [ $answer -ne 0 ] ; then
			echolog 'Please enter port number, just press \\<Enter\\> to check no ports.'
			get_input_from_user 'Enter port number:'
			tmp_port=`/usr/bin/echo ${answer} | /usr/bin/egrep '^([ 	]*[0-9]+)$'`
			if [ $? -eq 0 ] ; then
				# user entered valid ports
				default_domain_port=${tmp_port}
				query_port=0
			else 
				# bad ports, go again
				echolog 'Invalid port numbers ${answer}.'
			fi
		else
			# user accepts defaults
			query_port=0
		fi
	done

    else
	# smart update mode
	default_domain_port=`get_value_from_cfgfile $SCPCFG default_domain_port =`
	if [ $? -ne 0 ]; then
	    # error, config file does not have the required key
	    echolog 'Error: Cannot get domain port number from config file.'
	    echolog 'Info: Will use default values for setup.'
	    default_domain_port="161"
	fi

    fi

    # display the domain port
    if [ -z "${default_domain_port}" ]; then
	echolog 'Sun Fire 15K/12K domain agent ports: none.'
    else
	echolog 'Sun Fire 15K/12K domain agent ports: ${default_domain_port}.'
    fi

}


#
# rebuild security keys if needed
handle_security_keys () {

    [ ${port_changed} -eq 0 ] && return 0

    # deal with security keys as needed
    if [ $SUMODE -eq 0 ]; then
	# interactive mode
	# regenerate security keys if agent ports have changed
	if [ ${port_changed} -ne 0 ]; then
		echolog ''
		echolog 'The Sun Management Center security keys must be regenerated'
		echolog 'because the agent port numbers used have been changed.'
		echolog ''
		addon_ask_user 'Do you want to regenerate the security keys now?'
		if [ $answer -ne 0 ]; then

			ESKEYS=
			if [ -r ${ESROOT}/lib/sbin/es-keys.sh ]; then
			    ESKEYS=${ESROOT}/lib/sbin/es-keys.sh
			elif [ -r ${ESROOT}/sbin/es-keys.sh ]; then 
			    ESKEYS=${ESROOT}/sbin/es-keys.sh
			fi
			if [ -n "$ESKEYS"  ]; then
				. $ESKEYS agent
				addon_wrapper generate_keys agent 0
			else
				echolog ''
				echolog 'Invalid Sun Management Center agent installation.'
				echolog 'es-keys.sh not readable.'
				echolog ''
				exit 1
			fi
		else
			echolog ''
			echolog 'The Sun Management Center security keys have not been regenerated.'
			echolog 'Remember you must regenerate the Sun Management Center security keys'
			echolog 'prior to starting Sun Management Center.'
		fi
	fi
    else
	# Smart Update mode, can't regenerate keys
	echolog ''
	echolog 'The Sun Management Center security keys must be regenerated'
	echolog 'because the agent port numbers used have been changed.'
	echolog ''
	echolog 'The Sun Management Center security keys have not been regenerated.'
	echolog 'Remember you must regenerate the Sun Management Center security keys'
	echolog 'prior to starting Sun Management Center.'
	echolog ''
	exit 1
    fi
}


print_usage ()
{
  echo ""
  eval echo `/usr/bin/gettext 'Usage: $PROGNAME [ -u ]'`
  /usr/bin/gettext '       Where the options represent:\n'
  /usr/bin/gettext ' Default : Setup addon\n'
  /usr/bin/gettext '  u : Use this option to undo the previous setup.\n'
}


undo_previous_setup ()
{
  # we must setup BASEDIR ourselves
  BASEDIR=`pkgparam SUNWescom BASEDIR`
  if [ -z "${BASEDIR}" ]; then
    BASEDIR=/opt
  fi

  $BASEDIR/SUNWsymon/sbin/es-stop -al >/dev/null 2>&1

  # update symon.conf
  if [ -w ${symon_conf} ]; then
    /usr/bin/grep -v "Starcat" ${symon_conf} > ${symon_conf}.${PID}
    /usr/bin/mv -f ${symon_conf}.${PID} ${symon_conf}
  fi

  # remove dtable entry
  ${BASEDIR}/SUNWsymon/sbin/es-dt -d -l $es_dt_label > /dev/null

  # remove modules
  remove_module efe platform-modules-d.dat
  remove_module scmonitor platform-modules-d.dat
  remove_module Config-ReaderStarcat platform-modules-d.dat
  remove_module dtable base-modules-d.dat
  remove_module scstatus base-modules-d.dat
}


################################################################################

undo_flag=0

while getopts u OPT
do
  case $OPT in
    u)
       undo_flag=1
       ;;
    *)  print_usage
       ;;
  esac
done

if [ $undo_flag -eq 0 ] ; then
  echolog  '--------------------------------------------------------------'
  echolog  'Starting Sun Management Center Sun Fire 15K/12K Platform Setup'
  echolog  '--------------------------------------------------------------'

  echolog ''
  echolog 'Additional Setup information is available in the'
  echolog 'Sun Management Center Supplement for Sun Fire 15K/12K Servers.'
  echolog ''    
fi

# insure that we are on an SC with SMS packages
/usr/bin/pkginfo -qi SUNWSMSop
if [ $? -ne 0 ] ; then
	# installation on something other than an SC
	echolog ''
	echolog 'SMS packages are not installed. Cannot setup package.'
	exit 1
fi

# the Sun Management Center server should not be here
/usr/bin/pkginfo -qi SUNWessrv
if [ $? -eq 0 ] ; then
	echolog ''
	echolog 'Installation of the Sun Management Center server, SUNWessrv,'
	echolog 'on an SC is not recommended.'
	if [ $SUMODE -eq 0 ]; then
	    addon_ask_user 'Do you want to continue installation of the Sun Fire 15K/12K Platform package?'
	    if [ $answer -eq 0 ]; then
		exit 1
	    fi
	fi
fi


#
# if -u undo previous setup
#
if [ $undo_flag -eq 1 ] ; then
    undo_previous_setup
    exit 0
fi

# smart update
PLATFORMDATA="${VARDIR:-/var/opt/SUNWsymon/cfg}/platform-modules-d.dat"
SCPCFG="${VARDIR:-/var/opt/SUNWsymon/cfg}/esscp.config"
if [ ${SUMODE:=0} -eq 0 ]; then
    # interactive mode
    verbose_smartupdate_cfgfile "$SCPCFG" rw
else
    # smart update mode
    verbose_smartupdate_cfgfile "$SCPCFG" ro

    # bug 4848235
    # if agent update from 3.0 to 3.5, $SCPCFG is missed and exit will fail setup.
    # fix:
    # 1. if update from 3.0, base sunmc is also being updated. So the answer can found from
    #    platform-module-d.dat
    # 2. if update from 3.5 or later version, the file should exist. otherwise, it is a bug
    #    and error msg should be given.
    # [ $? -ne 0 ] && exit 1

    if [ $? -ne 0 ]; then

      echolog  '--------------------------------------------------------------'
      echolog  'The Agent Update configuration file only exists for SunMC versions 3.5 and above.'
      echolog  'If upgrading from a previous version, disregard error messages about this file.'
      echolog  '--------------------------------------------------------------'
      echolog  ''


      # $SCPCFG does not exist.
      # try best effort
      
      if [ -f "$PLATFORMDATA" ] ; then

	# have the platform-module-d.dat file
	tmp_sc_spare=""
	tmp_agent_port="161"
	tmp_varline=""
	
	tmp_varline=`/usr/bin/cat ${PLATFORMDATA} | grep "Config-ReaderStarcat ="`
	if [ -z "$tmp_varline" ] ; then
	  #configure reader was not setup in the previous version
	  #exit 0 with no failure
	  echolog 'Info: The module is not set up in the previous version.'
	  echolog 'Info: Will use default values for setup."'

	else
	
	  # reach here, we are sure to have the answers. Of course, we need to 
	  tmp_sc_spare=`echo $tmp_varline | tr ";" "[\012*]" | grep "scSpare =" | /usr/bin/cut -f2 -d \" | /usr/bin/cut -f1 -d '\'`
	  
	  tmp_agent_port=`echo $tmp_varline | tr ";" "[\012*]" | grep "agentPort =" | /usr/bin/cut -f2 -d \" | /usr/bin/cut -f1 -d '\'`
	
	fi

      else

	# no way to get the answer, exit with error
	  echolog 'Info: The module is not set up in the previous version.'
	  echolog 'Info: Will use default values for setup."'
	
	# set to default value
	tmp_agent_port="161"
	tmp_sc_spare=""
      
      fi

      # This is the first time setup. Ok, make a copy.
      # create file
      tmpmask=`umask`
      umask 0077
      touch "$SCPCFG"
      umask "$tmpmask"
      create_starcat_platform_config "$SCPCFG" "$tmp_agent_port" "$tmp_sc_spare"
    else

      tmp_flag=0
      tmp_sc_spare=`get_value_from_cfgfile $SCPCFG sc_spare =`
      if [ $? -ne 0 ]; then
	tmp_sc_spare=""
	tmp_flag=1
      fi

      tmp_agent_port=`get_value_from_cfgfile $SCPCFG default_domain_port =`
      if [ $? -ne 0 ]; then
	tmp_agent_port="161"
	tmp_flag=1
      fi

      if [ ${tmp_flag} -ne 0 ]; then
	echolog 'Info: ${SCPCFG} is bad. Rebuild ${SCPCFG}'
	create_starcat_platform_config "$SCPCFG" "$tmp_agent_port" "$tmp_sc_spare"
      fi
    fi
fi

echolog ''
# insure that agent domain-config.x is setup properly
echolog 'Checking Sun Management Center Agent configuration.'
if [ -f "${VARDIR}/domain-config.x" ]; then

	agent_port=`$XGET ${VARDIR}/domain-config.x agent.snmpPort`
	if [ -z "$agent_port" ]; then
		echolog 'Invalid Sun Management Center Agent setup.'
		echolog 'agent snmpPort is not setup.'
		exit 1
	fi

	echolog 'Sun Management Center Agent port: ${agent_port}'
else
	echolog 'Invalid Sun Management Center Agent setup.'
	echolog '${VARDIR}/domain-config.x does not exist.'
	exit 1
fi


# setup/verify sunmc platform agent configuration
if [ $SUMODE -eq 0 ]; then
    interactive_platform_setup
else
    sumode_platform_verify
fi


# call handle_security_keys after dealing with SunMC port assignments, after port_changed has been set
handle_security_keys


# query for sc_spare
get_failover


# get the domain ports
get_domain_ports


# Add the EFE module to platform-modules-d.dat
echolog ''
module_add efe platform-modules-d.dat "efe = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.efe sun efe {module = \\\"efe\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.efe:moduleType\\\"; moduleType = \\\"serverSupport\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.4\\\"; i18nModuleName = \\\"base.modules.efe:moduleName\\\"; desc = \\\"base.modules.efe:mediumDesc.\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.efe\\\"; moduleName = \\\"base.modules.efe:moduleName\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.efe:moduleDesc\\\"; console = \\\"efe\\\"; instance = \\\"\\\"; }\""

# Add the scmonitor module to platform-modules-d.dat
echolog ''
module_add scmonitor platform-modules-d.dat "scmonitor = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scmonitor sun scmonitor {module = \\\"scmonitor\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.scmonitor:moduleType\\\"; moduleType = \\\"localApplication\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.5\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scmonitor\\\"; i18nModuleName = \\\"base.modules.scmonitor:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.sunsymon.agent.modules.scmonitor\\\"; moduleName = \\\"SC Monitoring (Sun Fire 15K/12K)\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.scmonitor:moduleDesc\\\"; console = \\\"scmonitor\\\"; instance = \\\"\\\"; }\""

# Remove PDSM from platform-modules-d.dat
# PDSM module is not pre-loaded by default. PDSM is unloadable.  Need
# to remove current entry of PDSM from platform-modules-d.dat, in case the
# user has loaded it. Note that PDSM has to be loaded *after* PCR.
# By automatically removing PDSM's entry at setup time we make sure
# that PCR is always loaded before PDSM
tmp_file=${tmp_dir}/pdsm.${PID}
module_name=pdsm
module_file=${VARDIR}/platform-modules-d.dat
/usr/bin/egrep -v "^[ 	]*${module_name}[ 	]*=" ${module_file} > ${tmp_file}

# move the tmp working copy to the module_file
/usr/bin/mv ${tmp_file} ${module_file}
if [ $? -ne 0 ]; then
	echolog 'Unable to update ${module_file}'
	exit 1
fi
echolog 'Removed pdsm from ${module_file}'

# Add the Platform Config-Reader to platform-modules-d.dat
echolog ''
module_add Config-ReaderStarcat platform-modules-d.dat "Config-ReaderStarcat = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.ReaderStarcat sun Config-ReaderStarcat {enterprise = \\\"sun\\\"; module = \\\"Config-ReaderStarcat\\\"; i18nModuleType = \\\"base.modules.Config-ReaderStarcat:moduleType\\\"; moduleType = \\\"hardware\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.1\\\"; desc = \\\"Config-Reader for Sun Fire 15K/12K Platform\\\"; i18nModuleName = \\\"base.modules.Config-ReaderStarcat:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.ReaderStarcat\\\"; moduleName = \\\"Config Reader (Sun Fire 15K/12K)\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.Config-ReaderStarcat:moduleDesc\\\"; console = \\\"Config-ReaderStarcat\\\"; instance = \\\"\\\"; scSpare = \\\"$sc_spare\\\"; agentPort = \\\"$default_domain_port\\\";}\""

echolog ''
# add the scstatus module to base-modules-d.dat
module_add scstatus base-modules-d.dat "scstatus = \".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scstatus sun scstatus {module = \\\"scstatus\\\"; enterprise = \\\"sun\\\"; i18nModuleType = \\\"base.modules.scstatus:moduleType\\\"; moduleType = \\\"localApplication\\\"; oid = \\\"1.3.6.1.4.1.42.2.85.1.8\\\"; i18nModuleName = \\\"base.modules.scstatus:moduleName\\\"; location = \\\".iso.org.dod.internet.private.enterprises.sun.prod.starcat.sunmc.scstatus\\\"; moduleName = \\\"SC Status\\\"; version = \\\"1.0\\\"; i18nModuleDesc = \\\"base.modules.scstatus:moduleDesc\\\"; console = \\\"scstatus\\\"; usedefault = \\\"false\\\"; instance = \\\"\\\"; scOtherSC = \\\"$sc_spare\\\";}\""



# update symon.conf
echolog ''
/usr/bin/rm -f ${symon_conf}.${PID}
if [ -w ${symon_conf} ]; then
	/usr/bin/grep -v "Sun-Fire-15000" ${symon_conf} > ${symon_conf}.${PID}
fi
/usr/bin/echo 'platform Sun-Fire-15000' >> ${symon_conf}.${PID}
/usr/bin/mv ${symon_conf}.${PID} ${symon_conf} || echolog 'Error setting up ${symon_conf}.'
echolog 'Updated symon.conf information.'


# attempt to remove entry with label, failure is ok, suppress error messages
addon_wrapper "${ESROOT}/sbin/es-dt" -d -l "${es_dt_label}" > /dev/null 2>&1

addon_wrapper "${ESROOT}/sbin/es-dt" -a -h "${platformServer}" -p "${platform_port}" -o "${dot_oid}" -n "${dot_family}" -l "${es_dt_label}"

if [ $? -ne 0 ] ; then
	echolog ''
	echolog 'Failed to Update Discovery Table information via es-dt'
	exit 1
else
	echolog ''
	echolog 'Updated Discovery Table information via es-dt'
fi



#
# blow away the /var/opt/SUNWsymon/cfg/platform-oids-d.dat file
# to insure that the module oids are correct for this
# version of the data model.
#
tmp_file="${oids_file}"
if [ -f ${tmp_file} ] ; then
	/usr/bin/rm -f ${tmp_file}
	if [ -f ${tmp_file} ]; then
		echolog 'Could not remove ${tmp_file}.'
	fi
fi

# create the smart update config file if in interactive mode
[ $SUMODE -eq 0 ] && create_starcat_platform_config "$SCPCFG" "$default_domain_port" "$sc_spare"

echolog  '--------------------------------------------------------------'

exit 0
