/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.cli;

import com.sun.vsp.km.util.KMException;

public class SpinBar {
    SpinBarThread sbt = null;

    public void startSpinning() {
        if (this.sbt == null) {
            this.sbt = new SpinBarThread();
            this.sbt.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAway() throws KMException {
        SpinBarThread spinBarThread = this.sbt;
        synchronized (spinBarThread) {
            this.sbt.shouldStop = true;
        }
        try {
            this.sbt.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Thread.join interrupted");
            throw new KMException(interruptedException.getMessage(), 5004L);
        }
        this.sbt = null;
    }

    class SpinBarThread
    extends Thread {
        public boolean shouldStop = false;
        private boolean first = true;
        private int position = 0;
        private String[] chars = new String[]{"-", "\\", "|", "/"};

        SpinBarThread() {
        }

        public void tick() throws KMException {
            if (this.first) {
                this.first = false;
            } else {
                System.out.print("\b");
            }
            System.out.print(this.chars[this.position % 4]);
            ++this.position;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Sleep interrupted");
                throw new KMException(interruptedException.getMessage(), 5004L);
            }
        }

        public void run() {
            while (!this.shouldStop) {
                try {
                    this.tick();
                }
                catch (KMException kMException) {
                    System.out.println("Fatal error: " + kMException.getMessage());
                    System.exit(1);
                }
            }
            if (!this.first) {
                System.out.print("\b ");
            }
            System.out.flush();
        }
    }
}

