/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.gui;

import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.help.HelpManager;
import com.sun.vsp.km.ic.help.HelpTopic;
import com.sun.vsp.km.ic.icapp.TaskNotifierIfc;
import com.sun.vsp.km.util.KMLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class HelpFrame
extends JFrame
implements ActionListener {
    JPanel main;
    JTree topicTree;
    JLabel subtitle;
    JTextPane contentText;
    JScrollPane leftScroll;
    JScrollPane rightScroll;
    JSplitPane split;
    public JButton close;
    JSeparator line;
    Color backgroundColor;
    GridBagLayout gridbag;
    GridBagConstraints c;
    DefaultMutableTreeNode root;
    static ResourceBundle messages;
    TaskNotifierIfc tn;
    HelpManager hm;

    public HelpFrame(TaskNotifierIfc taskNotifierIfc) {
        this.tn = taskNotifierIfc;
        messages = ResourceBundle.getBundle("gui");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setTitle(messages.getString("HelpTitle"));
        this.setLocation(n - 700, 100);
        this.setSize(600, 400);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.initialize();
        this.layoutHelp();
        this.getContentPane().add(this.main);
        this.pack();
    }

    protected void initialize() {
        this.backgroundColor = new Color(185, 185, 204);
        this.hm = (HelpManager)this.tn.getObject("Help");
        this.contentText = new JTextPane();
        this.contentText.setBackground(Color.white);
        this.contentText.setPreferredSize(new Dimension(10, 10));
        this.contentText.setEditable(false);
        this.root = new DefaultMutableTreeNode(this.hm);
        this.topicTree = new JTree(this.root);
        this.topicTree.setBackground(Color.white);
        this.topicTree.getSelectionModel().setSelectionMode(1);
        this.populateTree(this.hm, this.root);
        this.topicTree.expandPath(new TreePath(this.root));
        this.topicTree.setRootVisible(false);
        this.topicTree.addKeyListener(ICGui.key);
        this.topicTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)HelpFrame.this.topicTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                HelpTopic helpTopic = (HelpTopic)object;
                if (helpTopic.hasContent()) {
                    HelpFrame.this.displayInfo(helpTopic);
                } else {
                    Document document = HelpFrame.this.contentText.getDocument();
                    try {
                        document.remove(0, document.getLength());
                    }
                    catch (Exception exception) {}
                }
            }
        });
        this.leftScroll = new JScrollPane(this.topicTree);
        this.leftScroll.setPreferredSize(new Dimension(10, 10));
        this.rightScroll = new JScrollPane(this.contentText);
        this.rightScroll.setHorizontalScrollBarPolicy(31);
        this.rightScroll.setPreferredSize(new Dimension(10, 10));
        this.rightScroll.addKeyListener(ICGui.key);
        this.split = new JSplitPane(1, this.leftScroll, this.rightScroll);
        this.split.setBackground(this.backgroundColor);
        this.split.setDividerLocation(200);
        this.split.setDividerSize(8);
        this.split.setOneTouchExpandable(true);
        this.close = new JButton(messages.getString("Close"));
        this.close.setBackground(this.backgroundColor);
        this.close.addActionListener(this);
        this.close.addKeyListener(ICGui.key);
        this.close.setToolTipText(messages.getString("CloseTip"));
        this.close.setMnemonic(messages.getString("close_Mnemonic").charAt(0));
        this.main = new JPanel();
        this.main.setPreferredSize(new Dimension(600, 400));
        this.main.setBackground(this.backgroundColor);
        this.subtitle = new JLabel(messages.getString("HelpTitle"));
        this.subtitle.setFont(new Font(null, 0, 12));
        this.subtitle.setForeground(Color.black);
        this.line = new JSeparator();
        this.line.setBackground(new Color(153, 153, 153));
        this.line.setForeground(new Color(153, 153, 153));
        this.line.setPreferredSize(new Dimension(15, 1));
    }

    protected void populateTree(HelpTopic helpTopic, DefaultMutableTreeNode defaultMutableTreeNode) {
        try {
            int n = 0;
            while (n < helpTopic.subTopicCount()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(helpTopic.getSubTopicByIndex(n));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.populateTree(helpTopic.getSubTopicByIndex(n), defaultMutableTreeNode2);
                ++n;
            }
        }
        catch (Exception exception) {
            KMLogger.log((int)KMLogger.WARNING, (String)"HelpFrame", (String)"populateTree()", (String)"Help file not found.");
        }
    }

    protected void displayInfo(HelpTopic helpTopic) {
        String[] stringArray = new String[]{helpTopic.getTopicDescription() + "\n\n", helpTopic.getTopicContent()};
        String[] stringArray2 = new String[]{"title", "text"};
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = this.contentText.addStyle("title", style);
        Style style3 = this.contentText.addStyle("text", style);
        StyleConstants.setBold(style2, true);
        StyleConstants.setFontSize(style2, 14);
        StyleConstants.setBold(style3, false);
        StyleConstants.setFontSize(style3, 12);
        Document document = this.contentText.getDocument();
        try {
            document.remove(0, document.getLength());
            int n = 0;
            while (n < stringArray.length) {
                document.insertString(document.getLength(), stringArray[n], this.contentText.getStyle(stringArray2[n]));
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.contentText.setCaretPosition(0);
    }

    protected void layoutHelp() {
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.main.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 2, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.fill = 1;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.subtitle, this.c);
        this.main.add(this.subtitle);
        this.c.insets = new Insets(0, 11, 0, 11);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.line, this.c);
        this.main.add(this.line);
        this.c.insets = new Insets(12, 12, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.fill = 1;
        this.c.anchor = 11;
        this.gridbag.setConstraints(this.split, this.c);
        this.main.add(this.split);
        this.c.insets = new Insets(11, 0, 11, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 13;
        this.gridbag.setConstraints(this.close, this.c);
        this.main.add(this.close);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.close)) {
            ICGui.helpVisible(false);
        }
    }
}

