/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.gui;

import com.sun.vsp.km.ic.gui.ICGui;
import com.sun.vsp.km.ic.icapp.TaskNotifierIfc;
import com.sun.vsp.km.ic.util.ICPropIfc;
import com.sun.vsp.km.ic.util.ICProperties;
import com.sun.vsp.km.util.CleanUpUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class LicenseFrame
extends JFrame
implements ActionListener {
    GridBagLayout gridbag;
    GridBagConstraints c;
    static ResourceBundle messages;
    Color backgroundColor;
    File licenseFile;
    JScrollPane scroll;
    JEditorPane contentText;
    JPanel main;
    JLabel subtitle;
    JButton accept;
    JButton decline;
    JSeparator line;
    ICGui gui;
    CleanUpUtil clean;
    private final int WIDTH = 450;
    private final int HEIGHT = 550;

    public LicenseFrame(ICGui iCGui, TaskNotifierIfc taskNotifierIfc) {
        this.gui = iCGui;
        this.clean = (CleanUpUtil)taskNotifierIfc.getObject("CleanUpUtil");
        messages = ResourceBundle.getBundle("gui");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.setTitle(messages.getString("LicenseTitle"));
        this.setLocation((n - 450) / 2, (n2 - 550) / 2);
        this.setSize(450, 550);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LicenseFrame.this.clean.exitWith(0);
            }
        });
        this.initialize();
        this.layoutFrame();
        this.getContentPane().add(this.main);
        this.pack();
        this.show();
    }

    protected void initialize() {
        this.backgroundColor = new Color(185, 185, 204);
        ICPropIfc iCPropIfc = ICProperties.getInstance();
        try {
            this.licenseFile = new File(System.getProperty("ICAPP_HOME") + System.getProperty("file.separator") + iCPropIfc.getProperty("license_file"));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        this.contentText = new JEditorPane();
        this.contentText.setContentType("text/rtf");
        this.contentText.setBackground(Color.white);
        this.contentText.setPreferredSize(new Dimension(10, 10));
        this.contentText.setEditable(false);
        try {
            this.contentText.read((InputStream)new FileInputStream(this.licenseFile), (Object)null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.scroll = new JScrollPane(this.contentText);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setPreferredSize(new Dimension(10, 10));
        this.accept = new JButton(messages.getString("agree"));
        this.accept.setBackground(this.backgroundColor);
        this.accept.addActionListener(this);
        this.accept.setMnemonic(messages.getString("agree").charAt(0));
        this.decline = new JButton(messages.getString("decline"));
        this.decline.setBackground(this.backgroundColor);
        this.decline.addActionListener(this);
        this.decline.setMnemonic(messages.getString("decline").charAt(0));
        this.main = new JPanel();
        this.main.setPreferredSize(new Dimension(450, 550));
        this.main.setBackground(this.backgroundColor);
        this.subtitle = new JLabel(messages.getString("LicenseSubtitle"));
        this.subtitle.setFont(new Font(null, 0, 12));
        this.subtitle.setForeground(Color.black);
        this.line = new JSeparator();
        this.line.setBackground(new Color(153, 153, 153));
        this.line.setForeground(new Color(153, 153, 153));
        this.line.setPreferredSize(new Dimension(15, 1));
    }

    protected void layoutFrame() {
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.main.setLayout(this.gridbag);
        this.c.insets = new Insets(12, 12, 2, 6);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 2;
        this.c.fill = 1;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.subtitle, this.c);
        this.main.add(this.subtitle);
        this.c.insets = new Insets(0, 11, 0, 11);
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 2;
        this.c.fill = 2;
        this.c.anchor = 18;
        this.gridbag.setConstraints(this.line, this.c);
        this.main.add(this.line);
        this.c.insets = new Insets(12, 12, 0, 11);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 2;
        this.c.fill = 1;
        this.c.anchor = 11;
        this.gridbag.setConstraints(this.scroll, this.c);
        this.main.add(this.scroll);
        this.c.insets = new Insets(11, 0, 11, 3);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 13;
        this.gridbag.setConstraints(this.accept, this.c);
        this.main.add(this.accept);
        this.c.insets = new Insets(11, 3, 11, 0);
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.gridx = 1;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.c.fill = 0;
        this.c.anchor = 17;
        this.gridbag.setConstraints(this.decline, this.c);
        this.main.add(this.decline);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.accept)) {
            this.gui.showMain();
            ICPropIfc iCPropIfc = ICProperties.getInstance();
            iCPropIfc.setProperty("license_agree", "true");
            try {
                iCPropIfc.store();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.dispose();
        } else if (actionEvent.getSource().equals(this.decline)) {
            this.clean.exitWith(1);
        }
    }
}

