/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator;

import com.sun.vsp.km.framework.KMObjectLoggable;
import com.sun.vsp.km.ic.icapp.ICAppObject;
import com.sun.vsp.km.ic.validator.CheckAttributeIfc;
import com.sun.vsp.km.ic.validator.CheckIfc;
import com.sun.vsp.km.ic.validator.CheckResultSummaryIfc;
import com.sun.vsp.km.ic.validator.CheckResultSummaryImpl;
import com.sun.vsp.km.ic.validator.CheckResultsIfc;
import com.sun.vsp.km.util.KMLogger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public abstract class AbstractCheckResults
extends ICAppObject
implements CheckResultsIfc,
KMObjectLoggable {
    protected SortedMap checkList = Collections.synchronizedSortedMap(new TreeMap());
    protected SortedMap attributes = Collections.synchronizedSortedMap(new TreeMap());
    protected CheckResultSummaryImpl summary = new CheckResultSummaryImpl();
    public static String CHECK_RESULTS = "check_results";

    public AbstractCheckResults() {
        super("CheckResults", "$Revision: 1.1.1.1 $");
    }

    public Iterator getAllAttributes() {
        return this.attributes.values().iterator();
    }

    public CheckIfc getCheck(int n) {
        return (CheckIfc)this.checkList.get(new Integer(n));
    }

    public boolean containsCheck(int n) {
        return this.checkList.containsKey(new Integer(n));
    }

    public int checkCount() {
        return this.checkList.size();
    }

    public CheckAttributeIfc getAttribute(String string) {
        return (CheckAttributeIfc)this.attributes.get(string);
    }

    public void addAttribute(CheckAttributeIfc checkAttributeIfc) {
        this.attributes.put(checkAttributeIfc.getName(), checkAttributeIfc);
    }

    public Iterator getAllChecks() {
        Collection collection = this.checkList.values();
        return collection.iterator();
    }

    public Iterator getPassedChecks() {
        Collection collection = this.checkList.values();
        Vector<CheckIfc> vector = new Vector<CheckIfc>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (checkIfc.getExecutionError() || !checkIfc.getApplicability() || !checkIfc.getPassed()) continue;
            vector.add(checkIfc);
        }
        return vector.iterator();
    }

    public Iterator getFailedChecks() {
        Collection collection = this.checkList.values();
        Vector<CheckIfc> vector = new Vector<CheckIfc>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (checkIfc.getExecutionError() || !checkIfc.getApplicability() || checkIfc.getPassed()) continue;
            vector.add(checkIfc);
        }
        return vector.iterator();
    }

    public Iterator getExecutionErrorChecks() {
        Collection collection = this.checkList.values();
        Vector<CheckIfc> vector = new Vector<CheckIfc>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CheckIfc checkIfc = (CheckIfc)iterator.next();
            if (!checkIfc.getExecutionError()) continue;
            vector.add(checkIfc);
        }
        return vector.iterator();
    }

    public void addCheck(CheckIfc checkIfc) {
        try {
            this.log(KMLogger.INFO, "Adding check to the results [" + checkIfc.getCheckNumber() + "]");
            if (checkIfc.getExecutionError()) {
                this.log(KMLogger.WARNING, "Execution eror [" + checkIfc.getCheckNumber() + "] description [" + checkIfc.getExecutionErrorDescription() + "]");
            }
        }
        catch (Exception exception) {
            System.err.println("Error logging check number [" + checkIfc.getCheckNumber() + "]");
        }
        this.summary.setTotal(this.summary.getTotal() + 1);
        if (checkIfc.getExecutionError()) {
            this.summary.setErrors(this.summary.getErrors() + 1);
        } else if (!checkIfc.getApplicability()) {
            this.summary.setNotApplicable(this.summary.getNotApplicable() + 1);
        } else if (checkIfc.getPassed()) {
            this.summary.setPassed(this.summary.getPassed() + 1);
        } else {
            switch (checkIfc.getSeverity()) {
                case 1: {
                    this.summary.setLow(this.summary.getLow() + 1);
                    break;
                }
                case 2: {
                    this.summary.setMedium(this.summary.getMedium() + 1);
                    break;
                }
                case 3: {
                    this.summary.setHigh(this.summary.getHigh() + 1);
                    break;
                }
                case 4: {
                    this.summary.setCritical(this.summary.getCritical() + 1);
                    break;
                }
            }
        }
        this.checkList.put(new Integer(checkIfc.getCheckNumber()), checkIfc);
    }

    public CheckResultSummaryIfc getSummary() {
        return this.summary;
    }

    public abstract void storeCheckResults(String var1);
}

