/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator;

import com.sun.vsp.km.ic.validator.AbstractCheckResults;
import com.sun.vsp.km.ic.validator.CheckImpl;
import com.sun.vsp.km.ic.validator.XMLCheckAttributeImpl;
import com.sun.vsp.km.ic.validator.XMLCheckResultsIfc;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLCheckResults
extends AbstractCheckResults
implements XMLCheckResultsIfc {
    protected static String newLine = System.getProperty("line.separator", "\n");

    public void storeCheckResults(String string) {
        Document document = this.createDOM();
        this.serialize(document, string);
    }

    public Element getElement() {
        Document document = this.createDOM();
        return document.getDocumentElement();
    }

    protected Document createDOM() {
        Document document = this.createDocument();
        Element element = document.createElement("checkresults");
        element.appendChild(this.getSummaryElement(document));
        element.appendChild(this.getAttributesElement(document, this.getAllAttributes(), "attributes"));
        element.appendChild(this.getCheckListElement(document));
        document.appendChild(element);
        return document;
    }

    protected Element getCheckListElement(Document document) {
        Element element = document.createElement("checklist");
        Iterator iterator = this.getAllChecks();
        while (iterator.hasNext()) {
            CheckImpl checkImpl = (CheckImpl)iterator.next();
            this.appendChildNode(element, this.getCheckElement(document, checkImpl));
        }
        return element;
    }

    protected Element getCheckElement(Document document, CheckImpl checkImpl) {
        Element element = document.createElement("check");
        this.appendChildNode(element, this.getElementAddTextNode(document, "checknumber", checkImpl.getCheckNumber()));
        this.appendChildNode(element, this.getElementAddTextNode(document, "passed", String.valueOf(checkImpl.getPassed())));
        this.appendChildNode(element, this.getElementAddTextNode(document, "severity", checkImpl.getSeverity()));
        this.appendChildNode(element, this.getElementAddTextNode(document, "analysis", checkImpl.getAnalysis(), (short)4));
        this.appendChildNode(element, this.getElementAddTextNode(document, "problemdescription", checkImpl.getProblemDescription(), (short)4));
        this.appendChildNode(element, this.getElementAddTextNode(document, "recommendation", checkImpl.getRecommendation(), (short)4));
        this.appendChildNode(element, this.getElementAddTextNode(document, "applicability", String.valueOf(checkImpl.getApplicability())));
        this.appendChildNode(element, this.getElementAddTextNode(document, "executionerror", String.valueOf(checkImpl.getExecutionError())));
        if (checkImpl.getExecutionError()) {
            this.appendChildNode(element, this.getElementAddTextNode(document, "errordescription", checkImpl.getExecutionErrorDescription(), (short)4));
        }
        this.appendChildNode(element, this.getAttributesElement(document, checkImpl.getAllAttributes(), "attributes"));
        return element;
    }

    protected Element getAttributesElement(Document document, Iterator iterator, String string) {
        Element element = document.createElement(string);
        while (iterator.hasNext()) {
            XMLCheckAttributeImpl xMLCheckAttributeImpl = (XMLCheckAttributeImpl)iterator.next();
            this.appendChildNode(element, this.getElementAddTextNode(document, xMLCheckAttributeImpl.getName(), xMLCheckAttributeImpl.getValue(), xMLCheckAttributeImpl.getNodeType()));
        }
        return element;
    }

    protected Element getElementAddTextNode(Document document, String string, String string2) {
        return this.getElementAddTextNode(document, string, string2, (short)3);
    }

    protected Element getElementAddTextNode(Document document, String string, String string2, short s) {
        Element element = null;
        if (string2 != null) {
            element = document.createElement(string);
            if (s == 4) {
                this.appendChildNode(element, document.createCDATASection(string2));
            } else {
                this.appendChildNode(element, document.createTextNode(string2));
            }
        }
        return element;
    }

    protected Element getElementAddTextNode(Document document, String string, int n) {
        return this.getElementAddTextNode(document, string, String.valueOf(n));
    }

    protected Element getSummaryElement(Document document) {
        Element element = document.createElement("summary");
        element.appendChild(this.getElementAddTextNode(document, "critical", this.getSummary().getCritical()));
        element.appendChild(this.getElementAddTextNode(document, "medium", this.getSummary().getMedium()));
        element.appendChild(this.getElementAddTextNode(document, "high", this.getSummary().getHigh()));
        element.appendChild(this.getElementAddTextNode(document, "low", this.getSummary().getLow()));
        element.appendChild(this.getElementAddTextNode(document, "passed", this.getSummary().getPassed()));
        element.appendChild(this.getElementAddTextNode(document, "notapplicable", this.getSummary().getNotApplicable()));
        element.appendChild(this.getElementAddTextNode(document, "errors", this.getSummary().getErrors()));
        element.appendChild(this.getElementAddTextNode(document, "total", this.getSummary().getTotal()));
        return element;
    }

    protected void serialize(Document document, String string) {
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)new FileWriter(string), null);
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {}
    }

    protected Document createDocument() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return document;
    }

    protected void appendChildNode(Node node, Node node2) {
        if (node2 != null) {
            node.appendChild(node2);
        }
    }
}

