/*
 * Decompiled with CFR 0.152.
 */
package com.sun.vsp.km.ic.validator;

import com.sun.vsp.km.ic.validator.CheckImpl;
import com.sun.vsp.km.ic.validator.XMLCheckAttributeImpl;
import com.sun.vsp.km.ic.validator.XMLCheckResults;
import com.sun.vsp.km.util.KMException;
import java.io.IOException;
import java.util.SortedMap;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLCheckResultsFromFile
extends XMLCheckResults {
    protected static String VALIDATE_PROPERTY = "http://xml.org/sax/features/validation";
    protected String fileName;
    protected boolean validate = false;

    public XMLCheckResultsFromFile(String string) throws KMException {
        this.fileName = string;
        this.loadFile();
    }

    protected void loadFile() throws KMException {
        if (this.fileName == null) {
            throw new KMException(this.fileName, 5002L);
        }
        this.init(this.fileName);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    protected void init(String string) throws KMException {
        Node node;
        Node node2;
        Node node3;
        Node node4 = this.getRootNodeFromFile(string);
        Node node5 = this.findChildNode(node4, "attributes");
        if (node5 != null) {
            this.loadAttributes(node5, this.attributes);
        }
        if ((node3 = this.findChildNode(node4, "checklist")) != null) {
            this.loadCheckList(node3);
        }
        if ((node2 = this.findChildNode(node4, "summary")) != null && (node = this.findChildNode(node2, "attributes")) != null) {
            this.loadAttributes(node, this.summary.attributes);
        }
    }

    protected Node findChildNode(Node node, String string) {
        Node node2 = null;
        if (node.hasChildNodes()) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                if (node3.getNodeName().equals(string)) {
                    node2 = node3;
                    break;
                }
                node3 = node3.getNextSibling();
            }
        }
        return node2;
    }

    protected Node getRootNodeFromFile(String string) throws KMException {
        Document document = null;
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature(VALIDATE_PROPERTY, this.validate);
            dOMParser.parse(string);
            document = dOMParser.getDocument();
        }
        catch (IOException iOException) {
            throw new KMException(string, 5002L);
        }
        catch (SAXException sAXException) {
            throw new KMException(sAXException.getMessage(), 5209L);
        }
        return this.findChildNode(document, "checkresults");
    }

    protected void loadCheckList(Node node) throws KMException {
        if (!node.getNodeName().equals("checklist")) {
            throw new KMException(5209L);
        }
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if ("check".equals(node2.getNodeName())) {
                    CheckImpl checkImpl = this.loadCheck(node2);
                    this.addCheck(checkImpl);
                }
                node2 = node2.getNextSibling();
            }
        }
    }

    protected CheckImpl loadCheck(Node node) {
        Node node2;
        String string;
        String string2;
        CheckImpl checkImpl = new CheckImpl();
        checkImpl.setCheckNumber(this.findIntChildValue(node, "checknumber"));
        checkImpl.setPassed(this.findBooleanChildValue(node, "passed"));
        checkImpl.setSeverity(this.findIntChildValue(node, "severity"));
        String string3 = this.findChildValue(node, "analysis");
        if (string3 != null) {
            checkImpl.setAnalysis(string3);
        }
        if ((string2 = this.findChildValue(node, "problemdescription")) != null) {
            checkImpl.setProblemDescription(string2);
        }
        if ((string = this.findChildValue(node, "recommendation")) != null) {
            checkImpl.setRecommendation(string);
        }
        checkImpl.setApplicability(this.findBooleanChildValue(node, "applicability"));
        checkImpl.setExecutionError(this.findBooleanChildValue(node, "executionerror"));
        String string4 = this.findChildValue(node, "errordescription");
        if (string4 != null) {
            checkImpl.setExecutionErrorDescription(string4);
        }
        if ((node2 = this.findChildNode(node, "attributes")) != null) {
            this.loadAttributes(node2, checkImpl.attributes);
        }
        return checkImpl;
    }

    protected XMLCheckAttributeImpl getAttribute(Node node) {
        XMLCheckAttributeImpl xMLCheckAttributeImpl = null;
        if (node.getNodeType() == 1) {
            xMLCheckAttributeImpl = new XMLCheckAttributeImpl(node.getNodeName(), this.getNodeText(node), this.getNodeTextType(node));
            if (node.hasChildNodes()) {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    if (node2.getNodeType() == 1) {
                        XMLCheckAttributeImpl xMLCheckAttributeImpl2 = this.getAttribute(node2);
                        if (xMLCheckAttributeImpl != null) {
                            xMLCheckAttributeImpl.addChild(xMLCheckAttributeImpl2);
                        }
                    }
                    node2 = node2.getNextSibling();
                }
            }
        }
        return xMLCheckAttributeImpl;
    }

    protected void loadAttributes(Node node, SortedMap sortedMap) {
        if (node == null || sortedMap == null || !node.getNodeName().equals("attributes")) {
            // empty if block
        }
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                XMLCheckAttributeImpl xMLCheckAttributeImpl;
                if (node2.getNodeType() == 1 && (xMLCheckAttributeImpl = this.getAttribute(node2)) != null) {
                    sortedMap.put(xMLCheckAttributeImpl.getName(), xMLCheckAttributeImpl);
                }
                node2 = node2.getNextSibling();
            }
        }
    }

    protected int findIntChildValue(Node node, String string) {
        int n = -1;
        String string2 = this.findChildValue(node, string);
        if (string2 != null) {
            n = Integer.valueOf(string2);
        }
        return n;
    }

    protected boolean findBooleanChildValue(Node node, String string) {
        boolean bl = false;
        String string2 = this.findChildValue(node, string);
        if (string2 != null) {
            bl = Boolean.valueOf(string2);
        }
        return bl;
    }

    protected String findChildValue(Node node, String string) {
        Node node2 = this.findChildNode(node, string);
        String string2 = null;
        string2 = this.getNodeText(node2);
        return string2;
    }

    protected String getNodeText(Node node) {
        String string = null;
        if (node != null && node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 4 || node2.getNodeType() == 3) {
                    string = node2.getNodeValue();
                }
                node2 = node2.getNextSibling();
            }
        }
        return string;
    }

    protected short getNodeTextType(Node node) {
        short s = -1;
        if (node != null && node.hasChildNodes()) {
            s = node.getFirstChild().getNodeType();
        }
        return s;
    }
}

