/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.tab.util;

import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.IURLDecoder;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.jsp.tab.ModifiableTab;
import com.sun.portal.providers.containers.jsp.tab.UnmodifiableTab;
import com.sun.portal.providers.containers.jsp.tab.util.TabEditException;
import com.sun.portal.providers.containers.jsp.tab.util.TabException;
import com.sun.portal.providers.containers.jsp.tab.util.TabFactory;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class TabData {
    private ContainerProviderContext containerProvidercontext = null;
    private String channel = null;
    private String props_key = "TabProperties";
    private ResourceBundle bundle = null;

    public TabData(ContainerProviderContext cpc, String channel, ResourceBundle bundle) {
        this.channel = channel;
        this.containerProvidercontext = cpc;
        this.bundle = bundle;
    }

    public int getMaxTabs() throws TabException {
        try {
            return this.containerProvidercontext.getIntegerProperty(this.channel, "maxTabs");
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getMaxTabs(): ", pce);
        }
    }

    public List getSelectedTabs() throws TabException {
        ArrayList<UnmodifiableTab> tabs = new ArrayList<UnmodifiableTab>();
        List t = null;
        int size = 0;
        Map tabPropsMap = this.getTabPropsMap();
        try {
            t = this.containerProvidercontext.getSelectedChannels(this.channel);
            size = t.size();
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getSelectedTabs(): ", pce);
        }
        int i = 0;
        while (i < size) {
            String e = (String)t.get(i);
            UnmodifiableTab tab = TabFactory.createUnmodifiable(e, tabPropsMap);
            tabs.add(tab);
            ++i;
        }
        return tabs;
    }

    public List getAvailableTabs() throws TabException {
        ArrayList<UnmodifiableTab> tabs = new ArrayList<UnmodifiableTab>();
        List t = null;
        int size = 0;
        Map tabPropsMap = this.getTabPropsMap();
        try {
            t = this.containerProvidercontext.getAvailableChannels(this.channel);
            size = t.size();
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getAvailableTabs(): ", pce);
        }
        int i = 0;
        while (i < size) {
            String e = (String)t.get(i);
            UnmodifiableTab tab = TabFactory.createUnmodifiable(e, tabPropsMap);
            tabs.add(tab);
            ++i;
        }
        return tabs;
    }

    public UnmodifiableTab getStartTab() throws TabException {
        String name = this.getStartTabName();
        Map tabPropsMap = this.getTabPropsMap();
        UnmodifiableTab t = TabFactory.createUnmodifiable(name, tabPropsMap);
        return t;
    }

    public String getStartTabName() throws TabException {
        try {
            return this.containerProvidercontext.getStringProperty(this.channel, "startTab");
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getStartTabName(): ", pce);
        }
    }

    public UnmodifiableTab getMakeTab() throws TabException {
        String m = this.getMakeTabName();
        Map tabPropsMap = this.getTabPropsMap();
        UnmodifiableTab maketab = TabFactory.createUnmodifiable(m, tabPropsMap);
        return maketab;
    }

    public String getMakeTabName() throws TabException {
        try {
            return this.containerProvidercontext.getStringProperty(this.channel, "makeTabChannel");
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getMakeTabName(): ", pce);
        }
    }

    public String getMakeTabProviderName() throws TabException {
        try {
            return this.containerProvidercontext.getStringProperty(this.channel, "makeTabProvider");
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getMakeTabProviderName(): ", pce);
        }
    }

    public String getSelectedTabName() throws TabException {
        String name = null;
        try {
            String n = this.containerProvidercontext.getClientProperty(this.channel + ".selectedTab");
            if (n != null && n.length() > 0 && this.containerProvidercontext.getAvailableChannels(this.channel).contains(n)) {
                name = n;
            } else {
                n = this.getStartTabName();
                if (n != null && n.length() > 0 && this.containerProvidercontext.getAvailableChannels(this.channel).contains(n)) {
                    name = n;
                } else {
                    n = (String)this.containerProvidercontext.getAvailableChannels(this.channel).get(0);
                    this.setStartTabName(n);
                    name = n;
                }
                this.setSelectedTabName(n);
            }
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getSelectedName(): ", pce);
        }
        return name;
    }

    public UnmodifiableTab getSelectedTab() throws TabException {
        String name = this.getSelectedTabName();
        Map tabPropsMap = this.getTabPropsMap();
        UnmodifiableTab selectedTab = TabFactory.createUnmodifiable(name, tabPropsMap);
        return selectedTab;
    }

    public UnmodifiableTab getTab(String name) throws TabException {
        Map tabPropsMap = this.getTabPropsMap();
        UnmodifiableTab t = TabFactory.createUnmodifiable(name, tabPropsMap);
        if (t == null) {
            throw new TabException("TabData.getTab():couldn't get tab name=" + t);
        }
        return t;
    }

    public void setTab(ModifiableTab t, boolean selected) throws TabException {
        if (t == null) {
            throw new TabException("TabData.setTab():tried to set null tab");
        }
        this.addSelectedTab(t);
        if (selected) {
            this.setSelectedTabName(t.getName());
        }
    }

    public void setStartTabName(String name) throws TabException {
        this.getTab(name);
        this.writeStartTabName(name);
    }

    public void setSelectedTabName(String tabName) throws TabException {
        try {
            this.getTab(tabName);
        }
        catch (TabException te) {
            throw new TabException("TabData.setSelectedTabName():attempt to set selected to non-existent tab");
        }
        this.writeSelectedTabName(tabName);
    }

    private void writeStartTabName(String name) throws TabException {
        try {
            this.containerProvidercontext.setStringProperty(this.channel, "startTab", name);
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.writeStartTabName(): ", pce);
        }
    }

    public void addSelectedTab(ModifiableTab t) throws TabException {
        try {
            List selectedChannels = this.containerProvidercontext.getSelectedChannels(this.channel);
            if (!selectedChannels.contains(t.getName())) {
                selectedChannels.add(t.getName());
                this.containerProvidercontext.setSelectedChannels(this.channel, selectedChannels);
            }
            Map tabPropsMap = this.getTabPropsMap();
            tabPropsMap.remove(t.getName());
            tabPropsMap.put(t.getName(), t.getTabMap());
            this.containerProvidercontext.setCollectionProperty(this.channel, this.props_key, tabPropsMap);
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.addSelectedTab(): ", pce);
        }
    }

    public void addTab(String name, String title) throws TabException {
        UnmodifiableTab tab = this.getTab(name);
        ModifiableTab newTab = TabFactory.createModifiable(tab);
        newTab.setDisplayname(title);
        this.setTab(newTab, true);
    }

    public URL getTabURL(UnmodifiableTab tab, HttpServletRequest req) throws TabException {
        URL url = null;
        try {
            StringBuffer urlbuffer = new StringBuffer(this.containerProvidercontext.getDesktopURL(req));
            urlbuffer.append("?");
            urlbuffer.append(this.channel);
            urlbuffer.append(".setSelected=");
            urlbuffer.append(tab.getEncodedName());
            urlbuffer.append("&last=false");
            url = new URL(urlbuffer.toString());
        }
        catch (MalformedURLException me) {
            throw new TabException("TabData.getTabURL():couldn't create the url", me);
        }
        return url;
    }

    public void removeRenameTab(HttpServletRequest req) throws TabException {
        UnmodifiableTab startTab = null;
        UnmodifiableTab selectedTab = null;
        startTab = this.getStartTab();
        selectedTab = this.getSelectedTab();
        String removeTag = this.channel + "_remove_";
        String renameTag = this.channel + "_rename_";
        String startTag = this.channel + ".setStart";
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            try {
                key = I18n.IURLDecode((String)IURLDecoder.decode((String)key));
            }
            catch (Exception ex) {
                if (!this.containerProvidercontext.isDebugWarningEnabled()) continue;
                this.containerProvidercontext.debugWarning("TabData.removeRenameTab()", ex);
                continue;
            }
            if (this.containerProvidercontext.isDebugMessageEnabled()) {
                this.containerProvidercontext.debugMessage("TabData.removeRenameTab(): " + key + "=" + val);
            }
            try {
                Map tabMap;
                ModifiableTab mt;
                String tabTitle;
                String tabName;
                if (key.startsWith(removeTag)) {
                    tabName = key.substring(key.lastIndexOf("_") + 1);
                    if (!val.equals("1")) continue;
                    this.removeTab(tabName);
                    continue;
                }
                if (key.startsWith(startTag)) {
                    try {
                        val = I18n.IURLDecode((String)IURLDecoder.decode((String)val));
                    }
                    catch (Exception ex) {
                        if (!this.containerProvidercontext.isDebugWarningEnabled()) continue;
                        this.containerProvidercontext.debugWarning("TabData.removeRenameTab()", ex);
                        continue;
                    }
                    if (!this.containerProvidercontext.getSelectedChannels(this.channel).contains(val)) continue;
                    this.setStartTabName(val);
                    continue;
                }
                if (!key.startsWith(renameTag) || val.length() == 0 || (tabTitle = (mt = TabFactory.createModifiable(tabName = key.substring(key.lastIndexOf("_") + 1), tabMap = this.getTabPropsMap())).getDisplayname()).equals(val)) continue;
                if (val.length() <= 0) {
                    throw new TabException("TabData.removeRenameTab():Tab names must be non-null!");
                }
                val = val.replace('\'', ' ');
                val = val.replace('\"', ' ');
                mt.setDisplayname(val);
                this.addSelectedTab(mt);
            }
            catch (ProviderContextException pce) {
                throw new TabException("TabData.removeRenameTab(): ", pce);
            }
        }
    }

    public void removeTab(String name) throws TabException {
        try {
            List selectedChannels = this.containerProvidercontext.getSelectedChannels(this.channel);
            List availableChannels = this.containerProvidercontext.getAvailableChannels(this.channel);
            UnmodifiableTab tab = this.getTab(name);
            String startTab = this.getStartTabName();
            String selectedTab = this.getSelectedTabName();
            if (!selectedChannels.contains(name)) {
                throw new TabException("TabData.removeTab():couldn't remove tab, it didn't exist");
            }
            selectedChannels.remove(name);
            this.containerProvidercontext.setSelectedChannels(this.channel, selectedChannels);
            if (startTab.equals(name)) {
                this.setStartTabName(selectedTab);
            }
            if (selectedTab.equals(name)) {
                this.setSelectedTabName(startTab);
            }
            if (!tab.isPredefined()) {
                if (availableChannels.contains(name)) {
                    availableChannels.remove(name);
                    this.containerProvidercontext.setAvailableChannels(this.channel, availableChannels);
                }
                this.containerProvidercontext.removeChannel(name);
                Map tabPropsMap = this.getTabPropsMap();
                tabPropsMap.remove(name);
                this.containerProvidercontext.setCollectionProperty(this.channel, this.props_key, tabPropsMap);
            }
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.removeTab(): ", pce);
        }
    }

    public Map makeNewTab(HttpServletRequest req) throws ProviderException {
        ModifiableTab newTab;
        HashMap<String, Object> results;
        block27: {
            String topic;
            Map makeChannelMap;
            String makeChannel;
            String makeTabProviderName;
            int channelNumber;
            Map tabPropsMap;
            List selectedChannels;
            List availChannels;
            String tabDesc;
            String tabName;
            block26: {
                tabName = req.getParameter(this.channel + ".tabName");
                if (tabName == null || tabName.length() == 0) {
                    if (this.containerProvidercontext.isDebugMessageEnabled()) {
                        this.containerProvidercontext.debugMessage("TabData.makeNewTab(): no tab name specificed");
                    }
                    String err = this.bundle.getString("tabNameNull");
                    throw new TabEditException(err);
                }
                tabDesc = req.getParameter(this.channel + ".tabDesc");
                if (tabDesc == null || tabDesc.length() == 0) {
                    if (this.containerProvidercontext.isDebugMessageEnabled()) {
                        this.containerProvidercontext.debugMessage("TabData.makeNewTab(): no tab desc specificed");
                    }
                    String err = this.bundle.getString("tabDescNull");
                    throw new TabEditException(err);
                }
                if (this.containerProvidercontext.isDebugMessageEnabled()) {
                    this.containerProvidercontext.debugMessage("TabData.makeNewTab(): tabName=" + tabName + "tabDesc=" + tabDesc);
                }
                availChannels = null;
                selectedChannels = null;
                tabPropsMap = null;
                channelNumber = 0;
                try {
                    availChannels = this.containerProvidercontext.getAvailableChannels(this.channel);
                    selectedChannels = this.containerProvidercontext.getSelectedChannels(this.channel);
                    tabPropsMap = this.getTabPropsMap();
                    channelNumber = this.containerProvidercontext.getIntegerProperty(this.channel, "channelNumber");
                }
                catch (ProviderContextException pce) {
                    throw new ProviderException("TabData.makeNewTab(): ", pce);
                }
                if (selectedChannels.size() >= this.getMaxTabs()) {
                    String err = this.bundle.getString("maxTabs");
                    throw new TabEditException(err);
                }
                makeTabProviderName = this.getMakeTabProviderName();
                makeChannel = this.getMakeTabName();
                makeChannelMap = (Map)tabPropsMap.get(makeChannel);
                tabName = tabName.replace('\'', ' ');
                tabName = tabName.replace('\"', ' ');
                topic = null;
                try {
                    topic = I18n.IURLDecode((String)IURLDecoder.decode((String)req.getParameter(this.channel + ".tabTopic")));
                }
                catch (Exception ex) {
                    if (!this.containerProvidercontext.isDebugWarningEnabled()) break block26;
                    this.containerProvidercontext.debugWarning("TabData.makeNewTab()", ex);
                }
            }
            if (topic == null || topic.length() == 0) {
                if (this.containerProvidercontext.isDebugWarningEnabled()) {
                    this.containerProvidercontext.debugWarning("TabData.makeNewTab(): no tab topic selected, assuming make");
                }
                topic = makeChannel;
            }
            if (this.containerProvidercontext.isDebugMessageEnabled()) {
                this.containerProvidercontext.debugMessage("TabData.makeNewTab(): topic=" + topic);
            }
            boolean make = false;
            results = new HashMap<String, Object>();
            if (topic.equals(makeChannel)) {
                make = true;
            }
            if (this.containerProvidercontext.isDebugMessageEnabled()) {
                this.containerProvidercontext.debugMessage("TabData.makeNewTab(): make=" + make);
            }
            results.put("make", new Boolean(make));
            newTab = null;
            try {
                if (!make) {
                    if (availChannels.contains(topic) && !selectedChannels.contains(topic)) {
                        this.addTab(topic, tabName);
                        return results;
                    }
                    String providerName = this.containerProvidercontext.getProviderName(topic);
                    Map predefinedTabMap = (Map)tabPropsMap.get(topic);
                    String channelName = this.channel + '/' + makeChannel + channelNumber;
                    Map tabMap = this.createTabPropsMap(tabName, tabDesc, predefinedTabMap);
                    Map propertiesMap = null;
                    this.containerProvidercontext.createContainer(channelName, providerName);
                    this.containerProvidercontext.setAvailableChannels(channelName, this.containerProvidercontext.getAvailableChannels(topic));
                    this.containerProvidercontext.setSelectedChannels(channelName, this.containerProvidercontext.getSelectedChannels(topic));
                    propertiesMap = this.containerProvidercontext.getCollectionProperty(this.channel, "propertiesToCopy");
                    Set keys = propertiesMap.keySet();
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        Object value = this.containerProvidercontext.getProperty(topic, key, null);
                        if (value != null) {
                            this.containerProvidercontext.setProperty(channelName, key, value);
                        }
                        if (!key.equals("categories")) continue;
                        Map categoriesMap = this.containerProvidercontext.getCollectionProperty(topic, "categories");
                        Set categories = categoriesMap.keySet();
                        Iterator j = categories.iterator();
                        while (j.hasNext()) {
                            String category = (String)j.next();
                            Object categoryValue = this.containerProvidercontext.getProperty(topic, category, null);
                            if (categoryValue == null) continue;
                            this.containerProvidercontext.setProperty(channelName, category, categoryValue);
                        }
                    }
                    tabPropsMap.put(channelName, tabMap);
                    this.containerProvidercontext.setCollectionProperty(this.channel, this.props_key, tabPropsMap);
                    try {
                        newTab = TabFactory.createModifiable(channelName, tabPropsMap);
                    }
                    catch (TabException te) {
                        throw new ProviderException("couldn't create tab based on predefined tab", te);
                    }
                    availChannels.add(channelName);
                    this.containerProvidercontext.setAvailableChannels(this.channel, availChannels);
                    this.containerProvidercontext.setIntegerProperty(this.channel, "channelNumber", ++channelNumber);
                    break block27;
                }
                String channelName = this.channel + '/' + makeChannel + channelNumber;
                this.containerProvidercontext.createContainer(channelName, makeTabProviderName);
                Map tabMap = this.createTabPropsMap(tabName, tabDesc, makeChannelMap);
                Map defaultChannelMap = this.containerProvidercontext.getCollectionProperty(this.channel, "defaultChannelList");
                Set keys = defaultChannelMap.keySet();
                ArrayList defaultChannelList = new ArrayList(keys);
                this.containerProvidercontext.setAvailableChannels(channelName, defaultChannelList);
                this.containerProvidercontext.setSelectedChannels(channelName, defaultChannelList);
                tabPropsMap.put(channelName, tabMap);
                this.containerProvidercontext.setCollectionProperty(this.channel, this.props_key, tabPropsMap);
                try {
                    newTab = TabFactory.createModifiable(channelName, tabPropsMap);
                }
                catch (TabException te) {
                    throw new ProviderException("couldn't copy make tab", te);
                }
                availChannels.add(channelName);
                this.containerProvidercontext.setAvailableChannels(this.channel, availChannels);
                this.containerProvidercontext.setIntegerProperty(this.channel, "channelNumber", ++channelNumber);
            }
            catch (ProviderContextException pce) {
                throw new ProviderException("TabData.makeRenameTab(): ", pce);
            }
        }
        this.setTab(newTab, true);
        results.put("tab", newTab);
        return results;
    }

    private Map createTabPropsMap(String name, String desc, Map predefinedMap) {
        HashMap<String, Object> tabMap = new HashMap<String, Object>();
        tabMap.put("title", name);
        if (desc != null && desc.length() != 0) {
            tabMap.put("desc", desc);
        } else {
            tabMap.put("desc", (String)predefinedMap.get("desc"));
        }
        tabMap.put("removable", new Boolean("true"));
        tabMap.put("renamable", (Boolean)predefinedMap.get("renamable"));
        tabMap.put("predefined", new Boolean("false"));
        return tabMap;
    }

    private void writeSelectedTabName(String name) {
        String key = this.channel + ".selectedTab";
        this.containerProvidercontext.setClientProperty(key, name);
    }

    private Map getTabPropsMap() throws TabException {
        try {
            return this.containerProvidercontext.getCollectionProperty(this.channel, this.props_key);
        }
        catch (ProviderContextException pce) {
            throw new TabException("TabData.getTabPropsMap(): channel " + this.channel, pce);
        }
    }
}

