/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.util.I18n;
import com.sun.portal.desktop.util.NSStringBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class DesktopRequest
implements HttpServletRequest {
    private HttpServletRequest req;
    private Hashtable parameterTable = null;
    private String queryString = null;

    public DesktopRequest(HttpServletRequest request, boolean readFromParameters) {
        this.req = request;
        this.parseParameters(request, readFromParameters);
    }

    protected void parseParameters(HttpServletRequest req, boolean readFromParameters) {
        if (readFromParameters) {
            this.parameterTable = new Hashtable();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] val = new String[]{req.getParameter(name)};
                this.parameterTable.put(name, val);
            }
        } else if (req.getMethod().equalsIgnoreCase("POST")) {
            ServletInputStream is = null;
            try {
                is = req.getInputStream();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.parameterTable = HttpUtils.parsePostData((int)req.getContentLength(), (ServletInputStream)is);
        } else if (req.getMethod().equalsIgnoreCase("GET")) {
            String query = req.getQueryString();
            if (query == null) {
                query = "";
            }
            this.parameterTable = HttpUtils.parseQueryString((String)query);
        }
        if (this.parameterTable == null) {
            this.parameterTable = new Hashtable();
        }
    }

    public void decodeParams(String charset) {
        Enumeration e = this.parameterTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object o = this.parameterTable.get(key);
            if (!(o instanceof String[])) continue;
            String[] vals = (String[])o;
            int j = 0;
            while (j < vals.length) {
                vals[j] = I18n.decodeCharset(vals[j], charset);
                ++j;
            }
        }
    }

    public Hashtable getParameterMap() {
        return this.parameterTable;
    }

    public String getAuthType() {
        return this.req.getAuthType();
    }

    public String getContextPath() {
        return this.req.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.req.getCookies();
    }

    public long getDateHeader(String name) {
        return this.req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return this.req.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return this.req.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return this.getIntHeader(name);
    }

    public String getMethod() {
        return this.req.getMethod();
    }

    public String getPathInfo() {
        return this.req.getPathInfo();
    }

    public String getPathTranslated() {
        return this.req.getPathTranslated();
    }

    public String getQueryString() {
        if (this.queryString == null) {
            NSStringBuffer b = new NSStringBuffer(32);
            Enumeration e = this.getParameterNames();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String v = this.getParameter(k);
                b.append(k).append("=").append(v);
                if (!e.hasMoreElements()) continue;
                b.append("&");
            }
            this.queryString = b.toString();
        }
        return this.queryString;
    }

    public String getRemoteUser() {
        throw new UnsupportedOperationException("Use iPS session API to get user information");
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public String getRequestURI() {
        return this.req.getRequestURI();
    }

    public String getServletPath() {
        return this.req.getServletPath();
    }

    public HttpSession getSession() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public HttpSession getSession(boolean create) {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Use iPS session API to get session information");
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("Use iPS profile API to get user information");
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.req.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.req.getCharacterEncoding();
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return this.req.getContentType();
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public Locale getLocale() {
        return this.req.getLocale();
    }

    public Enumeration getLocales() {
        return this.req.getLocales();
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameterTable.get(name);
        if (values != null && values.length >= 1) {
            return values[0];
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return this.parameterTable.keys();
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameterTable.get(name);
    }

    public String getProtocol() {
        return this.req.getProtocol();
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException("Request input is not available to providers");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("getRealPath is deprecated");
    }

    public String getRemoteAddr() {
        return this.req.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.req.getRemoteHost();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("RequestDispatcher is not available to providers");
    }

    public String getScheme() {
        return this.req.getScheme();
    }

    public String getServerName() {
        return this.req.getServerName();
    }

    public int getServerPort() {
        return this.req.getServerPort();
    }

    public boolean isSecure() {
        return this.req.isSecure();
    }

    public void removeAttribute(String name) {
        this.req.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.req.setAttribute(name, o);
    }
}

