/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.ROC;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.SessionAppContext;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class DSAMESessionAppContext
implements SessionAppContext {
    private static final String ROC_SSO_TOKEN = "ssoToken";
    protected SSOTokenManager tokenMgr = DSAMEConnection.getSSOTokenManager();

    public boolean validateSession(HttpServletRequest req) {
        boolean isValid = false;
        SSOToken token = this.getSSOToken(req);
        if (token != null && this.tokenMgr.isValidToken(token)) {
            isValid = true;
        }
        return isValid;
    }

    protected SSOToken getSSOToken(HttpServletRequest req) {
        SSOToken token = (SSOToken)ROC.getObject(ROC_SSO_TOKEN);
        if (token == null) {
            try {
                token = DSAMEConnection.getSSOTokenManager().createSSOToken(req);
                ROC.setObject(ROC_SSO_TOKEN, token);
            }
            catch (SSOException se) {
                return null;
            }
        }
        return token;
    }

    public String getUserID(HttpServletRequest req) {
        Principal p = null;
        try {
            SSOToken token = this.getSSOToken(req);
            if (token == null) {
                return null;
            }
            p = token.getPrincipal();
        }
        catch (SSOException ssoe) {
            throw new ContextError("DSAMESessionAppContext.getUserID(): ", ssoe);
        }
        return p.toString();
    }

    public String getSessionID(HttpServletRequest req) {
        SSOToken token = this.getSSOToken(req);
        String tokenID = null;
        if (token != null) {
            tokenID = token.getTokenID().toString();
        }
        return tokenID;
    }
}

