/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ClientContext;
import com.sun.portal.desktop.context.ContextError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class PropertiesClientContext
implements ClientContext {
    protected Properties properties = new Properties();
    protected static final String DEFAULTCLIENTTYPE_KEY = "defaultClientType";
    protected static final String CONTENTTYPE_KEY = "contentType";
    protected static final String CLIENTPATH_KEY = "clientPath";
    protected static final String CLIENTTYPE_KEY = "clientType";
    protected static final String CHARSET_KEY = "charset";
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWps/client-context.properties";

    public PropertiesClientContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesClientContext(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesClientContext(): ", ioe);
        }
    }

    public void init() {
    }

    public String getContentType(String clientType) {
        return this.properties.getProperty(CONTENTTYPE_KEY);
    }

    public String getClientPath(String clientType) {
        return this.properties.getProperty(CLIENTPATH_KEY);
    }

    public String getClientType() {
        return this.properties.getProperty(CLIENTTYPE_KEY);
    }

    public String getDefaultClientType() {
        return this.properties.getProperty(DEFAULTCLIENTTYPE_KEY);
    }

    public String getClientTypeProperty(String clientType, String key) {
        return this.properties.getProperty(key);
    }

    public String getCharset(String clientType, Locale locale) {
        return this.properties.getProperty(CHARSET_KEY);
    }
}

