/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPReference;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import org.w3c.dom.Document;

public class DPRootSpecifier {
    private String DTPROPFILE = "desktop.propertiesFile";
    private boolean m_IsGlobal;
    private String m_DN = null;
    private DPRoot m_DRoot = null;
    private DSAMEAdminDPContext m_ADPCtx;
    private XMLDPFactory m_Factory;

    private DPRootSpecifier(String user, String pwd) throws ParFileException {
        String sysprop = System.getProperty(this.DTPROPFILE);
        if (sysprop == null) {
            throw new ParFileException(this.DTPROPFILE + " is undefined.");
        }
        try {
            this.m_ADPCtx = new DSAMEAdminDPContext();
            this.m_ADPCtx.init(user, pwd, sysprop, "desktop.debug");
            this.m_Factory = XMLDPFactory.getInstance();
        }
        catch (Exception ex) {
            throw new ParFileException("Cannot authenticate using provided dn and password.", ex);
        }
    }

    public static DPRootSpecifier makeSpecifier(String user, String pwd) throws ParFileException {
        return new DPRootSpecifier(user, pwd);
    }

    public void setDN(String dn) {
        if (dn != null && this.m_DN != null && dn.equals(this.m_DN)) {
            return;
        }
        this.m_DN = dn;
        this.m_IsGlobal = dn.equalsIgnoreCase("global");
        this.m_DRoot = null;
    }

    public DPRoot getRoot() throws ParFileException {
        if (this.m_DRoot != null) {
            return this.m_DRoot;
        }
        if (this.m_DN == null) {
            throw new ParFileException("Directory name not set.");
        }
        try {
            String buf = this.m_IsGlobal ? this.m_ADPCtx.getGlobalDPDocument() : this.m_ADPCtx.getDPDocumentByDN(this.m_DN);
            this.m_DRoot = this.m_Factory.createRoot((DPContext)this.m_ADPCtx, buf);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception obtaining display profile document.", ex);
        }
        return this.m_DRoot;
    }

    public String getDN() {
        return this.m_DN;
    }

    public DPProvider createProvider(String name, String classname) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createProvider(this.m_ADPCtx, this.m_DRoot, doc, name, classname);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception creating provider.", ex);
        }
    }

    public DPChannel createChannel(String name, String provider) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createChannel(this.m_ADPCtx, this.m_DRoot, doc, name, provider);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception creating channel.", ex);
        }
    }

    public DPReference createReference(String name) throws ParFileException {
        try {
            Document doc = ((XMLDPRoot)this.m_DRoot).getDocument();
            return this.m_Factory.createReference(this.m_ADPCtx, this.m_DRoot, doc, name);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception creating provider.", ex);
        }
    }

    public void flush() throws ParFileException {
        try {
            this.m_DRoot.setDirty(false);
            if (this.m_IsGlobal) {
                this.m_ADPCtx.storeGlobalDPDocument(this.m_DRoot.toString());
            } else {
                this.m_ADPCtx.storeDPDocumentByDN(this.m_DN, this.m_DRoot.toString());
            }
        }
        catch (Exception ex) {
            throw new ParFileException("Exception attempting to flush display profile.", ex);
        }
    }
}

