/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.deployment;

import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Par
implements XMLDPTags {
    public static String classToFile(String pkg, String classname) {
        if (pkg != null && pkg.length() > 0) {
            return Par.classToFile(pkg + "." + classname);
        }
        return classname + ".class";
    }

    public static String classToFile(String fullclassname) {
        StringTokenizer tok = new StringTokenizer(fullclassname, ".");
        StringBuffer buf = new StringBuffer();
        String pfx = "";
        while (tok.hasMoreTokens()) {
            buf.append(pfx);
            buf.append(tok.nextToken());
            pfx = "/";
        }
        buf.append(".class");
        return buf.toString();
    }

    public static String findDPEntryName(Document doc) throws ParFileException {
        Element e = Par.getDPDocElement(doc);
        Attr a = e.getAttributeNode("name");
        if (a == null) {
            throw new ParFileException("No name attribute in document");
        }
        return a.getValue();
    }

    public static int applicableDocTypes(Document doc) throws ParFileException {
        return Par.describeDPDoc(doc, null);
    }

    public static int describeDPDoc(Document doc, PrintStream dout) throws ParFileException {
        Element e = Par.getDPDocElement(doc);
        if (dout != null) {
            dout.println("DP Document:");
        }
        int types = 0;
        NodeList kids = e.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            Node child = kids.item(i);
            if (child instanceof Element) {
                Attr a;
                String nm = child.getNodeName();
                Element chelt = (Element)child;
                if (nm.equals("Channel")) {
                    types |= 2;
                    if (dout != null) {
                        a = chelt.getAttributeNode("name");
                        if (a == null) {
                            throw new ParFileException("No name attribute in channel.");
                        }
                        dout.println("\tChannel: " + a.getValue());
                    }
                } else if (nm.equals("Provider")) {
                    types |= 1;
                    if (dout != null) {
                        a = chelt.getAttributeNode("name");
                        if (a == null) {
                            throw new ParFileException("No name attribute in provider");
                        }
                        dout.println("\tProvider: " + a.getValue());
                    }
                } else if (nm.equals("Description") && dout != null) {
                    NodeList dkids = child.getChildNodes();
                    StringBuffer buf = new StringBuffer();
                    int j = 0;
                    while (j < dkids.getLength()) {
                        Node dchild = dkids.item(j);
                        if (dchild instanceof Text) {
                            buf.append(dchild.getNodeValue());
                        }
                        ++j;
                    }
                    StringTokenizer tok = new StringTokenizer(buf.toString(), "\n\r");
                    while (tok.hasMoreTokens()) {
                        dout.println("\t" + tok.nextToken());
                    }
                }
            }
            ++i;
        }
        return types;
    }

    public static InputStream domToStream(Document doc) throws ParFileException {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            DOMSource ds = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            t.transform(ds, sr);
            return new ByteArrayInputStream(Par.indentTags(sw.getBuffer().toString()).getBytes());
        }
        catch (Exception ex) {
            throw new ParFileException("Exception converting DOM.", ex);
        }
    }

    private static String indentTags(String str) {
        int idx;
        StringBuffer out = new StringBuffer();
        int idec = str.indexOf("\n");
        if (idec <= 0) {
            return str;
        }
        out.append(str.substring(0, idec + 1));
        str = str.substring(idec + 1);
        int indent = 0;
        while ((idx = str.indexOf("<")) >= 0) {
            if (idx > 0) {
                out.append(str.substring(0, idx));
                if (str.charAt(idx - 1) != '\n') {
                    out.append("\n");
                }
                str = str.substring(idx);
            }
            if ((idx = str.indexOf(">")) <= 0) break;
            if (str.charAt(1) == '/' && indent > 0) {
                --indent;
            }
            int ic = 0;
            while (ic < indent) {
                out.append("  ");
                ++ic;
            }
            if (idx + 1 == str.length()) {
                out.append(str);
                str = "";
                break;
            }
            out.append(str.substring(0, idx + 1));
            if (str.charAt(idx + 1) != '\n') {
                out.append("\n");
            }
            if (str.charAt(1) != '/' && str.charAt(idx - 1) != '/') {
                ++indent;
            }
            str = str.substring(idx + 1);
        }
        out.append(str);
        out.append("\n");
        return out.toString();
    }

    public static Document streamToDom(InputStream str) throws ParFileException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(str);
        }
        catch (Exception ex) {
            throw new ParFileException("Exception reading XML document.");
        }
    }

    public static Document makeParEntry(String name, String desc, Element provider, Element channel) throws ParFileException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (Exception ex) {
            throw new ParFileException("Exception constructing ParEntry Document.", ex);
        }
        Element root = doc.createElement("ParEntry");
        root.setAttribute("name", name);
        doc.appendChild(root);
        if (desc != null) {
            Element delt = doc.createElement("Description");
            delt.appendChild(doc.createTextNode(desc));
            root.appendChild(delt);
        }
        if (provider != null) {
            root.appendChild(Par.cloneElement(doc, provider));
        }
        if (channel != null) {
            root.appendChild(Par.cloneElement(doc, channel));
        }
        return doc;
    }

    public static String getProviderNameFromChannel(Document doc) throws ParFileException {
        Element chan = Par.findElement(doc, "Channel", false);
        if (chan == null) {
            return null;
        }
        Attr a = chan.getAttributeNode("provider");
        if (a == null) {
            throw new ParFileException("channel tag has no provider.");
        }
        return a.getValue();
    }

    public static String getProviderName(Document doc) throws ParFileException {
        Element p = Par.findElement(doc, "Provider", true);
        Attr a = p.getAttributeNode("name");
        if (a == null) {
            throw new ParFileException("provider tag has no name.");
        }
        return a.getValue();
    }

    public static String getChannelName(Document doc) throws ParFileException {
        Element chan = Par.findElement(doc, "Channel", true);
        Attr a = chan.getAttributeNode("name");
        if (a == null) {
            throw new ParFileException("channel tag has no name.");
        }
        return a.getValue();
    }

    public static String getProviderClass(Document doc) throws ParFileException {
        Element p = Par.findElement(doc, "Provider", true);
        Attr a = p.getAttributeNode("class");
        if (a == null) {
            throw new ParFileException("provider tag has no class.");
        }
        return a.getValue();
    }

    public static Element getProviderProperties(Document doc) throws ParFileException {
        return Par.findProperties(Par.findElement(doc, "Provider", true));
    }

    public static Element getChannelProperties(Document doc) throws ParFileException {
        return Par.findProperties(Par.findElement(doc, "Channel", true));
    }

    public static void replaceProps(Element elt, Element props) throws ParFileException {
        NodeList kids = elt.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            Node child = kids.item(i);
            if (child instanceof Element && child.getNodeName().equals("Properties")) {
                elt.removeChild(child);
                break;
            }
            ++i;
        }
        elt.appendChild(Par.cloneElement(elt.getOwnerDocument(), props));
    }

    private static Element findElement(Document doc, String tag, boolean required) throws ParFileException {
        Element elt = Par.getDPDocElement(doc);
        NodeList kids = elt.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            Node child = kids.item(i);
            if (child instanceof Element && child.getNodeName().equals(tag)) {
                return (Element)child;
            }
            ++i;
        }
        if (required) {
            throw new ParFileException(tag + " element not present in document.");
        }
        return null;
    }

    private static Element cloneElement(Document doc, Element elt) throws ParFileException {
        Element copy = doc.createElement(elt.getNodeName());
        NamedNodeMap attrs = elt.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.getLength()) {
                Node n = attrs.item(i);
                if (n instanceof Attr) {
                    copy.setAttribute(n.getNodeName(), n.getNodeValue());
                }
                ++i;
            }
        }
        NodeList kids = elt.getChildNodes();
        int j = 0;
        while (j < kids.getLength()) {
            Node n = kids.item(j);
            if (n instanceof Element) {
                copy.appendChild(Par.cloneElement(doc, (Element)n));
            }
            ++j;
        }
        return copy;
    }

    private static Element findProperties(Element elt) throws ParFileException {
        NodeList kids = elt.getChildNodes();
        int i = 0;
        while (i < kids.getLength()) {
            Node child = kids.item(i);
            if (child instanceof Element && child.getNodeName().equals("Properties")) {
                return (Element)child;
            }
            ++i;
        }
        throw new ParFileException("No properties element.");
    }

    private static Element getDPDocElement(Document doc) throws ParFileException {
        Element e = doc.getDocumentElement();
        if (e == null) {
            throw new ParFileException("No root node in document");
        }
        if (!e.getNodeName().equals("ParEntry")) {
            throw new ParFileException("Root node in document is not ParEntry");
        }
        return e;
    }
}

