/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.cli;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.cli.DPAException;
import com.sun.portal.desktop.dp.cli.DPAUtil;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import java.io.InputStream;
import java.io.StringReader;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

class DPAAdd {
    XMLDPFactory dpf = XMLDPFactory.getInstance();
    boolean verbose = false;

    DPAAdd() {
    }

    public void process(DSAMEAdminDPContext dadc, String dn, boolean global, String parent, InputStream xmlByteStream, boolean verbose, boolean dryrun) throws DPAException {
        Object[] tokens;
        this.verbose = verbose;
        if (verbose) {
            DPAUtil.debug("dbgParsingXML");
        }
        Element element = DPAUtil.getElement(dadc, xmlByteStream);
        String tag = element.getTagName();
        DPRoot dpr = null;
        if (verbose) {
            tokens = new Object[]{tag};
            DPAUtil.debug("dbgTagDetected", tokens);
        }
        if (tag.equals("DisplayProfile")) {
            if (parent != null) {
                tokens = new Object[]{parent};
                throw new DPAException("errorCannotHaveParent", tokens);
            }
            dpr = this.doAddDP(dadc, dn, global, element);
        } else {
            String doc = null;
            try {
                doc = !global ? dadc.getDPDocumentByDN(dn) : dadc.getGlobalDPDocument();
            }
            catch (Throwable ex) {
                Object[] tokens2 = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
                throw new DPAException("errorRetrieveDP", ex, tokens2);
            }
            try {
                dpr = this.dpf.createRoot((DPContext)dadc, doc);
            }
            catch (Throwable ex) {
                Object[] tokens3 = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
                throw new DPAException("errorCreateDPRoot", ex, tokens3);
            }
            if (tag.equals("Channel") || tag.equals("Container")) {
                dpr = this.doAddChannel(dadc, dpr, parent, element);
            } else if (tag.equals("Provider")) {
                if (parent != null) {
                    Object[] tokens4 = new Object[]{parent};
                    throw new DPAException("errorProviderCannotHaveParent", tokens4);
                }
                dpr = this.doAddProvider(dadc, dpr, element);
            } else if (tag.equals("String") || tag.equals("Boolean") || tag.equals("Integer") || tag.equals("Collection") || tag.equals("Locale")) {
                dpr = this.doAddProperty(dadc, dpr, parent, element);
            } else {
                if (tag.equals("Properties") || tag.equals("Available") || tag.equals("Selected")) {
                    Object[] tokens5 = new Object[]{tag};
                    throw new DPAException("errorCannotAdd", tokens5);
                }
                Object[] tokens6 = new Object[]{tag};
                throw new DPAException("errorUnsupportedTag", tokens6);
            }
        }
        if (verbose) {
            DPAUtil.debug("dbgValidatingDP");
        }
        String dpDoc = null;
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
            dpDoc = dpr.toString();
            this.dpf.createRoot((DPContext)dadc, dpDoc);
        }
        catch (DesktopError de) {
            Throwable wrapped = de.getWrapped();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens7 = new Object[]{DPAUtil.getLines(new StringReader(dpDoc), linenum)};
                throw new DPAException("errorInvalidXMLText", de, tokens7);
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        if (!dryrun) {
            if (verbose) {
                DPAUtil.debug("dbgWritingDP");
            }
            try {
                if (!global) {
                    dadc.storeDPDocumentByDN(dn, dpr.toString());
                } else {
                    dadc.storeGlobalDPDocument(dpr.toString());
                }
            }
            catch (Throwable ex) {
                throw new DPAException("errorStoreDP", ex);
            }
        }
    }

    private DPRoot doAddDP(DSAMEAdminDPContext dadc, String dn, boolean global, Element element) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            DPAUtil.debug("dbgAddingDP", tokens);
        }
        String doc = null;
        try {
            doc = !global ? dadc.getDPDocumentByDN(dn) : dadc.getGlobalDPDocument();
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorRetrieveDP", ex, tokens);
        }
        if (doc != null && doc.length() > 0) {
            Object[] tokens = new Object[]{global ? DPAUtil.getLocalizedString("msgGlobal") : dn};
            throw new DPAException("errorDupDP", tokens);
        }
        DPRoot dpr = null;
        try {
            dpr = this.dpf.getRoot(dadc, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorInvalidXML", ex);
        }
        return dpr;
    }

    private DPRoot doAddChannel(DSAMEAdminDPContext dadc, DPRoot dpr, String parent, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            DPAUtil.debug("dbgAddingChannel", tokens2);
        }
        DPNode node = null;
        try {
            if (parent == null) {
                node = dpr;
            } else {
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    DPAUtil.debug("dbgLookupParentNode", tokens);
                }
                XMLDPRoot xdpr = (XMLDPRoot)dpr;
                node = xdpr.getChannelFromThis(parent);
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (node == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (!(node instanceof DPContainerChannel) && !(node instanceof DPRoot)) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorParentNotCotainer", tokens);
        }
        if (this.verbose) {
            DPAUtil.debug("dbgCreatingDPChannel");
        }
        DPChannel ch = null;
        try {
            ch = this.dpf.getChannel(dadc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPChannel", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{ch.getName()};
            DPAUtil.debug("dbgCheckDupName", tokens4);
        }
        boolean dupFound = false;
        try {
            XMLDPNode xnode = (XMLDPNode)node;
            dupFound = xnode.getChannelFromThis(ch.getName()) != null;
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(ch.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorCheckDupName", ex);
        }
        if (dupFound) {
            throw new DPAException("errorDupName");
        }
        try {
            node.addChannel(ch);
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, ch.getName()};
            throw new DPAException("errorAddChannel", ex, tokens5);
        }
        return dpr;
    }

    private DPRoot doAddProvider(DSAMEAdminDPContext dadc, DPRoot dpr, Element element) throws DPAException {
        if (this.verbose) {
            Object[] tokens = new Object[]{element.getAttribute("name")};
            DPAUtil.debug("dbgAddingProvider", tokens);
        }
        if (this.verbose) {
            DPAUtil.debug("dbgCreatingDPProvider");
        }
        DPProvider p = null;
        try {
            p = this.dpf.getProvider(dadc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProvider", ex);
        }
        if (this.verbose) {
            Object[] tokens = new Object[]{p.getName()};
            DPAUtil.debug("dbgCheckDupName", tokens);
        }
        boolean dupFound = false;
        try {
            XMLDPRoot xdpr = (XMLDPRoot)dpr;
            boolean bl = dupFound = xdpr.getChannelFromThis(p.getName()) != null;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(p.getName()) != null;
            }
        }
        catch (Throwable ex) {
            throw new DPAException("errorCheckDupName", ex);
        }
        if (dupFound) {
            throw new DPAException("errorDupName");
        }
        try {
            dpr.addProvider(p);
        }
        catch (Throwable ex) {
            Object[] tokens = new Object[]{p.getName()};
            throw new DPAException("errorAddProvider", ex, tokens);
        }
        return dpr;
    }

    private DPRoot doAddProperty(DSAMEAdminDPContext dadc, DPRoot dpr, String parent, Element element) throws DPAException {
        Object[] tokens;
        if (this.verbose) {
            Object[] tokens2 = new Object[]{element.getAttribute("name"), parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            DPAUtil.debug("dbgAddingProperty", tokens2);
        }
        DPPropertyHolder ph = null;
        try {
            if (parent == null) {
                ph = dpr;
            } else {
                XMLDPRoot xdpr;
                if (this.verbose) {
                    tokens = new Object[]{parent};
                    DPAUtil.debug("dbgLookupParent", tokens);
                }
                if ((ph = (xdpr = (XMLDPRoot)dpr).getChannelFromThis(parent)) == null) {
                    ph = xdpr.getProviderFromThis(parent);
                }
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", ex, tokens3);
        }
        if (ph == null) {
            tokens = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            throw new DPAException("errorFindParent", tokens);
        }
        if (this.verbose) {
            DPAUtil.debug("dbgCreatingDPProperty");
        }
        DPProperty p = null;
        try {
            p = this.dpf.getProperty(dadc, dpr, element);
        }
        catch (Throwable ex) {
            throw new DPAException("errorCreateDPProperty", ex);
        }
        if (this.verbose) {
            Object[] tokens4 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent};
            DPAUtil.debug("dbgCheckExistingProperty", tokens4);
        }
        DPProperties props = null;
        boolean exists = false;
        try {
            XMLDPPropertyHolder xph = (XMLDPPropertyHolder)ph;
            props = xph.getPropertiesFromThis();
            XMLDPProperties xprops = (XMLDPProperties)props;
            exists = xprops.getFromThis(p.getName()) != null;
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, p.getName()};
            throw new DPAException("errorLookupProperty", ex, tokens5);
        }
        if (exists) {
            Object[] tokens6 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, p.getName()};
            throw new DPAException("errorDupProperty", tokens6);
        }
        try {
            props.add(p);
        }
        catch (Throwable ex) {
            Object[] tokens7 = new Object[]{parent == null ? DPAUtil.getLocalizedString("msgRoot") : parent, p.getName()};
            throw new DPAException("errorAddProperty", ex, tokens7);
        }
        return dpr;
    }
}

