/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPNode;
import com.sun.portal.desktop.dp.xml.XMLDPObject;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPChannel
extends XMLDPNode
implements DPChannel,
DPTypes,
XMLDPTags {
    static long ccount = 0L;

    XMLDPChannel(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
        if (this.isPerfMessageEnabled()) {
            this.perfMessage("XMLDPChannel.XMLDPChannel(): ccount=" + ++ccount);
        }
    }

    XMLDPChannel(DPContext dpc, DPRoot r, Document d, String name, String providerName) {
        this(dpc, r, XMLDPChannel.createElement(dpc, d, name, providerName, XMLDPProperties.createElement(dpc, d)));
    }

    public void checkType() {
        if (!this.getElement().getTagName().equals(this.getTag()) && !this.getElement().getTagName().equals("Container")) {
            throw new DPError("XMLDPChannel.checkType(): invalid type tagName=" + this.getElement().getTagName());
        }
    }

    public String getTag() {
        return "Channel";
    }

    public short getType() {
        return 6;
    }

    public String getName() {
        StringBuffer name = new StringBuffer(super.getName());
        DPNode parentNode = this.getParentNode();
        if (parentNode != null && parentNode.getType() != 13) {
            name.insert(0, '/');
            name.insert(0, parentNode.getName());
        }
        return name.toString();
    }

    public String getProviderName() {
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPChannel dpc = (DPChannel)i.next();
            if (!dpc.isLocked()) continue;
            if (dpc.isRemove()) {
                return null;
            }
            return dpc.getProviderName();
        }
        return this.getProviderNameFromThis();
    }

    protected String getProviderNameFromThis() {
        return this.getElement().getAttribute("provider");
    }

    public void setProviderName(String providerName) {
        this.getElement().setAttribute("provider", providerName);
        this.setDirty(true);
    }

    public DPProvider getProvider() {
        String name = this.getProviderName();
        return this.getProvider(name);
    }

    public DPProvider getProvider(String name) {
        DPRoot root = this.getRoot();
        return root.getProvider(name);
    }

    public DPChannel getChannel(String name) {
        if (this.getType() != 5) {
            return null;
        }
        return super.getChannel(name);
    }

    public DPChannel copy(DPRoot dpr, boolean deep) {
        XMLDPRoot xmldpr = (XMLDPRoot)dpr;
        Document ownerDocument = xmldpr.getElement().getOwnerDocument();
        Element copyElement = (Element)ownerDocument.importNode(this.getElement(), deep);
        if (!deep) {
            copyElement.appendChild(ownerDocument.importNode(XMLDPObject.getChildElement(this.getElement(), "Properties", null), false));
        }
        return XMLDPFactory.getInstance().getChannel(this.getContext(), dpr, copyElement);
    }

    DPChannel createDummy(DPRoot dpr) {
        DPChannel dpc = this.copy(dpr, false);
        dpc.setDummy(true);
        dpc.setMergeDefaults();
        return dpc;
    }

    static Element createElement(DPContext dpc, Document d, String name, String providerName, Element propertiesElement) {
        Element e = XMLDPObject.createElement(dpc, d, "Channel", name);
        e.setAttribute("provider", providerName);
        e.appendChild(propertiesElement);
        XMLDPPropertyHolder.setMergeDefaultsElement(e);
        return e;
    }
}

