/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPObject;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPAttrs;
import com.sun.portal.desktop.dp.xml.XMLDPEntityResolver;
import com.sun.portal.desktop.dp.xml.XMLDPErrorHandler;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import com.sun.portal.desktop.util.Encoder;
import com.sun.portal.desktop.util.OrderedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLDPObject
implements DPObject,
DPTypes,
XMLDPTags,
XMLDPAttrs,
Comparable {
    static final int INDENT_SPACES = 4;
    static Map mergeTypeTable = null;
    private DPContext dpContext = null;
    private DPRoot dpRoot = null;
    private Element element = null;
    private DocumentBuilder docBuilder = null;
    private List mergers = null;
    private List unmodifiableMergers = Collections.EMPTY_LIST;
    private boolean mergeLocked = false;
    private boolean mergeRemoved = false;
    private boolean mergeAdvanced = false;
    static long ccount;
    private static Map localeNames;
    private static XMLDPEntityResolver entityResolver;
    private static XMLDPErrorHandler errorHandler;
    private Boolean locked = null;
    private Boolean removed = null;
    private Boolean replaced = null;
    private Boolean dummy = null;
    private Short mergeType = null;
    private Boolean advanced = null;
    private String name = null;
    private boolean mergersSorted = false;

    private XMLDPObject() {
    }

    static Map createElementTable(Element e) {
        OrderedMap elementTable = new OrderedMap();
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                Element childElement = (Element)childNode;
                String name = XMLDPObject.getNameElement(childElement);
                elementTable.put(name, childElement);
            }
            ++i;
        }
        return elementTable;
    }

    XMLDPObject(DPContext dpc, DPRoot r, Element e) {
        this.dpContext = dpc;
        this.dpRoot = r;
        this.element = e;
        this.checkType();
        if (this.isPerfMessageEnabled()) {
            this.perfMessage("XMLDPObject.XMLDPObject(): ccount=" + ++ccount);
        }
    }

    public DocumentBuilder getDocBuilder() {
        if (this.docBuilder == null) {
            XMLDPObject xMLDPObject = this;
            synchronized (xMLDPObject) {
                if (this.docBuilder == null) {
                    this.docBuilder = XMLDPObject.getDocBuilder(this.getContext());
                }
            }
        }
        return this.docBuilder;
    }

    public DPObject getObject(Element e) {
        return ((XMLDPRoot)this.getRoot()).getObject(e);
    }

    public void putObject(DPObject dpo) {
        ((XMLDPRoot)this.getRoot()).putObject(dpo);
    }

    public void removeObject(DPObject dpo) {
        ((XMLDPRoot)this.getRoot()).removeObject(dpo);
    }

    public void removeObject(Element e) {
        ((XMLDPRoot)this.getRoot()).removeObject(e);
    }

    public DPRoot getRoot() {
        return this.dpRoot;
    }

    Element getRootElement() {
        return XMLDPObject.getRootElement(this.getElement());
    }

    static Element getRootElement(Element e) {
        Element rootElement = e.getOwnerDocument().getDocumentElement();
        return rootElement;
    }

    private boolean hasAttrWithValue(Element e, String key, String val) {
        if (!XMLDPObject.isDummyElement(e) && e.hasAttribute(key) && e.getAttribute(key).equals(val)) {
            return true;
        }
        Node parentNode = e.getParentNode();
        if (parentNode == null || parentNode.getNodeType() == 9) {
            return false;
        }
        if (parentNode.getNodeType() != 1) {
            throw new DPError("XMLDPProperty.hasAttrWithValue(): parent node was not an element");
        }
        Element parentElement = (Element)parentNode;
        return this.hasAttrWithValue(parentElement, key, val);
    }

    public boolean isRemove() {
        if (this.removed == null) {
            this.removed = this.isDummy() ? (this.isMergeRemove() ? Boolean.TRUE : Boolean.FALSE) : (this.hasAttrWithValue(this.getElement(), "merge", "remove") ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.removed;
    }

    public boolean isReplace() {
        if (this.replaced == null) {
            this.replaced = this.hasAttrWithValue(this.getElement(), "merge", "replace") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.replaced;
    }

    public boolean isMergeReplace() {
        DPObject dpo = this.getLastMerger();
        if (dpo == null) {
            return false;
        }
        return dpo.getMergeType() == 2;
    }

    public boolean isMergeRemove() {
        return this.mergeRemoved;
    }

    public boolean isMergeLocked() {
        return this.mergeLocked;
    }

    public boolean isMergeAdvanced() {
        return this.mergeAdvanced;
    }

    public DPObject getLastMerger() {
        if (this.mergers == null) {
            return null;
        }
        int size = this.mergers.size();
        if (size == 0) {
            return null;
        }
        return (DPObject)this.mergers.get(size - 1);
    }

    public List getMergers() {
        return this.unmodifiableMergers;
    }

    private List getModifiableMergers() {
        if (this.mergers == null) {
            this.mergers = new ArrayList();
            this.unmodifiableMergers = Collections.unmodifiableList(this.mergers);
        }
        return this.mergers;
    }

    public void sortMergers() {
        if (this.mergers != null && !this.mergersSorted) {
            Collections.sort(this.mergers);
            this.mergersSorted = true;
        }
    }

    public void addMerger(DPObject dpo) {
        if (this.getType() != dpo.getType()) {
            throw new DPError("XMLDPObject.addMerger(): merger type mismatch");
        }
        List m = this.getModifiableMergers();
        if (m.contains(dpo)) {
            throw new DPError("XMLDPObject.addMerger(): merger already added");
        }
        short mergeType = dpo.getMergeType();
        m.add(dpo);
        this.mergersSorted = false;
        this.mergeRemoved = dpo.isRemove();
        if (dpo.isLocked()) {
            this.mergeLocked = true;
        }
        if (dpo.isAdvanced()) {
            this.mergeAdvanced = true;
        }
    }

    public static boolean isLockedElement(Element e) {
        String l = e.getAttribute("lock");
        if (l == null || l.length() == 0) {
            throw new DPError("XMLDPObject.isLocked(): no lock attribute found");
        }
        boolean lock = XMLDPObject.toBoolean(l);
        return lock;
    }

    public boolean isLocked() {
        if (this.locked == null) {
            this.locked = this.isDummy() ? (this.isMergeLocked() ? Boolean.TRUE : Boolean.FALSE) : (this.hasAttrWithValue(this.getElement(), "lock", "true") ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.locked;
    }

    public void setLock(boolean lock) {
        if (lock) {
            this.getElement().setAttribute("lock", "true");
            this.locked = Boolean.TRUE;
        } else {
            this.getElement().setAttribute("lock", "false");
            this.locked = Boolean.FALSE;
        }
    }

    public int getPriority() {
        return this.getRoot().getPriority();
    }

    public void setPriority(int priority) {
        this.getRoot().setPriority(priority);
    }

    public String getVersion() {
        return this.getRoot().getVersion();
    }

    public void setVersion(String version) {
        this.getRoot().setVersion(version);
    }

    public void setMergeType(short type) {
        this.removed = null;
        this.replaced = null;
        this.advanced = null;
        this.mergeType = new Short(type);
        XMLDPObject.setMergeTypeElement(this.getElement(), type);
        this.setDummy(false);
    }

    static void setMergeTypeElement(Element e, int type) {
        switch (type) {
            case 1: {
                e.setAttribute("merge", "fuse");
                break;
            }
            case 2: {
                e.setAttribute("merge", "replace");
                break;
            }
            case 3: {
                e.setAttribute("merge", "remove");
                break;
            }
            default: {
                throw new DPError("XMLDPObject.setMergeType(): unknown type=" + type);
            }
        }
    }

    public short getMergeType() {
        if (this.mergeType == null) {
            this.mergeType = new Short(XMLDPObject.getMergeTypeElement(this.getElement()));
        }
        return this.mergeType;
    }

    private static short getMergeTypeElement(Element e) {
        String t = e.getAttribute("merge");
        if (t == null || t.length() == 0) {
            throw new DPError("XMLDPObject.getMergeType(): no merge type found for element=" + e.toString() + ", parent=" + e.getParentNode().toString());
        }
        Short type = (Short)mergeTypeTable.get(t);
        if (type == null) {
            throw new DPError("XMLDPObject.getMergeType(): unknown merge type=" + t + " for element=" + e.toString());
        }
        return type;
    }

    public boolean isAdvanced() {
        if (this.advanced == null) {
            this.advanced = this.isDummy() ? (this.isMergeAdvanced() ? Boolean.TRUE : Boolean.FALSE) : (this.hasAttrWithValue(this.getElement(), "advanced", "true") ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.advanced;
    }

    public void setAdvanced(boolean adv) {
        if (adv) {
            this.getElement().setAttribute("advanced", "true");
            this.advanced = Boolean.TRUE;
        } else {
            this.getElement().setAttribute("advanced", "false");
            this.advanced = Boolean.FALSE;
        }
    }

    public static boolean isAdvancedElement(Element e) {
        String a = e.getAttribute("advanced");
        if (a == null || a.length() == 0) {
            throw new DPError("XMLDPObject.isAdvancedElement(): no advanced attribute found");
        }
        return XMLDPObject.toBoolean(a);
    }

    public DPContext getContext() {
        return this.dpContext;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getParentElement() {
        Node pn = this.getElement().getParentNode();
        Element pe = (Element)pn;
        return pe;
    }

    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    public void setElement(Element e) {
        Node parentNode = this.element.getParentNode();
        parentNode.removeChild(this.element);
        parentNode.appendChild(e);
        this.element = e;
        this.checkType();
    }

    public abstract short getType();

    public abstract String getTag();

    public void setDummy(boolean state) {
        if (!state) {
            this.getRoot().setDirty(true);
            XMLDPObject.setDummyElement(this.getElement(), false);
            this.locked = null;
            this.dummy = Boolean.FALSE;
        } else if (state) {
            XMLDPObject.setDummyElement(this.getElement(), true);
            this.dummy = Boolean.TRUE;
        }
    }

    private static void setDummyElement(Element e, boolean state) {
        if (state) {
            e.setAttribute("dummy", "true");
        } else {
            Node n;
            if (e.hasAttribute("dummy")) {
                e.removeAttribute("dummy");
            }
            if ((n = e.getParentNode()) == null) {
                return;
            }
            if (n.getNodeType() != 1) {
                return;
            }
            Element parentElement = (Element)n;
            XMLDPObject.setDummyElement(parentElement, false);
        }
    }

    public void setDirty(boolean state) {
        this.getRoot().setDirty(state);
    }

    public boolean isDirty() {
        return this.getRoot().isDirty();
    }

    public boolean isMerged() {
        return this.mergers != null && this.mergers.size() > 0;
    }

    private static boolean isDummyElement(Element e) {
        String dummy = e.getAttribute("dummy");
        return dummy != null && dummy.length() != 0 && dummy.equals("true");
    }

    public boolean isDummy() {
        if (this.dummy == null) {
            this.dummy = XMLDPObject.isDummyElement(this.getElement()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.dummy;
    }

    static boolean isAtomicElement(Element e) {
        return e.getTagName().equals("String") || e.getTagName().equals("Boolean") || e.getTagName().equals("Integer") || e.getTagName().equals("Reference");
    }

    static void setName(Element e, String name) {
        e.setAttribute("name", name);
    }

    static String getCachedLocaleName(String l, String c, String v) {
        if (localeNames == null) {
            return null;
        }
        Map countries = (Map)localeNames.get(l);
        if (countries == null) {
            return null;
        }
        Map variants = (Map)countries.get(c);
        if (variants == null) {
            return null;
        }
        String name = (String)variants.get(v);
        return name;
    }

    static void putCachedLocaleName(String l, String c, String v, String name) {
        HashMap<String, String> variants;
        HashMap<String, HashMap<String, String>> countries;
        if (localeNames == null) {
            localeNames = new HashMap();
        }
        if ((countries = (HashMap<String, HashMap<String, String>>)localeNames.get(l)) == null) {
            countries = new HashMap<String, HashMap<String, String>>();
            localeNames.put(l, countries);
        }
        if ((variants = (HashMap<String, String>)countries.get(c)) == null) {
            variants = new HashMap<String, String>();
            countries.put(c, variants);
        }
        variants.put(v, name);
    }

    static String getLocaleName(String l, String c, String v) {
        String name = XMLDPObject.getCachedLocaleName(l, c, v);
        if (name == null) {
            StringBuffer b = new StringBuffer();
            b.append("_locale");
            if (l != null && l.length() > 0) {
                b.append("_");
                b.append(l);
            }
            if (c != null && c.length() > 0) {
                b.append("_");
                b.append(c);
            }
            if (v != null && v.length() > 0) {
                b.append("_");
                b.append(v);
            }
            name = b.toString();
            XMLDPObject.putCachedLocaleName(l, c, v, name);
        }
        return name;
    }

    private static String getNameElement(Element e) {
        String name = e.getAttribute("name");
        if (name == null || name.length() == 0) {
            if (e.getTagName().equals("Locale")) {
                StringBuffer b = new StringBuffer();
                String l = e.getAttribute("language");
                String c = e.getAttribute("country");
                String v = e.getAttribute("variant");
                name = XMLDPObject.getLocaleName(l, c, v);
            } else if (XMLDPObject.isAtomicElement(e)) {
                Text textNode = null;
                textNode = XMLDPObject.getTextNode(e);
                if (textNode == null) {
                    String value = e.getAttribute("value");
                    if (value != null && value.length() != 0) {
                        name = value;
                    }
                } else {
                    String text = textNode.getData();
                    if (text != null && text.length() != 0) {
                        name = text;
                    }
                }
            }
        }
        return name;
    }

    protected static Text getTextNode(Element e) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3) {
                return (Text)childNode;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        if (this.name == null) {
            this.name = XMLDPObject.getNameElement(this.getElement());
        }
        return this.name;
    }

    public void checkType() {
        this.checkType(this.getElement().getTagName());
    }

    void checkType(String actual) {
        if (actual.equals(this.getTag())) {
            return;
        }
        throw new DPError("XMLDPObject.checkType(): wrong type tagName=" + this.getElement().getTagName());
    }

    public String toDebugString() {
        StringBuffer b = new StringBuffer(256);
        b.append("\n\n\n\nthis=\n");
        b.append(this.toString(false));
        int i = 0;
        while (i < this.getMergers().size()) {
            DPObject dpo = (DPObject)this.getMergers().get(i);
            b.append("\n\n\n\nmerger(");
            b.append(i);
            b.append(")=");
            b.append(dpo.toString(false));
            b.append("\n\n\n\n");
            ++i;
        }
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer(256);
        XMLDPObject.toStringBuffer(this.getElement(), b, true, 0);
        return b.toString();
    }

    public String toString(boolean prune) {
        StringBuffer b = new StringBuffer(256);
        XMLDPObject.toStringBuffer(this.getElement(), b, prune, 0);
        return b.toString();
    }

    private static XMLDPEntityResolver getEntityResolver() {
        if (entityResolver == null) {
            entityResolver = new XMLDPEntityResolver();
        }
        return entityResolver;
    }

    private static XMLDPErrorHandler getErrorHandler(DPContext dpc) {
        if (errorHandler == null) {
            errorHandler = new XMLDPErrorHandler(dpc);
        }
        return errorHandler;
    }

    static DocumentBuilder getDocBuilder(DPContext dpc) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        dbf.setValidating(dpc.isValidating());
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new DPError("XMLDPObject.getDocBuilder(): ", pce);
        }
        db.setErrorHandler(XMLDPObject.getErrorHandler(dpc));
        db.setEntityResolver(XMLDPObject.getEntityResolver());
        return db;
    }

    Element createElement(String xml) {
        Document d = null;
        try {
            byte[] bytes = xml.getBytes("UTF-8");
            ByteArrayInputStream byteIS = new ByteArrayInputStream(bytes);
            InputSource is = new InputSource(byteIS);
            d = this.getDocBuilder().parse(is);
        }
        catch (SAXParseException spe) {
            throw new DPError("XMLDPRoot.createElement(): line=" + spe.getLineNumber() + ".  ", spe);
        }
        catch (SAXException se) {
            throw new DPError("XMLDPRoot.createElement(): ", se);
        }
        catch (IOException ioe) {
            throw new DPError("XMLDPRoot.createElement(): ", ioe);
        }
        Element docElement = d.getDocumentElement();
        Element importedElement = (Element)this.getDocument().importNode(docElement, true);
        return importedElement;
    }

    static short getType(Element e) {
        if (e.getTagName().equals("String")) {
            return 1;
        }
        if (e.getTagName().equals("Reference")) {
            return 8;
        }
        if (e.getTagName().equals("Collection")) {
            return 14;
        }
        if (e.getTagName().equals("Integer")) {
            return 3;
        }
        if (e.getTagName().equals("Boolean")) {
            return 4;
        }
        if (e.getTagName().equals("Channel")) {
            return 6;
        }
        if (e.getTagName().equals("Container")) {
            return 5;
        }
        if (e.getTagName().equals("Properties")) {
            return 5;
        }
        if (e.getTagName().equals("Provider")) {
            return 12;
        }
        return -1;
    }

    static List getChildElements(Element e, String tagName) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        ArrayList<Element> childElements = new ArrayList<Element>();
        int i = 0;
        while (i < numChildren) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                String childTagName;
                Element childElement = (Element)childNode;
                if (tagName == null || (childTagName = childElement.getTagName()).equals(tagName)) {
                    childElements.add(childElement);
                }
            }
            ++i;
        }
        return childElements;
    }

    static Element getChildElement(Element e, String tagName) {
        return XMLDPObject.getChildElement(e, tagName, null);
    }

    static Element getChildElement(Element e, String tagName, String name) {
        NodeList childNodes = e.getChildNodes();
        int numChildren = childNodes.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                String childName;
                String childTagName;
                Element childElement = (Element)childNode;
                if ((tagName == null || (childTagName = childElement.getTagName()).equals(tagName)) && (name == null || (childName = XMLDPObject.getNameElement(childElement)).equals(name))) {
                    return childElement;
                }
            }
            ++i;
        }
        return null;
    }

    static void appendBuffer(String a, StringBuffer b, int indent) {
        if (b.length() != 0 && b.charAt(b.length() - 1) == '\n') {
            int i = 0;
            while (i < indent * 4) {
                b.append(" ");
                ++i;
            }
        }
        b.append(a);
    }

    static void toStringBuffer(Node n, StringBuffer b, boolean prune, int indent) {
        switch (n.getNodeType()) {
            case 1: {
                Node s;
                Element e = (Element)n;
                if (prune && e.hasAttribute("dummy")) {
                    return;
                }
                XMLDPObject.appendBuffer("<", b, indent);
                XMLDPObject.appendBuffer(e.getTagName(), b, indent);
                NamedNodeMap attrs = e.getAttributes();
                if (attrs != null) {
                    int numAttrs = attrs.getLength();
                    int i = 0;
                    while (i < numAttrs) {
                        Node na = attrs.item(i);
                        if (na.getNodeType() == 2) {
                            Attr a = (Attr)na;
                            XMLDPObject.appendBuffer(" ", b, indent);
                            XMLDPObject.appendBuffer(a.getName(), b, indent);
                            XMLDPObject.appendBuffer("=\"", b, indent);
                            XMLDPObject.appendBuffer(Encoder.encodeXml(a.getValue()), b, indent);
                            XMLDPObject.appendBuffer("\"", b, indent);
                        }
                        ++i;
                    }
                }
                boolean appendNewline = (s = e.getNextSibling()) == null || s.getNodeType() != 3;
                NodeList nodes = e.getChildNodes();
                if (nodes.getLength() == 0) {
                    if (appendNewline) {
                        XMLDPObject.appendBuffer("/>\n", b, indent);
                        break;
                    }
                    XMLDPObject.appendBuffer("/>", b, indent);
                    break;
                }
                if (nodes.item(0).getNodeType() == 3) {
                    XMLDPObject.appendBuffer(">", b, indent);
                } else {
                    XMLDPObject.appendBuffer(">\n", b, indent);
                }
                int j = 0;
                while (j < nodes.getLength()) {
                    XMLDPObject.toStringBuffer(nodes.item(j), b, prune, indent + 1);
                    ++j;
                }
                XMLDPObject.appendBuffer("</", b, indent);
                XMLDPObject.appendBuffer(e.getTagName(), b, indent);
                if (appendNewline) {
                    XMLDPObject.appendBuffer(">\n", b, indent);
                    break;
                }
                XMLDPObject.appendBuffer(">", b, indent);
                break;
            }
            case 8: {
                Comment c = (Comment)n;
                XMLDPObject.appendBuffer("<!--", b, indent);
                XMLDPObject.appendBuffer(c.getData(), b, indent);
                XMLDPObject.appendBuffer("-->\n", b, indent);
                break;
            }
            case 3: {
                Text t = (Text)n;
                String text = t.getData();
                if (text.length() <= 0) break;
                XMLDPObject.appendBuffer(Encoder.encodeXml(text), b, 0);
                break;
            }
            default: {
                throw new DPError("XMLDPObject.toStringBuffer(): unknown node type encountered");
            }
        }
    }

    static Element createElement(DPContext dpc, Document d, String tagName) {
        Element e = d.createElement(tagName);
        return e;
    }

    static Element createElement(DPContext dpc, Document d, String tagName, String name) {
        Element e = XMLDPObject.createElement(dpc, d, tagName);
        if (name != null) {
            XMLDPObject.setName(e, name);
        }
        return e;
    }

    public int compareTo(Object o) {
        DPObject dpo = (DPObject)o;
        if (this.getPriority() < dpo.getPriority()) {
            return -1;
        }
        if (this.getPriority() > dpo.getPriority()) {
            return 1;
        }
        return 0;
    }

    boolean isMessageEnabled() {
        return this.dpContext.isDebugMessageEnabled();
    }

    void debug(Object o) {
        this.message(o);
    }

    void error(Object o) {
        this.dpContext.debugError(o);
    }

    void message(Object o) {
        this.dpContext.debugMessage(o);
    }

    void trace(String msg) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            this.getContext().debugError("XMLDPObject.trace(): " + msg + "\n", e);
            return;
        }
    }

    boolean isPerfMessageEnabled() {
        return this.dpContext.isPerfMessageEnabled();
    }

    boolean isPerfWarningEnabled() {
        return this.dpContext.isPerfWarningEnabled();
    }

    void perfMessage(Object o) {
        this.dpContext.perfMessage(o);
    }

    void perfWarning(Object o) {
        this.dpContext.perfWarning(o);
    }

    public boolean equals(Object o) {
        if (!(o instanceof XMLDPObject)) {
            return false;
        }
        XMLDPObject xmldpo = (XMLDPObject)o;
        Element e = this.getElement();
        Element f = xmldpo.getElement();
        boolean eq = e.equals(f);
        return eq;
    }

    static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public abstract void setMergeDefaults();

    public abstract int getDefaultMergeType();

    static {
        mergeTypeTable = new HashMap();
        mergeTypeTable.put("fuse", new Short(1));
        mergeTypeTable.put("replace", new Short(2));
        mergeTypeTable.put("remove", new Short(3));
        ccount = 0L;
        localeNames = null;
        entityResolver = null;
        errorHandler = null;
    }
}

