/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.perf;

import com.sun.portal.desktop.context.DebugContext;
import com.sun.portal.desktop.perf.DesktopPasContextMBean;
import com.sun.portal.desktop.perf.DesktopPerfMBeanFactory;
import com.sun.portal.desktop.perf.PasContext;
import com.sun.portal.desktop.perf.PasContextException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class DesktopPasContext
implements PasContext,
DesktopPasContextMBean {
    private Date timeStamp = null;
    private int nbRefs = 0;
    private boolean active = false;
    private boolean enabled = false;
    private String myDomain = null;
    private MBeanServer myServer = null;
    private DebugContext pasLog = null;

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public int getNbRefs() {
        return this.nbRefs;
    }

    public void incNbRefs() {
        ++this.nbRefs;
    }

    public void setActive(boolean status) {
        this.active = status;
    }

    public boolean getActive() {
        return this.active;
    }

    public void logMessage(String message) {
        this.pasLog.debugMessage(message);
    }

    public void logMessage(String message, Exception e) {
        this.pasLog.debugMessage(message, e);
    }

    public void logReport() throws PasContextException {
        try {
            Set<ObjectName> allMBeans = this.myServer.queryNames(new ObjectName(this.myDomain + ":*"), null);
            Iterator<ObjectName> i = allMBeans.iterator();
            while (i.hasNext()) {
                ObjectName oName = i.next();
                try {
                    this.myServer.invoke(oName, "logReport", null, null);
                }
                catch (JMException e) {
                    throw new PasContextException("DesktopPasContext.logReport(): error", e);
                }
            }
        }
        catch (JMException e) {
            throw new PasContextException("DesktopPasContext.logReport(): error", e);
        }
        catch (JMRuntimeException e) {
            throw new PasContextException("DesktopPasContext.logReport(): error", e);
        }
    }

    public void init(Object log, String domain, String instance, int[] ports, boolean state) throws PasContextException {
        ObjectName oName;
        this.active = state;
        this.enabled = true;
        this.timeStamp = new Date();
        this.myDomain = domain;
        this.pasLog = (DebugContext)log;
        this.pasLog.init("ipsdt.pas", (short)3);
        this.myServer = DesktopPerfMBeanFactory.findMBeanServer("S1Desktop6.0_Performance_Audit_System");
        if (this.myServer == null) {
            try {
                Integer portnum = null;
                this.myServer = DesktopPerfMBeanFactory.createMBeanServer("S1Desktop6.0_Performance_Audit_System", ports);
                oName = new ObjectName("Services:type=adaptor,name=com.sun.jdmk.comm.HtmlAdaptorServer");
                try {
                    portnum = (Integer)this.myServer.invoke(oName, "getPort", null, null);
                }
                catch (JMException e) {
                    throw new PasContextException("DesktopPasContext.createMBeanServer(): can't get HtmlAdaptorServer port number", e);
                }
                this.logMessage("Performance Audit System for portal instance " + instance + " bound to port " + portnum);
            }
            catch (JMException e) {
                throw new PasContextException("DesktopPasContext(): failed to create MBean server", e);
            }
            catch (JMRuntimeException e) {
                throw new PasContextException("DesktopPasContext(): failed to create MBean server", e);
            }
        }
        try {
            String sName = DesktopPerfMBeanFactory.buildSwitchMBeanName(this.myServer, "S1Desktop6.0_Performance_Audit_System", domain);
            oName = new ObjectName(sName);
            this.myServer.registerMBean(this, oName);
        }
        catch (JMException e) {
            throw new PasContextException("DesktopPasContext(): failed to register switch MBEan", e);
        }
        catch (JMRuntimeException e) {
            throw new PasContextException("DesktopPasContext(): failed to register switch MBEan", e);
        }
    }

    public boolean isActivated() {
        if (this.enabled) {
            return this.getActive();
        }
        return false;
    }

    public void logProcessTime(String rName, String operation, String subject, long elapse) throws PasContextException {
        String sName = this.buildPerfMBeanName(rName, operation, subject);
        ObjectName oName = this.getPerfStatsMBean(sName, false);
        this.logProcessTime(oName, elapse);
    }

    protected MBeanServer getMBeanServer() {
        return this.myServer;
    }

    protected ObjectName getPerfStatsMBean(String name, boolean active) throws PasContextException {
        ObjectName oName = null;
        try {
            oName = DesktopPerfMBeanFactory.getPerfStatsMBean(this.myServer, name, active);
        }
        catch (JMException e) {
            throw new PasContextException("DesktopPasContext.getPerfStatsMBean(): failed ", e);
        }
        return oName;
    }

    protected boolean isPerfStatsMBeanActive(ObjectName oName) throws PasContextException {
        boolean active = false;
        try {
            active = DesktopPerfMBeanFactory.isPerfMBeanActive(this.myServer, oName);
        }
        catch (JMException e) {
            throw new PasContextException("DesktopPasContext.isPerfStatsMBeanActive(): failed", e);
        }
        catch (JMRuntimeException e) {
            throw new PasContextException("DesktopPasContext.isPerfStatsMBeanActive(): failed", e);
        }
        return active;
    }

    protected String buildPerfMBeanName(String rName, String operation, String subject) throws PasContextException {
        String sName = null;
        try {
            sName = DesktopPerfMBeanFactory.buildPerfMBeanName(this.myServer, this.myDomain, "perfMBean", rName, operation, subject);
        }
        catch (RuntimeOperationsException e) {
            throw new PasContextException("DesktopPasContext.buildPerfMBeanName(): failed", e);
        }
        return sName;
    }

    protected String buildPerfMBeanName(String rName) throws PasContextException {
        String name = null;
        try {
            name = DesktopPerfMBeanFactory.buildPerfMBeanName(this.myServer, this.myDomain, "perfMBean", rName);
        }
        catch (JMRuntimeException e) {
            throw new PasContextException("DesktopPasContext.buildPerfMBeanName(): failed", e);
        }
        return name;
    }

    protected void logProcessTime(ObjectName oName, long elapse) throws PasContextException {
        if (this.active && this.isPerfStatsMBeanActive(oName)) {
            try {
                DesktopPerfMBeanFactory.logProcessTime(this.myServer, oName, elapse);
            }
            catch (JMException e) {
                throw new PasContextException("DesktopPasContext.logProcessTime(): failed", e);
            }
            catch (JMRuntimeException e) {
                throw new PasContextException("DesktopPasContext.logProcessTime(): failed", e);
            }
        }
    }

    protected static boolean isResourceTypeValid(String rType) {
        return true;
    }
}

