/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.template;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.template.ParsedTagArray;
import com.sun.portal.desktop.template.ParsedTagElement;
import com.sun.portal.desktop.util.NSStringBuffer;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.Hashtable;

public class TagSwapper {
    public static StringBuffer doSwap(StringBuffer inBuffer, Hashtable aTagTable, String sContent, String channel, ContainerProviderContext pc) {
        if (inBuffer == null) {
            return inBuffer;
        }
        ParsedTagArray pta = new ParsedTagArray(inBuffer);
        return TagSwapper.doSwapFromParsedTagArray(pta, pc, channel, sContent, aTagTable);
    }

    /*
     * WARNING - void declaration
     */
    private static String getPropertyValue(String channel, ContainerProviderContext pc, String key) {
        if (!pc.existsChannel(channel)) {
            return null;
        }
        try {
            void pce;
            if (!pc.existsStringProperty(channel, key)) {
                return null;
            }
            String value = pc.getStringProperty(channel, key);
            return pce;
        }
        catch (ProviderContextException pce) {
            pc.debugError("TagSwapper.getPropertyValue(): channel " + channel + " key " + key, pce);
            return null;
        }
    }

    private static String getAttributeValue(ContainerProviderContext pc, String key) {
        String value = pc.getStringAttribute(key);
        return value;
    }

    public static StringBuffer doSwapFromParsedTagArray(ParsedTagArray pta, ContainerProviderContext pc, String channel, String sContent, Hashtable aTagTable) {
        if (pta == null) {
            return null;
        }
        if (aTagTable == null) {
            return pta.getTemplateSB();
        }
        StringBuffer outBuffer = new StringBuffer(pta.getStaticLength() + pta.getNumberTags() * 100);
        int numpte = pta.size();
        if (numpte == 0) {
            return outBuffer;
        }
        int i = 0;
        while (i < numpte) {
            ParsedTagElement pte = pta.get(i);
            String key = pte.getKey();
            switch (pte.getType()) {
                case 0: {
                    outBuffer.append(key);
                    break;
                }
                case 1: {
                    Object value = aTagTable.get(key);
                    if (value == null && pc != null) {
                        value = TagSwapper.getPropertyValue(channel, pc, key);
                    }
                    if (value == null && pc != null && (value = TagSwapper.getAttributeValue(pc, key)) == null || value == null) break;
                    String valueStr = value.toString();
                    if (value instanceof NSStringBuffer) {
                        outBuffer.append(valueStr);
                        break;
                    }
                    StringBuffer tagValue = new StringBuffer(valueStr);
                    outBuffer.append((Object)TagSwapper.doSwapFromParsedTagArray(new ParsedTagArray(tagValue), pc, channel, sContent, aTagTable));
                    break;
                }
                case 2: {
                    String encodedURL = null;
                    encodedURL = pc != null ? pc.encodeURL(key) : key;
                    outBuffer.append(encodedURL);
                    break;
                }
                case 3: {
                    outBuffer.append(sContent);
                    outBuffer.append(key);
                    break;
                }
                default: {
                    throw new DesktopError("TagSwapper.doSwapFromParsedTagArray(): invalid ParsedTagElement type");
                }
            }
            ++i;
        }
        return outBuffer;
    }
}

