/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers;

import com.sun.portal.desktop.RequestThreadLocalizer;
import com.sun.portal.providers.ProfileProviderAdapter;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.ContainerProvider;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.util.List;

public class ContainerProviderAdapter
extends ProfileProviderAdapter
implements ContainerProvider {
    public ContainerProviderContext getContainerProviderContext() throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        if (!(pc instanceof ContainerProviderContext)) {
            throw new ProviderException("ContainerProviderAdapter.getContainerProviderContext(): not a container provider context");
        }
        return (ContainerProviderContext)pc;
    }

    public List getSelectedChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getSelectedChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getSelectedChannels(): ", pce);
        }
    }

    public List getAvailableChannels() throws ProviderException {
        try {
            return this.getContainerProviderContext().getAvailableChannels(this.getName());
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getAvailableChannels(): ", pce);
        }
    }

    public void setSelectedChannels(List sel) throws ProviderException {
        try {
            this.getContainerProviderContext().setSelectedChannels(this.getName(), sel);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.setSelectedChannels(): ", pce);
        }
    }

    public void setAvailableChannels(List avail) throws ProviderException {
        try {
            this.getContainerProviderContext().setAvailableChannels(this.getName(), avail);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("ContainerProviderAdapter.getAvailableChannels(): ", pce);
        }
    }

    public long getRefreshTime() throws ProviderException {
        String refreshTime = this.getStringProperty("refreshTime");
        long refreshTimelong = 0L;
        if (refreshTime != null && refreshTime.length() != 0) {
            return Long.parseLong(refreshTime);
        }
        List selected = this.getSelectedChannels();
        int size = selected.size();
        int i = 0;
        while (i < size) {
            String channel = (String)selected.get(i);
            Provider p = this.getContainerProviderContext().getProvider(RequestThreadLocalizer.getRequest(), this.getName(), channel);
            if (p != null) {
                try {
                    long rt = p.getRefreshTime();
                    refreshTimelong = Math.min(refreshTimelong, rt);
                }
                catch (ProviderException pe) {
                    this.getProviderContext().debugError("ContainerProviderAdapter.getRefreshTime(): exception in getRefreshTime " + channel);
                }
            } else {
                this.getProviderContext().debugError("ContainerProviderAdapter.getRefreshTime(): invalid channel " + channel);
            }
            ++i;
        }
        return refreshTimelong;
    }
}

