/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.MIMEHelper;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.DecoratedURI;

public class URISpec {
    private String inputString;
    private DecoratedURI baseURI;
    private String mime;

    public URISpec(String string) {
        this(string, null);
    }

    public URISpec(String string, String string2) {
        this.mime = StringHelper.normalize(string2);
        this.setBase(string);
    }

    public void setBase(String string) {
        try {
            String string2;
            this.baseURI = new DecoratedURI(string);
            if (!this.baseURI.isValid() && !this.baseURI.isAbsolute()) {
                throw new Exception("Not a Valid Absolute URI" + string);
            }
            if (this.mime.length() == 0) {
                this.mime = MIMEHelper.guessContentTypeFromFileName(this.baseURI.getFileName());
            }
            if ((string2 = this.baseURI.getParameterValue("scriptReferrer")).length() != 0) {
                this.inputString = string;
                this.setBase(string2);
                return;
            }
            if (this.inputString == null) {
                this.inputString = string;
            }
        }
        catch (Exception exception) {
            Debug.recordPageError("Invalid Base: " + string, exception);
        }
    }

    public DecoratedURI getBaseURI() {
        return this.baseURI;
    }

    public String getInputString() {
        return this.inputString;
    }

    public String getMIME() {
        return this.mime;
    }

    public static void main(String[] stringArray) {
    }
}

