/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.UniversalRewriter;
import com.sun.portal.rewriter.engines.css.CSSRewriter;
import com.sun.portal.rewriter.engines.dummy.NullRewriter;
import com.sun.portal.rewriter.engines.html.HTMLRewriter;
import com.sun.portal.rewriter.engines.js.JSRewriter;
import com.sun.portal.rewriter.engines.wml.WMLRewriter;
import com.sun.portal.rewriter.engines.xml.XMLRewriter;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import java.io.Reader;
import java.io.StringReader;

public class CompositeRewriter
implements Rewriter {
    private final RuleSet ruleSet;
    private UniversalRewriter universalRewriter;
    private HTMLRewriter htmlRewriter;
    private JSRewriter jsRewriter;
    private XMLRewriter xmlRewriter;
    private CSSRewriter cssRewriter;
    private WMLRewriter wmlRewriter;

    public CompositeRewriter(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public Reader rewrite(Reader reader, Translator translator) {
        return new StringReader(this.rewrite(Resource.read(reader), translator));
    }

    public String rewrite(String string, Translator translator) {
        String string2 = translator.getBaseSpec().getMIME();
        Rewriter rewriter = this.getInstance(string2);
        if (rewriter != null) {
            return rewriter.rewrite(string, translator);
        }
        return string;
    }

    public Rewriter getInstance(String string) {
        if ((string = StringHelper.normalize(string)).indexOf("text/html") != -1) {
            return this.getHTMLRewriter();
        }
        if (string.indexOf("text/universal") != -1) {
            return this.getUniversalRewriter();
        }
        if (string.indexOf("application/x-javascript") != -1) {
            return this.getJSRewriter();
        }
        if (string.indexOf("text/css") != -1) {
            return this.getCSSRewriter();
        }
        if (string.indexOf("text/xml") != -1) {
            return this.getXMLRewriter();
        }
        if (string.indexOf("text/wml") != -1) {
            return this.getWMLRewriter();
        }
        if (string.indexOf("text/null") != -1) {
            return new NullRewriter(null, null);
        }
        return null;
    }

    public UniversalRewriter getUniversalRewriter() {
        if (this.universalRewriter == null) {
            this.universalRewriter = new UniversalRewriter(this, this.ruleSet);
        }
        return this.universalRewriter;
    }

    public HTMLRewriter getHTMLRewriter() {
        if (this.htmlRewriter == null) {
            this.htmlRewriter = new HTMLRewriter(this, this.ruleSet);
        }
        return this.htmlRewriter;
    }

    public JSRewriter getJSRewriter() {
        if (this.jsRewriter == null) {
            this.jsRewriter = new JSRewriter(this, this.ruleSet);
        }
        return this.jsRewriter;
    }

    public XMLRewriter getXMLRewriter() {
        if (this.xmlRewriter == null) {
            this.xmlRewriter = new XMLRewriter(this, this.ruleSet);
        }
        return this.xmlRewriter;
    }

    public CSSRewriter getCSSRewriter() {
        if (this.cssRewriter == null) {
            this.cssRewriter = new CSSRewriter(this, this.ruleSet);
        }
        return this.cssRewriter;
    }

    public WMLRewriter getWMLRewriter() {
        if (this.wmlRewriter == null) {
            this.wmlRewriter = new WMLRewriter(this, this.ruleSet);
        }
        return this.wmlRewriter;
    }
}

