/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.js.parser;

import com.sun.portal.rewriter.DataRuleCollection;
import com.sun.portal.rewriter.RuleSet;
import com.sun.portal.rewriter.engines.js.Function;
import com.sun.portal.rewriter.engines.js.JSRules;
import com.sun.portal.rewriter.engines.js.Variable;
import com.sun.portal.rewriter.engines.js.parser.JavaScriptException;
import com.sun.portal.rewriter.engines.js.parser.TokenStream;
import com.sun.portal.rewriter.test.util.CreateRuleSet;
import com.sun.portal.rewriter.util.Debug;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class JSParser {
    private static final Integer INT_EXPRESSION_LP = new Integer(2);
    private static final Integer INT_EXPRESSION_RP = new Integer(6);
    private static final Integer INT_IPLANET_PATH_LP = new Integer(7);
    private static final Integer INT_IPLANET_PATH_RP = new Integer(8);
    private final Function functionMatche = new Function("URL", "xxyyzz", "");
    private final Variable variableMatche = new Variable("URL", "xxyyzz");
    private final DataRuleCollection urlJSVariables;
    private final DataRuleCollection expressionJSVariables;
    private final DataRuleCollection dhtmlJSVariables;
    private final DataRuleCollection djsJSVariables;
    private final DataRuleCollection systemJSVariables;
    private final DataRuleCollection urlJSFunctions;
    private final DataRuleCollection expressionJSFunctions;
    private final DataRuleCollection dhtmlJSFunctions;
    private final DataRuleCollection djsJSFunctions;
    private List tokenList;
    private int lastExprEndLine;
    private boolean ok;
    private static final boolean implementsCatchCond = false;

    public JSParser(RuleSet ruleSet) {
        JSRules jSRules = ruleSet.getJSRules();
        JSRules.CategorizedSet categorizedSet = jSRules.getCategorizedSet();
        this.urlJSVariables = categorizedSet.urlJSVariables;
        this.expressionJSVariables = categorizedSet.expressionJSVariables;
        this.dhtmlJSVariables = categorizedSet.dhtmlJSVariables;
        this.djsJSVariables = categorizedSet.djsJSVariables;
        this.systemJSVariables = categorizedSet.systemJSVariables;
        this.urlJSFunctions = categorizedSet.urlJSFunctions;
        this.expressionJSFunctions = categorizedSet.expressionJSFunctions;
        this.dhtmlJSFunctions = categorizedSet.dhtmlJSFunctions;
        this.djsJSFunctions = categorizedSet.djsJSFunctions;
    }

    private void mustMatchToken(TokenStream tokenStream, int n, String string) throws IOException, JavaScriptException {
        int n2 = tokenStream.getToken();
        if (n2 != n) {
            this.reportError(tokenStream, string);
            tokenStream.ungetToken(n2);
        }
    }

    private void reportError(TokenStream tokenStream, String string) throws JavaScriptException {
        if (this.ok) {
            this.ok = false;
            if ((tokenStream.flags & 1) == 0) {
                String string2 = JSParser.getMessage(string, null);
                throw new JavaScriptException(string2);
            }
        }
        throw new JavaScriptException(string);
    }

    public List parse(String string) throws JavaScriptException {
        return this.parse("ContentID:X", string);
    }

    public List parse(String string, String string2) throws JavaScriptException {
        return Collections.unmodifiableList(this.parse(string, string2, new ArrayList()));
    }

    public List parse(String string, String string2, List list) throws JavaScriptException {
        this.tokenList = list;
        StringReader stringReader = new StringReader(string2);
        TokenStream tokenStream = new TokenStream(stringReader, string, 0);
        try {
            this.ok = true;
            int n = tokenStream.getLineno();
            while (this.ok) {
                tokenStream.flags |= 0x200;
                int n2 = tokenStream.getToken();
                tokenStream.flags &= 0xFFFFFDFF;
                if (n2 > 0) {
                    if (n2 == 109) {
                        try {
                            this.function(tokenStream);
                            this.wellTerminated(tokenStream, 109);
                        }
                        catch (JavaScriptException javaScriptException) {
                            this.ok = false;
                            if (!Debug.isWarningEnabled()) continue;
                            Debug.recordPageWarning("Failed to parse JavaScript:" + string2, javaScriptException);
                        }
                        continue;
                    }
                    tokenStream.ungetToken(n2);
                    this.statement(tokenStream);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            Debug.recordWarning("JSParser IOException: Should Never Occur ", iOException);
        }
        return this.tokenList;
    }

    private void parseFunctionBody(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n = tokenStream.flags;
        tokenStream.flags &= 0xFFFFFFCF;
        tokenStream.flags |= 8;
        try {
            this.statements(tokenStream);
            Object var4_3 = null;
            tokenStream.flags = n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            tokenStream.flags = n;
            throw throwable;
        }
    }

    private void function(TokenStream tokenStream) throws IOException, JavaScriptException {
        String string = null;
        int n = tokenStream.getLineno();
        if (tokenStream.matchToken(44)) {
            string = tokenStream.getString();
            while (tokenStream.matchToken(107) && tokenStream.matchToken(44)) {
                string = string + "." + tokenStream.getString();
            }
        }
        this.mustMatchToken(tokenStream, 93, "msg.no.paren.parms");
        if (!tokenStream.matchToken(94)) {
            do {
                this.mustMatchToken(tokenStream, 44, "msg.no.parm");
            } while (tokenStream.matchToken(95));
            this.mustMatchToken(tokenStream, 94, "msg.no.paren.after.parms");
        }
        this.mustMatchToken(tokenStream, 91, "msg.no.brace.body");
        this.parseFunctionBody(tokenStream);
        this.mustMatchToken(tokenStream, 92, "msg.no.brace.after.body");
    }

    private void statements(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n;
        while ((n = tokenStream.peekToken()) > 0 && n != 92) {
            this.statement(tokenStream);
        }
    }

    private void condition(TokenStream tokenStream) throws IOException, JavaScriptException {
        this.mustMatchToken(tokenStream, 93, "msg.no.paren.cond");
        this.expr(tokenStream, false);
        this.mustMatchToken(tokenStream, 94, "msg.no.paren.after.cond");
    }

    private boolean wellTerminated(TokenStream tokenStream, int n) throws IOException, JavaScriptException {
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == -1) {
            this.reportError(tokenStream, "msg.scanner.caught.error");
            return false;
        }
        if (n2 != 0 && n2 != 1 && n2 != 88 && n2 != 92) {
            if (n2 == 109 || n == 109) {
                return true;
            }
            this.reportError(tokenStream, "msg.no.semi.stmt");
        }
        return true;
    }

    private String matchLabel(TokenStream tokenStream) throws IOException, JavaScriptException {
        int n = tokenStream.getLineno();
        String string = null;
        int n2 = tokenStream.peekTokenSameLine();
        if (n2 == 44) {
            tokenStream.getToken();
            string = tokenStream.getString();
        }
        return string;
    }

    private void statement(TokenStream tokenStream) throws IOException, JavaScriptException {
        try {
            this.statementHelper(tokenStream);
        }
        catch (JavaScriptException javaScriptException) {
            int n;
            if (Debug.isWarningEnabled()) {
                Debug.recordPageWarning(javaScriptException.toString(), javaScriptException);
            }
            while ((n = tokenStream.getToken()) != 88 && n != 1 && n != 0 && n != -1) {
            }
        }
    }

    private void statementHelper(TokenStream tokenStream) throws IOException, JavaScriptException {
        Object var2_2 = null;
        boolean bl = false;
        int n = 0;
        int n2 = tokenStream.getToken();
        switch (n2) {
            case 112: {
                bl = true;
                this.condition(tokenStream);
                this.statement(tokenStream);
                if (!tokenStream.matchToken(113)) break;
                this.statement(tokenStream);
                break;
            }
            case 114: {
                bl = true;
                this.mustMatchToken(tokenStream, 93, "msg.no.paren.switch");
                this.expr(tokenStream, false);
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.after.switch");
                this.mustMatchToken(tokenStream, 91, "msg.no.brace.switch");
                while ((n2 = tokenStream.getToken()) != 92 && n2 != 0) {
                    switch (n2) {
                        case 115: {
                            this.expr(tokenStream, false);
                            break;
                        }
                        case 116: {
                            break;
                        }
                        default: {
                            this.reportError(tokenStream, "msg.bad.switch");
                        }
                    }
                    this.mustMatchToken(tokenStream, 98, "msg.no.colon.case");
                    while ((n2 = tokenStream.peekToken()) != 92 && n2 != 115 && n2 != 116 && n2 != 0) {
                        this.statement(tokenStream);
                    }
                }
                break;
            }
            case 117: {
                bl = true;
                this.condition(tokenStream);
                this.statement(tokenStream);
                break;
            }
            case 118: {
                this.statement(tokenStream);
                this.mustMatchToken(tokenStream, 117, "msg.no.while.do");
                this.condition(tokenStream);
                break;
            }
            case 119: {
                bl = true;
                this.mustMatchToken(tokenStream, 93, "msg.no.paren.for");
                n2 = tokenStream.peekToken();
                if (n2 != 88) {
                    if (n2 == 122) {
                        tokenStream.getToken();
                        this.variables(tokenStream, true);
                    } else {
                        this.expr(tokenStream, true);
                    }
                }
                if ((n2 = tokenStream.peekToken()) == 102 && tokenStream.getOp() == 63) {
                    tokenStream.matchToken(102);
                    this.expr(tokenStream, false);
                } else {
                    this.mustMatchToken(tokenStream, 88, "msg.no.semi.for");
                    if (tokenStream.peekToken() != 88) {
                        this.expr(tokenStream, false);
                    }
                    this.mustMatchToken(tokenStream, 88, "msg.no.semi.for.cond");
                    if (tokenStream.peekToken() != 94) {
                        this.expr(tokenStream, false);
                    }
                }
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.for.ctrl");
                this.statement(tokenStream);
                break;
            }
            case 75: {
                bl = true;
                this.statement(tokenStream);
                int n3 = tokenStream.peekToken();
                if (n3 == 124) {
                    while (tokenStream.matchToken(124)) {
                        this.mustMatchToken(tokenStream, 93, "msg.no.paren.catch");
                        this.mustMatchToken(tokenStream, 44, "msg.bad.catchcond");
                        this.mustMatchToken(tokenStream, 94, "msg.bad.catchcond");
                        this.mustMatchToken(tokenStream, 91, "msg.no.brace.catchblock");
                        this.statements(tokenStream);
                        tokenStream.matchToken(92);
                    }
                } else if (n3 != 125) {
                    this.mustMatchToken(tokenStream, 125, "msg.try.no.catchfinally");
                }
                if (!tokenStream.matchToken(125)) break;
                this.statement(tokenStream);
                break;
            }
            case 62: {
                int n4 = tokenStream.getLineno();
                this.expr(tokenStream, false);
                if (n4 != tokenStream.getLineno()) break;
                this.wellTerminated(tokenStream, -1);
                break;
            }
            case 120: {
                String string = this.matchLabel(tokenStream);
                break;
            }
            case 121: {
                String string = this.matchLabel(tokenStream);
                break;
            }
            case 123: {
                bl = true;
                this.mustMatchToken(tokenStream, 93, "msg.no.paren.with");
                this.expr(tokenStream, false);
                this.mustMatchToken(tokenStream, 94, "msg.no.paren.after.with");
                this.statement(tokenStream);
                break;
            }
            case 122: {
                int n5 = tokenStream.getLineno();
                this.variables(tokenStream, false);
                break;
            }
            case 5: {
                int n6 = 0;
                tokenStream.flags |= 0x200;
                n2 = tokenStream.peekTokenSameLine();
                tokenStream.flags &= 0xFFFFFDFF;
                if (n2 != 0 && n2 != 1 && n2 != 88 && n2 != 92) {
                    n6 = tokenStream.getLineno();
                    this.expr(tokenStream, false);
                    tokenStream.flags |= 0x10;
                    break;
                }
                tokenStream.flags |= 0x20;
                break;
            }
            case 91: {
                bl = true;
                this.statements(tokenStream);
                this.mustMatchToken(tokenStream, 92, "msg.no.brace.block");
                break;
            }
            case -1: {
                this.reportError(tokenStream, "msg.scanner.caught.error");
            }
            case 1: 
            case 88: {
                bl = true;
                break;
            }
            default: {
                n = n2;
                int n7 = tokenStream.getTokenno();
                tokenStream.ungetToken(n2);
                int n8 = tokenStream.getLineno();
                this.expr(tokenStream, false);
                if (tokenStream.peekToken() == 98) {
                    if (n != 44 || tokenStream.getTokenno() != n7) {
                        this.reportError(tokenStream, "msg.bad.label");
                    }
                    tokenStream.getToken();
                    String string = tokenStream.getString();
                    return;
                }
                int n9 = tokenStream.getToken();
                int n10 = tokenStream.getLineno();
                tokenStream.ungetToken(n9);
                if (n != 109 || tokenStream.getLineno() != this.lastExprEndLine) break;
                this.wellTerminated(tokenStream, n);
            }
        }
        tokenStream.matchToken(88);
    }

    private void variables(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        do {
            this.mustMatchToken(tokenStream, 44, "msg.bad.var");
            this.handleVariableMatch(tokenStream.getString(), tokenStream, bl);
        } while (tokenStream.matchToken(95));
    }

    private void expr(TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        this.assignExpr(tokenStream, bl, 0);
        while (tokenStream.matchToken(95)) {
            this.assignExpr(tokenStream, bl, 0);
        }
    }

    private void assignExpr(TokenStream tokenStream, boolean bl, int n) throws IOException, JavaScriptException {
        StringBuffer stringBuffer = new StringBuffer();
        this.condExpr(tokenStream, bl, stringBuffer, n);
        this.handleVariableMatch(stringBuffer.toString(), tokenStream, bl);
    }

    private void condExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.orExpr(tokenStream, bl, stringBuffer, n);
        if (tokenStream.matchToken(97)) {
            this.assignExpr(tokenStream, false, n);
            this.mustMatchToken(tokenStream, 98, "msg.no.colon.cond");
            this.assignExpr(tokenStream, bl, n);
        }
    }

    private void orExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.andExpr(tokenStream, bl, stringBuffer, n);
        if (tokenStream.matchToken(99)) {
            this.orExpr(tokenStream, bl, null, 0);
        }
    }

    private void andExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.bitOrExpr(tokenStream, bl, stringBuffer, n);
        if (tokenStream.matchToken(100)) {
            this.andExpr(tokenStream, bl, null, 0);
        }
    }

    private void bitOrExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.bitXorExpr(tokenStream, bl, stringBuffer, n);
        while (tokenStream.matchToken(11)) {
            this.bitXorExpr(tokenStream, bl, null, 0);
        }
    }

    private void bitXorExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.bitAndExpr(tokenStream, bl, stringBuffer, n);
        while (tokenStream.matchToken(12)) {
            this.bitAndExpr(tokenStream, bl, null, 0);
        }
    }

    private void bitAndExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.eqExpr(tokenStream, bl, stringBuffer, n);
        while (tokenStream.matchToken(13)) {
            this.eqExpr(tokenStream, bl, null, 0);
        }
    }

    private void eqExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.relExpr(tokenStream, bl, stringBuffer, n);
        while (tokenStream.matchToken(101)) {
            this.relExpr(tokenStream, bl, null, 0);
        }
    }

    private void relExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.shiftExpr(tokenStream, stringBuffer, n);
        while (tokenStream.matchToken(102)) {
            int n2 = tokenStream.getOp();
            if (bl && n2 == 63) {
                tokenStream.ungetToken(102);
                break;
            }
            this.shiftExpr(tokenStream, null, 0);
        }
    }

    private void shiftExpr(TokenStream tokenStream, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        this.addExpr(tokenStream, stringBuffer, n);
        while (tokenStream.matchToken(103)) {
            this.addExpr(tokenStream, null, 0);
        }
    }

    private void addExpr(TokenStream tokenStream, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        int n2;
        this.mulExpr(tokenStream, stringBuffer, n);
        while ((n2 = tokenStream.getToken()) == 23 || n2 == 24) {
            if (n2 == 24 || n == 1) {
                this.mulExpr(tokenStream, null, 0);
                continue;
            }
            this.mulExpr(tokenStream, null, n);
        }
        tokenStream.ungetToken(n2);
    }

    private void mulExpr(TokenStream tokenStream, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        int n2;
        this.unaryExpr(tokenStream, stringBuffer, n);
        while ((n2 = tokenStream.peekToken()) == 25 || n2 == 26 || n2 == 27) {
            n2 = tokenStream.getToken();
            this.unaryExpr(tokenStream, null, 0);
        }
    }

    private void unaryExpr(TokenStream tokenStream, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x200;
        int n2 = tokenStream.getToken();
        tokenStream.flags &= 0xFFFFFDFF;
        switch (n2) {
            case 104: {
                this.unaryExpr(tokenStream, stringBuffer, 0);
                return;
            }
            case 23: 
            case 24: {
                this.unaryExpr(tokenStream, null, 0);
                return;
            }
            case 105: 
            case 106: {
                this.memberExpr(tokenStream, true, stringBuffer, 0);
                return;
            }
            case 31: {
                this.unaryExpr(tokenStream, null, 0);
                return;
            }
            case -1: {
                this.reportError(tokenStream, "msg.scanner.caught.error");
                break;
            }
            default: {
                tokenStream.ungetToken(n2);
                int n3 = tokenStream.getLineno();
                this.memberExpr(tokenStream, true, stringBuffer, n);
                n2 = tokenStream.peekToken();
                if (!tokenStream.matchToken(105)) {
                    tokenStream.matchToken(106);
                }
                return;
            }
        }
    }

    private void argumentList(TokenStream tokenStream, String string) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x200;
        boolean bl = tokenStream.matchToken(94);
        tokenStream.flags &= 0xFFFFFDFF;
        if (!bl) {
            Function function = this.findFunctionMatch(string, 10);
            if (function == null) {
                do {
                    this.assignExpr(tokenStream, false, 0);
                } while (tokenStream.matchToken(95));
            } else {
                String[] stringArray = function.getParamSpec(10);
                int n = function.getTypeCode();
                int n2 = 0;
                do {
                    if (stringArray[n2].equalsIgnoreCase("y")) {
                        if (n == 2) {
                            this.addExpressionTokens(tokenStream, this.tokenList);
                        } else {
                            this.assignExpr(tokenStream, false, n);
                        }
                    } else {
                        this.assignExpr(tokenStream, false, 0);
                    }
                    ++n2;
                } while (tokenStream.matchToken(95));
            }
            this.mustMatchToken(tokenStream, 94, "msg.no.paren.arg");
        }
    }

    private void memberExpr(TokenStream tokenStream, boolean bl, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        boolean bl2;
        CharSequence charSequence;
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl3 = true;
        boolean bl4 = false;
        tokenStream.flags |= 0x200;
        int n2 = tokenStream.peekToken();
        tokenStream.flags &= 0xFFFFFDFF;
        if (n2 == 30) {
            tokenStream.getToken();
            charSequence = new StringBuffer();
            this.memberExpr(tokenStream, false, (StringBuffer)charSequence, 0);
            if (tokenStream.matchToken(93)) {
                this.argumentList(tokenStream, charSequence.toString());
            }
        } else {
            this.primaryExpr(tokenStream, stringBuffer2, n);
        }
        int n3 = tokenStream.getLineno();
        int n4 = tokenStream.getOffset() + 1;
        int n5 = n3;
        int n6 = n4 - stringBuffer2.length();
        this.lastExprEndLine = tokenStream.getLineno();
        while ((n2 = tokenStream.getToken()) > 0) {
            if (n2 == 107) {
                this.mustMatchToken(tokenStream, 44, "msg.no.name.after.dot");
                charSequence = tokenStream.getString();
                stringBuffer2.append("." + (String)charSequence);
                n3 = this.lastExprEndLine = tokenStream.getLineno();
                n4 = tokenStream.getOffset() + 1;
                continue;
            }
            if (n2 == 89) {
                bl3 = false;
                this.expr(tokenStream, false);
                this.mustMatchToken(tokenStream, 90, "msg.no.bracket.index");
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            if (bl && n2 == 93) {
                bl4 = true;
                charSequence = bl3 ? stringBuffer2.toString() : null;
                this.argumentList(tokenStream, (String)charSequence);
                this.lastExprEndLine = tokenStream.getLineno();
                continue;
            }
            tokenStream.ungetToken(n2);
            break;
        }
        if (!bl4 && stringBuffer != null) {
            stringBuffer.append(stringBuffer2.toString());
        }
        if (stringBuffer2.toString().trim().length() > 0 && (bl2 = this.systemJSVariables.contains(new Variable("SYSTEM", stringBuffer2.toString())))) {
            this.addSystemTokens(stringBuffer2, n5, n6, this.tokenList);
        }
        if (n2 == -1) {
            this.reportError(tokenStream, "msg.scanner.caught.error");
        }
    }

    private void primaryExpr(TokenStream tokenStream, StringBuffer stringBuffer, int n) throws IOException, JavaScriptException {
        tokenStream.flags |= 0x200;
        int n2 = tokenStream.getToken();
        int n3 = tokenStream.getLineno();
        int n4 = tokenStream.getOffset();
        tokenStream.flags &= 0xFFFFFDFF;
        switch (n2) {
            case 109: {
                this.function(tokenStream);
                return;
            }
            case 89: {
                tokenStream.flags |= 0x200;
                boolean bl = tokenStream.matchToken(90);
                tokenStream.flags &= 0xFFFFFDFF;
                if (!bl) {
                    do {
                        tokenStream.flags |= 0x200;
                        n2 = tokenStream.peekToken();
                        tokenStream.flags &= 0xFFFFFDFF;
                        if (n2 == 90) break;
                        if (n2 == 95) continue;
                        this.assignExpr(tokenStream, false, 0);
                    } while (tokenStream.matchToken(95));
                    this.mustMatchToken(tokenStream, 90, "msg.no.bracket.arg");
                }
                return;
            }
            case 91: {
                if (!tokenStream.matchToken(92)) {
                    block19: do {
                        n2 = tokenStream.getToken();
                        switch (n2) {
                            case 44: 
                            case 46: {
                                String string = tokenStream.getString();
                                break;
                            }
                            case 45: {
                                break;
                            }
                            case 92: {
                                tokenStream.ungetToken(n2);
                                break block19;
                            }
                            default: {
                                this.reportError(tokenStream, "msg.bad.prop");
                                break block19;
                            }
                        }
                        this.mustMatchToken(tokenStream, 98, "msg.no.colon.prop");
                        this.assignExpr(tokenStream, false, 0);
                    } while (tokenStream.matchToken(95));
                    this.mustMatchToken(tokenStream, 92, "msg.no.brace.prop");
                }
                return;
            }
            case 93: {
                this.expr(tokenStream, false);
                this.mustMatchToken(tokenStream, 94, "msg.no.paren");
                return;
            }
            case 44: {
                String string = tokenStream.getString();
                stringBuffer.append(string);
                return;
            }
            case 45: {
                return;
            }
            case 46: {
                String string = tokenStream.getString();
                int n5 = tokenStream.getStringOffset();
                int n6 = n4 - 1 - n5;
                if (n != 0) {
                    this.addRestTypeTokens(n3, n5, n, n6, this.tokenList);
                }
                return;
            }
            case 56: {
                String string = tokenStream.regExpFlags;
                tokenStream.regExpFlags = null;
                String string2 = tokenStream.getString();
                return;
            }
            case 108: {
                String string = tokenStream.getString();
                if (string.equals("this") || string.equals("super")) {
                    stringBuffer.append(string);
                }
                return;
            }
            case 126: {
                this.reportError(tokenStream, "msg.reserved.id");
                break;
            }
            case -1: {
                this.reportError(tokenStream, "msg.scanner.caught.error");
                break;
            }
            default: {
                this.reportError(tokenStream, "msg.syntax");
            }
        }
    }

    private void handleVariableMatch(String string, TokenStream tokenStream, boolean bl) throws IOException, JavaScriptException {
        if (tokenStream.matchToken(96)) {
            int n = 0;
            Variable variable = this.findVariableMatch(string);
            if (variable != null) {
                n = variable.getTypeCode();
                if ((n == 1 || n == 2) && tokenStream.getOp() != 127) {
                    this.assignExpr(tokenStream, bl, 0);
                    return;
                }
                if (n == 2) {
                    this.addExpressionTokens(tokenStream, this.tokenList);
                    return;
                }
            }
            this.assignExpr(tokenStream, bl, n);
        }
    }

    private Variable findVariableMatch(String string) {
        String string2 = string;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        Variable variable = (Variable)this.expressionJSVariables.findMatch(Variable.cycleMatche(this.variableMatche, 2, string2));
        if (variable != null) {
            return variable;
        }
        variable = (Variable)this.urlJSVariables.findMatch(Variable.cycleMatche(this.variableMatche, 1, string2));
        if (variable != null) {
            return variable;
        }
        variable = (Variable)this.dhtmlJSVariables.findMatch(Variable.cycleMatche(this.variableMatche, 3, string2));
        if (variable != null) {
            return variable;
        }
        variable = (Variable)this.djsJSVariables.findMatch(Variable.cycleMatche(this.variableMatche, 4, string2));
        if (variable != null) {
            return variable;
        }
        return null;
    }

    private Function findFunctionMatch(String string, int n) {
        String string2 = string;
        if (string2 == null || string2.length() == 0 || n == 0) {
            return null;
        }
        Function function = (Function)this.expressionJSFunctions.findMatch(Function.cycleMatche(this.functionMatche, 2, string2, null));
        if (function != null) {
            return function;
        }
        function = (Function)this.urlJSFunctions.findMatch(Function.cycleMatche(this.functionMatche, 1, string2, null));
        if (function != null) {
            return function;
        }
        function = (Function)this.dhtmlJSFunctions.findMatch(Function.cycleMatche(this.functionMatche, 3, string2, null));
        if (function != null) {
            return function;
        }
        function = (Function)this.djsJSFunctions.findMatch(Function.cycleMatche(this.functionMatche, 4, string2, null));
        if (function != null) {
            return function;
        }
        return null;
    }

    private Collection addSystemTokens(StringBuffer stringBuffer, int n, int n2, Collection collection) {
        Collection collection2 = this.normalize(collection);
        collection2.add(new Integer(n));
        collection2.add(new Integer(n2 - 1));
        collection2.add(INT_IPLANET_PATH_LP);
        collection2.add(new Integer(n));
        collection2.add(new Integer(n2 + stringBuffer.toString().length() - 1));
        collection2.add(INT_IPLANET_PATH_RP);
        return collection2;
    }

    private Collection addRestTypeTokens(int n, int n2, int n3, int n4, Collection collection) {
        Collection collection2 = this.normalize(collection);
        collection2.add(new Integer(n));
        collection2.add(new Integer(n2));
        collection2.add(new Integer(n3));
        collection2.add(new Integer(n4));
        return collection2;
    }

    private Collection addExpressionTokens(TokenStream tokenStream, Collection collection) throws IOException, JavaScriptException {
        Collection collection2 = this.normalize(collection);
        int n = tokenStream.getLineno();
        int n2 = tokenStream.getOffset();
        collection2.add(new Integer(n));
        collection2.add(new Integer(n2));
        collection2.add(INT_EXPRESSION_LP);
        this.assignExpr(tokenStream, false, 0);
        n = tokenStream.getLineno();
        n2 = tokenStream.getOffset();
        collection2.add(new Integer(n));
        collection2.add(new Integer(tokenStream.getOffset()));
        collection2.add(INT_EXPRESSION_RP);
        return collection2;
    }

    private Collection normalize(Collection collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return collection;
    }

    static String getMessage(String string, Object[] objectArray) {
        return "JavaScript compile error : id = " + string;
    }

    public static void main(String[] stringArray) throws Exception {
        String[][] stringArrayArray = new String[][]{{"dottedExpressionVar", "this.sessURL = prot + \"http://myhost.domain.com:81\" + \"/scripts/cgi\";"}};
        String string = "<Variable type=\"EXPRESSION\">this.sessURL</Variable>";
        int n = 0;
        while (n < stringArrayArray.length) {
            RuleSet ruleSet = CreateRuleSet.withJSVariableRules(string);
            JSParser jSParser = new JSParser(ruleSet);
            String string2 = jSParser.parse(stringArrayArray[n][1], stringArrayArray[n][0]).toString();
            Debug.println("SourceID: " + stringArrayArray[n][0]);
            Debug.println("Input: " + stringArrayArray[n][1]);
            Debug.println("Result: " + string2);
            ++n;
        }
    }
}

