/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.crypt.ciph;

import com.sun.portal.netlet.crypt.ciph.CipherSpi;
import com.sun.portal.netlet.crypt.ciph.Mode;
import com.sun.portal.netlet.crypt.ciph.NetletCryptoException;
import com.sun.portal.netlet.crypt.ciph.Padding;

public abstract class BlockCipher
extends CipherSpi {
    private int state = 0;
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_DECRYPT = 1;
    private static final int STATE_ENCRYPT = 2;
    private final int BLOCK_SIZE;
    private byte[] key;
    private String algorithm;
    private Padding padding;
    private Mode mode;

    protected BlockCipher(int blockSize) {
        this("", blockSize);
    }

    protected BlockCipher(String algorithm, int blockSize) {
        this.BLOCK_SIZE = blockSize;
        this.algorithm = algorithm;
        try {
            this.mode = Mode.getInstance("CBC", this);
            this.padding = Padding.getInstance("None", this.mode);
        }
        catch (NetletCryptoException e) {
            e.printStackTrace();
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected final void engineSetMode(String mode) throws NetletCryptoException {
        this.mode = Mode.getInstance(mode, this);
    }

    protected final void engineSetPadding(String padding) throws NetletCryptoException {
        this.padding = Padding.getInstance(padding, this.mode);
    }

    protected final int engineGetBlockSize() {
        return this.padding.getBlockSize();
    }

    protected final int engineGetOutputSize(int inputLen) {
        return this.padding.getOutputSize(inputLen);
    }

    protected final byte[] engineGetIV() {
        return this.padding.getIV();
    }

    protected final void engineInit(int opmode, byte[] key) throws NetletCryptoException {
        boolean decrypt = opmode == 2;
        this.padding.init(decrypt, key);
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws NetletCryptoException {
        return this.padding.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws NetletCryptoException {
        byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
        int i = this.engineDoFinal(input, inputOffset, inputLen, tmp, 0);
        if (i != tmp.length) {
            byte[] t = new byte[i];
            System.arraycopy(tmp, 0, t, 0, i);
            tmp = t;
        }
        return tmp;
    }

    abstract void coreInit(byte[] var1, boolean var2) throws NetletCryptoException;

    abstract void coreCrypt(byte[] var1, int var2, byte[] var3, int var4);

    int coreGetBlockSize() {
        return this.BLOCK_SIZE;
    }
}

