/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.NetletGroup;
import com.sun.portal.netlet.eproxy.SessionKeepAlive;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetletGroupManager {
    private static Hashtable userNetlets = new Hashtable();
    private static NetletGroupManager manager = null;
    private static SessionKeepAlive ska = null;

    private NetletGroupManager() {
    }

    public static NetletGroupManager getNetletGroupManager() {
        if (manager == null) {
            manager = new NetletGroupManager();
        }
        return manager;
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock r, SSOToken ssoToken) throws SSOException {
        String ssoTokenID = ssoToken.getTokenID().toString();
        NetletGroupManager.init(ssoToken);
        NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
        if (ng == null) {
            ng = new NetletGroup(manager, ssoToken);
        }
        ng.add(r);
        userNetlets.put(ssoTokenID, ng);
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock r, SSOTokenID ssoTokenId) throws SSOException {
        String ssoTokenID = ssoTokenId.toString();
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        SSOToken ssoToken = ssoTokenManager.createSSOToken(ssoTokenID);
        NetletGroupManager.init(ssoToken);
        NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
        if (ng == null) {
            ng = new NetletGroup(manager, ssoToken);
        }
        ng.add(r);
        userNetlets.put(ssoTokenID, ng);
    }

    public static synchronized void registerReaderWriter(ReaderWriterLock r, String ssoTokenID) throws SSOException {
        SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
        SSOToken ssoToken = ssoTokenManager.createSSOToken(ssoTokenID);
        NetletGroupManager.init(ssoToken);
        NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
        if (ng == null) {
            ng = new NetletGroup(manager, ssoToken);
        }
        ng.add(r);
        userNetlets.put(ssoTokenID, ng);
    }

    public static synchronized void unregister(SSOToken ssoToken) {
        String ssoTokenID = ssoToken.getTokenID().toString();
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static synchronized void unregister(SSOTokenID ssoTokenId) {
        String ssoTokenID = ssoTokenId.toString();
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static synchronized void unregister(String ssoTokenID) {
        NetletGroupManager.clean(ssoTokenID);
        userNetlets.remove(ssoTokenID);
    }

    public static synchronized void clean(String ssoTokenID) {
        NetletGroup ng = (NetletGroup)userNetlets.get(ssoTokenID);
        ng.clean();
    }

    public static synchronized String[] getRegisteredSessions() {
        Enumeration enumeration = userNetlets.keys();
        int i = 0;
        String[] keys = new String[userNetlets.size()];
        while (enumeration.hasMoreElements()) {
            keys[i] = (String)enumeration.nextElement();
            ++i;
        }
        return keys;
    }

    public static synchronized NetletGroup getNetletGroup(String ssoTokenID) {
        return (NetletGroup)userNetlets.get(ssoTokenID);
    }

    private static void init(SSOToken ssoToken) {
        block5: {
            if (ska == null) {
                try {
                    ska = new SessionKeepAlive(manager, ssoToken.getMaxIdleTime());
                    GWThreadPool.run(ska);
                }
                catch (InterruptedException ie) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("Unable to start Session Keep Alive Thread from Netlet Group manager", ie);
                    }
                }
                catch (SSOException se) {
                    if (!GWDebug.debug.errorEnabled()) break block5;
                    GWDebug.debug.error("Unable to start Session Keep Alive Thread from Netlet Group manager", se);
                }
            }
        }
    }
}

