/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.client;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.HostAvailabilityEvent;
import com.sun.portal.util.HostAvailabilityListener;
import com.sun.portal.util.SystemProperties;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HostChooser
extends HostAvailabilityListener {
    private static final String SERVLET_URL = SystemProperties.get("gateway.dsame.agent");
    private String path;
    private List portalServers;
    private Iterator roundRobin;
    private static int orginalSize;

    public HostChooser() {
        block2: {
            this.path = null;
            this.portalServers = null;
            this.roundRobin = null;
            try {
                this.path = new URL(SERVLET_URL).getPath();
            }
            catch (MalformedURLException me) {
                if (!GWDebug.debug.errorEnabled()) break block2;
                GWDebug.debug.error("Gateway Aborting: Invalid gateway.dsame.agent url ");
            }
        }
        this.addHostAvailabilityListener(this);
    }

    private void initialize() {
        Iterator itr = GatewayProfile.getStringList("PortalServerList").iterator();
        this.portalServers = new ArrayList();
        while (itr.hasNext()) {
            this.portalServers.add(itr.next().toString().toLowerCase());
        }
    }

    public synchronized String getHost() {
        if (this.portalServers == null) {
            try {
                this.initialize();
            }
            catch (NullPointerException ne) {
                return SERVLET_URL;
            }
            orginalSize = this.portalServers.size();
        }
        if (this.portalServers.size() == 0) {
            return null;
        }
        if (orginalSize < 2) {
            return SERVLET_URL;
        }
        if (this.roundRobin == null) {
            this.roundRobin = this.portalServers.iterator();
        }
        if (this.roundRobin.hasNext()) {
            return this.roundRobin.next().toString() + this.path;
        }
        this.roundRobin = this.portalServers.iterator();
        return this.roundRobin.next().toString() + this.path;
    }

    public boolean isAvailable(String host) {
        try {
            if (this.portalServers == null) {
                this.initialize();
            }
            URL url = new URL(host);
            StringBuffer portalHost = new StringBuffer();
            portalHost.append(url.getProtocol()).append("://").append(url.getHost()).append(":").append(url.getPort());
            String requestedHost = portalHost.toString().toLowerCase();
            return this.portalServers.contains(requestedHost);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void hostAvailabilityChanged(HostAvailabilityEvent hae) {
        if (hae.getEventType() == 1) {
            this.addHost(hae.getHost());
        } else if (hae.getEventType() == 2) {
            this.removeHost(hae.getHost());
        }
    }

    private void removeHost(String host) {
        if (this.portalServers.contains(host)) {
            List list = this.portalServers;
            synchronized (list) {
                this.portalServers.remove(host);
            }
        }
    }

    private void addHost(String host) {
        if (!this.portalServers.contains(host)) {
            List list = this.portalServers;
            synchronized (list) {
                this.portalServers.add(host);
            }
        }
    }

    public static String getBootupPortalServer() {
        return SERVLET_URL;
    }
}

