/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.util;

import com.sun.portal.util.Debug;

public final class ThreadPool {
    private static int nextThreadID = 1;
    private Debug debug;
    private String poolName;
    private IPSThread[] allThreadList;
    private IPSThread[] idleThreadList;
    private volatile int tail = -1;

    public ThreadPool(String poolName, int numThreads, boolean daemon, Debug debug) throws IllegalArgumentException {
        if (poolName == null) {
            throw new IllegalArgumentException("Must assign a non-null pool name to ThreadPool");
        }
        this.poolName = poolName;
        this.debug = debug;
        numThreads = Math.max(1, numThreads);
        this.idleThreadList = new IPSThread[numThreads];
        this.allThreadList = new IPSThread[numThreads];
        int i = 0;
        while (i < numThreads) {
            this.allThreadList[i] = new IPSThread(this.getNextIPSThreadID(), daemon);
            ++i;
        }
    }

    private ThreadPool() {
    }

    private synchronized String getNextIPSThreadID() {
        return this.poolName + ".Thread#" + Integer.toString(nextThreadID++);
    }

    public final void run(Runnable task) throws InterruptedException {
        IPSThread ipsThread;
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            while (this.tail == -1) {
                if (this.debug != null && this.debug.warningEnabled()) {
                    this.debug.warning(Thread.currentThread().getName() + " waiting for an idle thread in " + this.toString());
                }
                this.idleThreadList.wait();
            }
            ipsThread = this.idleThreadList[this.tail--];
        }
        ipsThread.process(task);
    }

    public final void stopIdleThreads() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            while (this.tail >= 0) {
                IPSThread idleThread = this.idleThreadList[this.tail];
                this.idleThreadList[this.tail--] = null;
                idleThread.stop();
            }
        }
    }

    public final void destroy() {
        this.stopIdleThreads();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        IPSThread[] iPSThreadArray = this.allThreadList;
        synchronized (iPSThreadArray) {
            int numThreads = this.allThreadList.length;
            int i = 0;
            while (i < numThreads) {
                IPSThread ipsThread = this.allThreadList[i];
                this.allThreadList[i++] = null;
                if (!ipsThread.isAlive()) continue;
                ipsThread.stop();
            }
        }
    }

    public String toString() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            String string = this.poolName + "[" + this.allThreadList.length + " Total threads, " + (this.tail >= 0 ? this.tail + 1 : 0) + " Idle threads]";
            return string;
        }
    }

    public final String getName() {
        return this.poolName;
    }

    private final void logMessage(String msg) {
        if (this.debug == null) {
            return;
        }
        this.debug.message(msg);
    }

    private final class IPSThread {
        private volatile Runnable task;
        private Thread thread;
        private volatile boolean stopped = false;

        IPSThread(String name, boolean daemon) {
            Runnable r = new Runnable(this){
                private final /* synthetic */ IPSThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    block2: {
                        try {
                            IPSThread.access$100(this.this$1);
                        }
                        catch (Throwable t) {
                            if (ThreadPool.access$300(IPSThread.access$200(this.this$1)) == null) break block2;
                            ThreadPool.access$300(IPSThread.access$200(this.this$1)).error(IPSThread.access$400(this.this$1).getName() + " caught exception that fell through", t);
                        }
                    }
                }
            };
            this.thread = new Thread(r, name);
            this.thread.setDaemon(daemon);
            this.thread.start();
        }

        private IPSThread() {
        }

        final synchronized void process(Runnable task) throws InterruptedException {
            this.task = task;
            this.notify();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runTask() {
            while (true) {
                Object var7_7;
                if (this.stopped) {
                    if (ThreadPool.this.debug != null) {
                        ThreadPool.this.debug.error(this.thread.getName() + " stopped.", null);
                    }
                    return;
                }
                try {
                    try {
                        block21: {
                            IPSThread[] iPSThreadArray = ThreadPool.this.idleThreadList;
                            synchronized (iPSThreadArray) {
                                ((ThreadPool)ThreadPool.this).idleThreadList[++((ThreadPool)ThreadPool.this).tail] = this;
                                if (ThreadPool.this.tail == 0) {
                                    ThreadPool.this.idleThreadList.notifyAll();
                                }
                            }
                            IPSThread iPSThread = this;
                            synchronized (iPSThread) {
                                while (true) {
                                    if (this.task != null) {
                                        Object var5_6;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 7, 13, 14] lbl18 : MonitorExitStatement: MONITOREXIT : iPSThread
                                        try {
                                            try {
                                                this.task.run();
                                            }
                                            catch (Exception e) {
                                                if (ThreadPool.this.debug != null) {
                                                    ThreadPool.this.debug.error(this.thread.getName() + " caught exception that fell through from " + this.task + ".run()", e);
                                                }
                                                var5_6 = null;
                                                Thread.interrupted();
                                                break block21;
                                            }
                                            var5_6 = null;
                                            break;
                                        }
                                        catch (Throwable throwable) {
                                            var5_6 = null;
                                            Thread.interrupted();
                                            throw throwable;
                                        }
                                    }
                                    this.wait();
                                }
                            }
                            Thread.interrupted();
                        }
                        var7_7 = null;
                        this.task = null;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        var7_7 = null;
                        this.task = null;
                    }
                    catch (Throwable t) {
                        if (ThreadPool.this.debug != null) {
                            ThreadPool.this.debug.error(this.thread.getName() + ": runTask() caught throwable. Investigate the problem", t);
                        }
                        var7_7 = null;
                        this.task = null;
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    this.task = null;
                    throw throwable;
                }
            }
        }

        private final void stop() {
            ThreadPool.this.logMessage(this.thread.getName() + " received stop() request.");
            this.stopped = true;
            this.thread.interrupt();
        }

        final String getName() {
            return this.thread.getName();
        }

        final boolean isAlive() {
            return this.thread.isAlive();
        }

        static /* synthetic */ void access$100(IPSThread x0) {
            x0.runTask();
        }

        static /* synthetic */ ThreadPool access$200(IPSThread x0) {
            return x0.ThreadPool.this;
        }

        static /* synthetic */ Thread access$400(IPSThread x0) {
            return x0.thread;
        }
    }
}

