/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.portal.netfile.servlet.CheckPort;
import com.sun.portal.netfile.servlet.NetFileAttributeExtractor;
import com.sun.portal.netfile.servlet.NetFileContext;
import com.sun.portal.netfile.servlet.NetFileHostDenialProcessor;
import com.sun.portal.netfile.servlet.NetFileLogManager;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.servlet.NetWareFile;
import com.sun.portal.netfile.servlet.WinFile;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AddSystemHandler {
    Debug debug = null;
    String[] pathInfo = null;
    String[] wrnt = null;
    NetFileLogManager logMgr = null;
    NetFileContext nfContext = null;
    NetFileHostDenialProcessor nfDenyProc = null;
    NetFileResource nfRes = null;
    NetFileAttributeExtractor nfAttrs = null;
    NetFileResponse nfResp = null;
    InetAddress machhost = null;
    String type = "";
    String machpack = "";
    String machinename = "";
    String szCharSet = "";
    String szDefaultDomain = "";
    String machdomain = "";
    String machinetyp = "";
    SSOToken ssoToken = null;

    public AddSystemHandler(String[] platInfo, NetFileLogManager log, NetFileContext context, NetFileResource res) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.pathInfo = platInfo;
        this.logMgr = log;
        this.nfContext = context;
        this.nfRes = res;
    }

    public Object addSystem(Vector nfReqData) throws NetFileException {
        Hashtable addSysTable = (Hashtable)nfReqData.get(4);
        this.ssoToken = (SSOToken)nfReqData.get(6);
        this.machinename = (String)addSysTable.get("SystemName");
        this.machdomain = (String)addSysTable.get("NTDomName");
        this.machinetyp = (String)addSysTable.get("SysType");
        this.szCharSet = (String)addSysTable.get("CharSet");
        this.szDefaultDomain = (String)addSysTable.get("DefaultDomain");
        this.debug.message("Add System " + this.machinename + "\nDomain name is " + this.machdomain + "\nRequest to add system of type " + this.machinetyp + "\nChar Set to be used is " + this.szCharSet);
        this.nfResp = new NetFileResponse((String)nfReqData.get(0), (String)nfReqData.get(1));
        try {
            this.detemineHostInetAddress();
        }
        catch (Exception uhe) {
            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.1", new Object[]{this.machinename}));
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        try {
            if (this.isLocalHost(this.machhost)) {
                this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.2"));
                this.nfResp.setNetFileResponseType(2100);
                return this.nfResp;
            }
        }
        catch (NetFileException nfe) {
            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.3"));
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        try {
            Object obj = addSysTable.get("DeniedHosts");
            if (obj != null) {
                ArrayList list = (ArrayList)obj;
                if (this.isDeniedHost((ArrayList)obj)) {
                    this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.4", new Object[]{this.machinename}));
                    this.nfResp.setNetFileResponseType(2100);
                    return this.nfResp;
                }
            }
        }
        catch (NetFileException nfe) {
            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.5", new Object[]{this.machinename}));
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        try {
            ArrayList list;
            ArrayList allowList;
            Object objAllowHosts = addSysTable.get("AllowedHosts");
            Object obj = addSysTable.get("DeniedHosts");
            if (obj != null && objAllowHosts != null && !this.isAllowedHost(allowList = (ArrayList)objAllowHosts, list = (ArrayList)obj, this.machinename.trim())) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " is not an allowed host ");
                }
                this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.13", new Object[]{this.machinename}));
                this.nfResp.setNetFileResponseType(2100);
                return this.nfResp;
            }
        }
        catch (NetFileException nfe) {
            if (nfe.getErrorCode() == 11) {
                this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.1", new Object[]{this.machinename}));
            } else {
                this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.12", new Object[]{this.machinename}));
            }
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        try {
            if (this.isHostAlreadyAdded((ArrayList)addSysTable.get("UserAddedHosts"))) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " has already been added ");
                }
                this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.6", new Object[]{this.machinename}));
                this.nfResp.setNetFileResponseType(2100);
                return this.nfResp;
            }
        }
        catch (NetFileException nfe) {
            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.7", new Object[]{this.machinename}));
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        CheckPort chkPort = new CheckPort();
        try {
            block37: {
                try {
                    if (this.machinetyp.equalsIgnoreCase("AUTODETECT")) {
                        this.type = this.determineHostType(chkPort);
                        break block37;
                    }
                    if (this.machinetyp.equalsIgnoreCase("NFS")) {
                        if (this.isNFSHost(chkPort)) {
                            this.type = "NFS";
                        }
                        break block37;
                    }
                    if (this.machinetyp.equalsIgnoreCase("WIN")) {
                        if (this.isWinHost(chkPort)) {
                            this.type = this.wrnt[0];
                        }
                        break block37;
                    }
                    if (this.machinetyp.equalsIgnoreCase("FTP")) {
                        if (this.isFTPHost(chkPort)) {
                            this.type = "FTP";
                        }
                        break block37;
                    }
                    if (!this.machinetyp.equalsIgnoreCase("NETWARE") || !this.isNetwareFTPHost(chkPort)) break block37;
                    this.type = "NETWARE";
                }
                catch (NetFileException nfe) {
                    if (nfe.getMessage() != null) {
                        if (nfe.getErrorCode() == 2) {
                            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.8", new Object[]{this.machinename}));
                        } else if (nfe.getErrorCode() == 4) {
                            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.11", new Object[]{this.machinename}));
                        } else {
                            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.9", new Object[]{this.machinename}));
                        }
                    } else {
                        this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.9", new Object[]{this.machinename}));
                    }
                    this.nfResp.setNetFileResponseType(2100);
                    NetFileResponse netFileResponse = this.nfResp;
                    Object var8_14 = null;
                    chkPort = null;
                    return netFileResponse;
                }
            }
            Object var8_13 = null;
            chkPort = null;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            chkPort = null;
            throw throwable;
        }
        if (this.type == null || this.type.trim().length() == 0) {
            this.nfResp.setNetFileResponseObject(this.nfRes.getString("ash.10", new Object[]{this.machinename}));
            this.nfResp.setNetFileResponseType(2100);
            return this.nfResp;
        }
        this.nfResp.setNetFileResponseObject(this.type);
        this.nfResp.setNetFileResponseType(2001);
        return this.nfResp;
    }

    void detemineHostInetAddress() throws UnknownHostException {
        try {
            if (this.machinename == null || this.machinename.trim().length() == 0) {
                throw new UnknownHostException("null");
            }
            this.machhost = InetAddress.getByName(this.machinename);
            this.machpack = this.machhost.toString();
        }
        catch (UnknownHostException ue) {
            this.debug.error("Unknown host", (Throwable)ue);
            this.logMgr.doError(this.nfRes.getString("error") + this.nfRes.getString("error27"));
            throw ue;
        }
    }

    boolean isLocalHost(InetAddress hostname) throws NetFileException {
        String[] rphost_ip = null;
        rphost_ip = this.getRPaddrs();
        int machip = this.machpack.indexOf("/", 0);
        String newip = this.machpack.substring(machip + 1);
        if (rphost_ip == null || rphost_ip.length < 1) {
            throw new NetFileException();
        }
        int k = 0;
        while (k < rphost_ip.length) {
            if (rphost_ip[k].trim().equals(newip.trim())) {
                this.logMgr.doError(this.nfRes.getString("error") + this.nfRes.getString("error8"));
                return true;
            }
            ++k;
        }
        return false;
    }

    boolean isAllowedHost(ArrayList allowedHosts, ArrayList deniedHosts, String hostName) throws NetFileException {
        String szHostName;
        String szFQHostName;
        if (this.nfDenyProc == null) {
            this.nfDenyProc = new NetFileHostDenialProcessor();
        }
        if ((szFQHostName = this.nfDenyProc.getFQHostName(szHostName = hostName, this.szDefaultDomain)) == null) {
            throw new NetFileException(11, "");
        }
        InetAddress[] hostAddresses = null;
        try {
            hostAddresses = InetAddress.getAllByName(szFQHostName);
        }
        catch (UnknownHostException uhe) {
            throw new NetFileException(11, "");
        }
        try {
            return this.nfDenyProc.isHostAllowed(allowedHosts, deniedHosts, szFQHostName, hostAddresses, true);
        }
        catch (Exception e) {
            this.debug.error("Exception in determining if " + hostAddresses.toString() + " is allowed", (Throwable)e);
            return false;
        }
    }

    boolean isDeniedHost(ArrayList aList) throws NetFileException {
        InetAddress[] ia_denied_hosts;
        if (this.nfDenyProc == null) {
            this.nfDenyProc = new NetFileHostDenialProcessor();
        }
        if ((ia_denied_hosts = this.nfDenyProc.getDeniedHostsAddresses(aList)) == null || ia_denied_hosts.length < 1) {
            return false;
        }
        try {
            if (this.nfDenyProc.isHostDenied(this.machinename, ia_denied_hosts)) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(this.machinename + " is a denied host ");
                }
                return true;
            }
        }
        catch (Exception e) {
            this.debug.error("Exception in finding denied host for " + this.machinename, (Throwable)e);
            throw new NetFileException();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isHostAlreadyAdded(ArrayList alist) throws NetFileException {
        InetAddress[] ia_names = null;
        try {
            try {
                if (alist == null) return false;
                if (alist.isEmpty()) {
                    return false;
                }
                ia_names = this.nfDenyProc.getDeniedHostsAddresses(alist);
                int i = 0;
                while (i < ia_names.length) {
                    if (ia_names[i].equals(this.machhost)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            catch (Exception e) {
                this.debug.error("Exception in getting verifying if " + this.machinename + " is an already added host", (Throwable)e);
                throw new NetFileException();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ia_names = null;
            throw throwable;
        }
    }

    String determineHostType(CheckPort chkPort) throws NetFileException {
        block6: {
            try {
                if (this.isWinHost(chkPort)) {
                    return this.wrnt[0] + '\n' + this.wrnt[1];
                }
            }
            catch (NetFileException nfe) {
                if (nfe.getErrorCode() == 4) break block6;
                throw nfe;
            }
        }
        if (this.isFTPHost(chkPort)) {
            if (this.isNetwareFTPHost(chkPort)) {
                return "NETWARE";
            }
            return "FTP";
        }
        if (this.isNFSHost(chkPort)) {
            return "NFS";
        }
        return "";
    }

    boolean isWinHost(CheckPort chkPort) throws NetFileException {
        int winstat = chkPort.checkTcpPort(this.machinename, 139);
        if (winstat == 1) {
            WinFile wf = new WinFile(this.logMgr, this.szCharSet, this.ssoToken, this.pathInfo);
            this.wrnt = wf.getWinType(this.machinename, this.machdomain, this.nfRes);
            this.debug.message(this.machinename + " is of type " + this.wrnt[0]);
            if (this.wrnt == null || this.wrnt.length < 1) {
                throw new NetFileException();
            }
            return true;
        }
        if (winstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isFTPHost(CheckPort chkPort) throws NetFileException {
        int ftpstat = chkPort.checkTcpPort(this.machinename, 21);
        if (ftpstat == 1) {
            return true;
        }
        if (ftpstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isNFSHost(CheckPort chkPort) throws NetFileException {
        int nfsstat = chkPort.checkTcpPort(this.machinename, 2049);
        if (nfsstat == 1) {
            return true;
        }
        if (nfsstat == -1) {
            throw new NetFileException();
        }
        return false;
    }

    boolean isNetwareFTPHost(CheckPort chkPort) throws NetFileException {
        int ftpstat = chkPort.checkTcpPort(this.machinename, 21);
        if (ftpstat == 1) {
            NetWareFile nff = new NetWareFile(this.logMgr, this.szCharSet);
            boolean isNetWare = nff.getFTPType(this.machinename);
            return isNetWare;
        }
        if (ftpstat == -1) {
            return false;
        }
        if (ftpstat == 0) {
            throw new NetFileException();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    String[] getRPaddrs() {
        String[] rphostip = new String[20];
        String configparam = "";
        int rpj = 0;
        try {
            int c;
            Runtime rt = Runtime.getRuntime();
            StringBuffer buftxt = new StringBuffer(80);
            String[] progarr = new String[]{"/sbin/ifconfig", "-a"};
            Process shellconn = rt.exec(progarr);
            InputStream shellout = shellconn.getInputStream();
            while ((c = shellout.read()) > -1) {
                void var5_13;
                char chtxt = (char)var5_13;
                buftxt.append(chtxt);
            }
            rt = null;
            shellout.close();
            shellout = null;
            shellconn.destroy();
            shellconn = null;
            configparam = buftxt.toString();
        }
        catch (IOException ex) {
            this.debug.error("FileOption IOException in getrpaddrs: ", (Throwable)ex);
            rphostip[0] = "Failed Execution: " + ex;
            rphostip[1] = "\u0000";
            Object rt = null;
            return rphostip;
        }
        if (configparam.equals("")) {
            this.debug.message("Cannot get local machine hostname.");
            rphostip[0] = "Cannot get local machine hostname.";
            rphostip[1] = "\u0000";
            return rphostip;
        }
        StringTokenizer pars = new StringTokenizer(configparam, "\n");
        int parscnt = pars.countTokens();
        String[] hostip = new String[100];
        int inetindx = 0;
        int inetmaskindx = 0;
        int j = 0;
        while (j < parscnt) {
            hostip[j] = pars.nextToken();
            inetindx = hostip[j].indexOf("inet", 0);
            inetmaskindx = hostip[j].indexOf("netmask", 0);
            if (inetindx >= 0 && inetmaskindx >= 0) {
                rphostip[rpj] = hostip[j].substring(inetindx + 5, inetmaskindx);
                ++rpj;
            }
            ++j;
        }
        int ips = rpj;
        while (ips < rphostip.length) {
            rphostip[ips] = "\u0000";
            ++ips;
        }
        return rphostip;
    }
}

