/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netfile.servlet;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netfile.servlet.AddSystemHandler;
import com.sun.portal.netfile.servlet.FtpFile;
import com.sun.portal.netfile.servlet.FullFtpClient;
import com.sun.portal.netfile.servlet.NetFileCompression;
import com.sun.portal.netfile.servlet.NetFileContext;
import com.sun.portal.netfile.servlet.NetFileContextImpl;
import com.sun.portal.netfile.servlet.NetFileLogManager;
import com.sun.portal.netfile.servlet.NetFileResource;
import com.sun.portal.netfile.servlet.NetFileResponseGenerator;
import com.sun.portal.netfile.servlet.NetFileUserProfileHandler;
import com.sun.portal.netfile.servlet.NetWareFile;
import com.sun.portal.netfile.servlet.NfsFile;
import com.sun.portal.netfile.servlet.RandomNumber;
import com.sun.portal.netfile.servlet.RequestProcessor;
import com.sun.portal.netfile.servlet.SendFile;
import com.sun.portal.netfile.servlet.WinFile;
import com.sun.portal.netfile.shared.NetFileException;
import com.sun.portal.netfile.transport.NetFileRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SerializedRequestProcessor
implements RequestProcessor {
    public Debug debug = null;
    public NetFileLogManager logMgr = null;
    public String[] pathInfo = null;
    private String version = null;
    private static HashMap resourceMap = new HashMap();
    private SSOTokenManager manager = null;

    public SerializedRequestProcessor() {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
    }

    public SerializedRequestProcessor(NetFileLogManager logManager, String ver) {
        if (this.debug == null) {
            this.debug = Debug.getInstance((String)"srapNetFile");
        }
        this.logMgr = logManager;
        this.version = ver;
    }

    public String getProtocolVersion() {
        return this.version;
    }

    public static synchronized void setResourceMap(String locale, String bundle, NetFileResource nfRes) {
        Object obj;
        if (resourceMap.containsKey(locale.trim() + bundle.trim()) && (obj = resourceMap.get(locale.trim() + bundle.trim())) != null) {
            return;
        }
        resourceMap.put(locale.trim() + bundle.trim(), nfRes);
    }

    public static NetFileResource getResourceMap(String locale, String bundle) {
        Object obj;
        if (resourceMap.containsKey(locale.trim() + bundle.trim()) && (obj = resourceMap.get(locale + bundle)) != null) {
            return (NetFileResource)obj;
        }
        return null;
    }

    public void processRequest(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken) throws NetFileException, StreamCorruptedException {
        Vector<SSOToken> nfReqData = new Vector<SSOToken>();
        ObjectInputStream oistream = null;
        ObjectOutputStream oostream = null;
        Object responseData = null;
        NetFileContextImpl nfContext = null;
        NetFileResource nfRes = null;
        NetFileResponseGenerator nfRespGen = null;
        try {
            oistream = this.fetchInputStream(req);
            oostream = this.fetchOutputStream(res);
        }
        catch (Exception e) {
            this.debug.error("\n Exception in getting streams in SerializedRequestProcessor::processRequest", (Throwable)e);
            if (oostream != null) {
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
                nfRespGen.createDefaultFailureResponse();
                nfRespGen.setResponseObject("<html>Could not obtain the input/output stream. Request not processed. <br>If the problem persists, please contact your administrator</html>");
                nfRespGen.generateResponse(oostream);
            }
            return;
        }
        try {
            this.unmarshallRequestData(oistream, nfReqData);
        }
        catch (OptionalDataException ode) {
            this.debug.error("\n Optional Data Exception in SerializedRequestProcessor::processRequest" + ode.getMessage());
            throw new NetFileException(6, ode.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            this.debug.error("\n Class not found in SerializedRequestProcessor::processRequest" + cnfe.getMessage());
            throw new NetFileException(6, cnfe.getMessage());
        }
        catch (IOException ioe) {
            this.debug.error("\n IOException in SerializedRequestProcessor::processRequest" + ioe.getMessage());
            throw new NetFileException(6, ioe.getMessage());
        }
        if (ssoToken == null) {
            ssoToken = this.extractSession(req);
        }
        if (!this.isSessionValid(req, ssoToken, nfReqData)) {
            if (oostream != null) {
                if (this.debug.messageEnabled()) {
                    this.debug.error("Session is invalid");
                }
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
                nfRespGen.createDefaultResponse();
                nfRespGen.setResponseType(952);
                nfRespGen.setResponseObject("Session is not valid. Please close NetFile, login to Portal server and enter NetFile.");
                nfRespGen.generateResponse(oostream);
            }
            return;
        }
        Integer iReqType = (Integer)nfReqData.get(3);
        nfReqData.add(ssoToken);
        nfContext = new NetFileContextImpl(ssoToken);
        nfContext.determineHTMLCharset(req);
        if (iReqType != 901) {
            this.pathInfo = this.grepPlatInfo(nfReqData);
        }
        if ((nfRes = SerializedRequestProcessor.getResourceMap(nfContext.getUserLocale().toString(), "srapNetFileServletJava2")) == null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 not found in resource map for locale " + nfContext.getUserLocale().toString());
            }
            nfRes = new NetFileResource("srapNetFileServletJava2", nfContext.getUserLocale().toString());
        } else if (this.debug.messageEnabled()) {
            this.debug.message("NetFile resource object for bundle srapNetFileServletJava2 found in resource map for locale " + nfContext.getUserLocale().toString());
        }
        res.setHeader("Cache-Control", "max-age=0");
        try {
            nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
            nfRespGen.createDefaultResponse();
            responseData = this.handleRequest(iReqType, nfReqData, nfContext, nfRes, nfRespGen);
            nfRespGen.generateResponse(oostream);
        }
        catch (NetFileException nfe) {
            if (nfRespGen == null) {
                nfRespGen = new NetFileResponseGenerator(req, res, nfReqData, responseData);
            }
            nfRespGen.createDefaultFailureResponse();
            nfRespGen.setResponseObject(nfe.getMessage());
            nfRespGen.generateResponse(oostream);
        }
    }

    private void unmarshallRequestData(ObjectInputStream ois, Vector nfReqVec) throws OptionalDataException, ClassNotFoundException, IOException {
        if (ois != null && nfReqVec != null) {
            this.debug.message("Valid Stream and Request Data obtained");
        }
        NetFileRequest nfReq = (NetFileRequest)ois.readObject();
        nfReqVec.add(nfReq.getRequestId());
        nfReqVec.add(nfReq.getSessionId());
        nfReqVec.add(nfReq.getUserId());
        nfReqVec.add(new Integer(nfReq.getRequestType()));
        Object obj = nfReq.getRequestObject();
        nfReqVec.add(obj);
        Object params = nfReq.getRequestParams();
        nfReqVec.add(params);
        if (this.debug.messageEnabled()) {
            this.debug.message("\n Request Data: " + (String)nfReqVec.get(0) + (String)nfReqVec.get(1) + (String)nfReqVec.get(2) + nfReqVec.get(3).toString());
        }
    }

    private ObjectInputStream fetchInputStream(HttpServletRequest req) throws StreamCorruptedException, IOException {
        return new ObjectInputStream((InputStream)req.getInputStream());
    }

    private ObjectOutputStream fetchOutputStream(HttpServletResponse res) throws StreamCorruptedException, IOException {
        return new ObjectOutputStream((OutputStream)res.getOutputStream());
    }

    private Object handleRequest(Integer reqType, Vector nfReqData, NetFileContext nfContext, NetFileResource nfRes, NetFileResponseGenerator respGen) throws NetFileException {
        Object o = null;
        Object i18nObj = null;
        NetFileUserProfileHandler nfProfileHandler = null;
        AddSystemHandler addSysHandler = null;
        if (this.debug.messageEnabled()) {
            this.debug.message("\n Request Type Received: " + reqType.toString());
        }
        switch (reqType) {
            case 651: {
                addSysHandler = new AddSystemHandler(this.pathInfo, this.logMgr, nfContext, nfRes);
                o = addSysHandler.addSystem(nfReqData);
                respGen.setNetFileResponse(o);
                break;
            }
            case 653: {
                this.addShare(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 655: {
                nfProfileHandler = new NetFileUserProfileHandler((SSOToken)nfReqData.get(6), nfContext, nfRes);
                nfProfileHandler.saveSessionData(nfReqData);
                break;
            }
            case 601: {
                this.getFilesList(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 551: {
                CompressFile cmpresFile = new CompressFile(this.pathInfo, this.logMgr);
                cmpresFile.compressFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 501: {
                MailFile mailFile = new MailFile(this.pathInfo, this.logMgr);
                mailFile.mailFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 607: {
                DownloadDirectory downloadDir = new DownloadDirectory(this.pathInfo, this.logMgr);
                downloadDir.downloadFolder(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 608: {
                RenameFile renameFile = new RenameFile(this.pathInfo, this.logMgr);
                renameFile.rename(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 610: {
                DeleteFile deleteFile = new DeleteFile(this.pathInfo, this.logMgr);
                deleteFile.deleteFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 609: {
                CreateDirectory newDir = new CreateDirectory(this.pathInfo, this.logMgr);
                newDir.createDir(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 701: {
                FileSearchHandler srchFile = new FileSearchHandler(this.pathInfo, this.logMgr);
                srchFile.searchFile(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 611: {
                FileExistenceVerifier fileVerfy = new FileExistenceVerifier(this.pathInfo, this.logMgr);
                fileVerfy.verifyForUpload(nfReqData, respGen, nfContext, nfRes);
                break;
            }
            case 612: {
                Hashtable data = (Hashtable)nfReqData.get(4);
                boolean retVal = this.doCleanUp((String)data.get("FileName"));
                respGen.setResponseObject(new Boolean(retVal));
                if (retVal) {
                    respGen.setResponseType(2001);
                    break;
                }
                respGen.setResponseType(2100);
                break;
            }
            case 901: {
                nfProfileHandler = new NetFileUserProfileHandler((SSOToken)nfReqData.get(6), nfContext, nfRes);
                Hashtable sessionData = nfProfileHandler.getSessionPreferences();
                if (sessionData == null) {
                    throw new NetFileException(6, nfRes.getString("srp.1"));
                }
                respGen.setResponseObject(sessionData);
                String szUserlocale = nfContext.getUserLocale().toString();
                i18nObj = this.fetchI18NBucket("srapNetFileAppletJava2", szUserlocale);
                respGen.setResponseObject(i18nObj);
                respGen.setResponseType(2001);
            }
        }
        return o;
    }

    private void getFilesList(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
        String szDir;
        Hashtable data = (Hashtable)nfReqData.get(4);
        String szPwd = (String)data.get("SharePwd");
        if (szPwd == null) {
            szPwd = (String)data.get("Pwd");
        }
        szDir = (szDir = (String)data.get("Dir")) == null ? "" : "/" + szDir;
        String szCharSet = (String)data.get("CharSet");
        if (this.debug.messageEnabled()) {
            this.debug.message("Listing for Directory " + szDir);
        }
        try {
            DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
            String[] returnTxt = dirListHandler.expandDir((String)data.get("UserID"), szPwd, (String)data.get("SystemName"), (String)data.get("NTDomName"), (String)data.get("SysType"), (String)data.get("ShareName"), szDir, nfRes, (SSOToken)nfReqData.get(6), szCharSet);
            nfRespGen.setResponseObject(returnTxt);
            nfRespGen.setResponseType(2001);
            return;
        }
        catch (Exception e) {
            this.debug.error("Exception in getting files list, SerializedRequestProcessor:getFilesList", (Throwable)e);
            nfRespGen.setResponseObject(e.getMessage());
            nfRespGen.setResponseType(2100);
            return;
        }
        catch (Throwable thr) {
            this.debug.error("Throwable Exception in getting files list, SerializedRequestProcessor:getFilesList", thr);
            nfRespGen.setResponseObject(thr.getMessage());
            nfRespGen.setResponseType(2100);
            return;
        }
    }

    private Object fetchI18NBucket(String szBundle, String szLocale) throws NetFileException {
        NetFileResource nfRes = null;
        try {
            nfRes = SerializedRequestProcessor.getResourceMap(szLocale, szBundle);
            if (nfRes == null) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("NetFile resource object for bundle " + szBundle + " not found in resource map for locale " + szLocale);
                }
                nfRes = new NetFileResource(szBundle, szLocale);
            } else if (this.debug.messageEnabled()) {
                this.debug.message("NetFile resource object for bundle " + szBundle + " found in resource map for locale " + szLocale);
            }
            return nfRes.populatei18nBucket(szBundle, szLocale);
        }
        catch (Exception e) {
            this.debug.error("Error in fetchI18NBucket", (Throwable)e);
            throw new NetFileException(6, e.getMessage());
        }
    }

    private void addShare(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
        Hashtable data = (Hashtable)nfReqData.get(4);
        String szCharSet = (String)data.get("CharSet");
        if (this.debug.messageEnabled()) {
            this.debug.message("Char Set to be used is " + szCharSet);
        }
        try {
            String shareName = (String)data.get("ShareName");
            String sysType = (String)data.get("SysType");
            if ((sysType.equalsIgnoreCase("WIN") || sysType.equalsIgnoreCase("NT")) && (shareName == null || shareName.equals(""))) {
                WinFile winFile = new WinFile(this.logMgr, szCharSet, (SSOToken)nfReqData.get(6), this.pathInfo);
                String szShares = winFile.getShares((String)data.get("UserID"), (String)data.get("Pwd"), (String)data.get("SystemName"), (String)data.get("NTDomName"), nfRes, new ArrayList());
                nfRespGen.setResponseObject(szShares);
                nfRespGen.setResponseType(2001);
                return;
            }
            DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
            String[] returnTxt = dirListHandler.expandDir((String)data.get("UserID"), (String)data.get("SharePwd"), (String)data.get("SystemName"), (String)data.get("NTDomName"), sysType, shareName, "", nfRes, (SSOToken)nfReqData.get(6), szCharSet);
            nfRespGen.setResponseObject(returnTxt);
            nfRespGen.setResponseType(2001);
            return;
        }
        catch (NetFileException nfe) {
            if (nfe.getErrorCode() == 1) {
                nfRespGen.setResponseObject(nfRes.getString("srp.8"));
            } else {
                nfRespGen.setResponseObject(nfe.getMessage());
            }
            nfRespGen.setResponseType(2100);
            return;
        }
        catch (Exception e) {
            nfRespGen.setResponseObject(e.getMessage());
            nfRespGen.setResponseType(2100);
            return;
        }
        catch (Throwable thr) {
            nfRespGen.setResponseObject(thr.getMessage());
            nfRespGen.setResponseType(2100);
            return;
        }
    }

    void doError(String msg) {
        this.logMgr.doError(msg);
    }

    void doLog(String msg) {
        this.logMgr.doLog(msg);
    }

    private String[] grepPlatInfo(Vector nfReqData) {
        String[] pathinfo = new String[2];
        Hashtable data = (Hashtable)nfReqData.get(4);
        Object value = data.get("sunPortalNetFileSMBClientLocation");
        if (value != null) {
            pathinfo[0] = (String)value;
        }
        if ((value = data.get("sunPortalNetFileMimetypesConfigFileLocation")) != null) {
            pathinfo[1] = (String)value;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Paths are " + pathinfo[0] + "\n" + pathinfo[1]);
        }
        return pathinfo;
    }

    private boolean doCleanUp(String szLocalFileName) {
        if (szLocalFileName == null) {
            return false;
        }
        try {
            File localFile = new File(szLocalFileName);
            if (localFile.exists()) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Deleting file " + localFile.getAbsolutePath());
                }
                localFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            if (this.debug.messageEnabled()) {
                this.debug.message("Exception in deleting temp file", (Throwable)e);
            }
            return false;
        }
    }

    private SSOToken extractSession(HttpServletRequest req) {
        try {
            if (this.manager == null) {
                this.manager = SSOTokenManager.getInstance();
            }
            return this.manager.createSSOToken(req);
        }
        catch (SSOException sSOException) {
            return null;
        }
    }

    public boolean isSessionValid(HttpServletRequest req, SSOToken token, Vector nfReqData) {
        String nfid = null;
        String session = null;
        Cookie[] cookie = req.getCookies();
        if (cookie == null) {
            return false;
        }
        if (token == null) {
            return false;
        }
        if (nfReqData.get(1) == null) {
            return false;
        }
        nfid = (String)nfReqData.get(1);
        if (nfid == null) {
            return false;
        }
        int i = 0;
        while (i < cookie.length) {
            if (cookie[i].getName().equalsIgnoreCase(SystemProperties.get((String)"com.iplanet.am.cookie.name", (String)"iPlanetDirectoryPro"))) {
                session = cookie[i].getValue();
            }
            ++i;
        }
        if (session == null || session.equals("")) {
            return false;
        }
        if (session.equals(nfid)) {
            try {
                if (this.manager == null) {
                    this.manager = SSOTokenManager.getInstance();
                }
                return this.manager.isValidToken(token);
            }
            catch (Exception e) {
                this.debug.error("Exception in determining if session is valid", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    class FileExistenceVerifier {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;
        DirectoryListingHandler listHandler = null;

        public FileExistenceVerifier(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
            this.listHandler = new DirectoryListingHandler(platInfo, log);
        }

        public void verifyForUpload(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            try {
                boolean fileExists = this.isFileExists(nfReqData, nfRespGen, nfContext, nfRes);
                boolean canWrite = this.isDirWriteable(nfReqData, nfRespGen, nfContext, nfRes);
                if (fileExists) {
                    nfRespGen.setResponseObject(new Integer(2002));
                    nfRespGen.setResponseType(2001);
                    return;
                }
                if (!canWrite) {
                    nfRespGen.setResponseObject(new Integer(2004));
                    nfRespGen.setResponseType(2001);
                    return;
                }
                nfRespGen.setResponseObject(new Integer(2003));
                nfRespGen.setResponseType(2001);
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
            }
        }

        private boolean isFileExists(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            Vector cachechk = (Vector)data.get("DeleteFiles");
            String file_name = (String)data.get("FileName");
            String domainname = (String)data.get("NTDomName");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String[] sa_listing = null;
            try {
                sa_listing = this.listHandler.expandDir(usernam, passwrd, machnam, domainname, machtyp, VMSnam, dir, nfRes, ssoToken, szCharSet);
            }
            catch (NetFileException nfe) {
                throw nfe;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Exception in getting the listing", (Throwable)e);
                throw new NetFileException(2100, nfRes.getString("srp.7"));
            }
            catch (Throwable thr) {
                throw new NetFileException(2100, nfRes.getString("srp.7"));
            }
            int i = 1;
            while (i < sa_listing.length) {
                if (file_name.equals(sa_listing[i])) {
                    return true;
                }
                i += 4;
            }
            return false;
        }

        private boolean isDirWriteable(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            return true;
        }

        private boolean isFileWriteable(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            return false;
        }

        private boolean isFileReadable() {
            return true;
        }
    }

    class DirectoryListingHandler {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public DirectoryListingHandler(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        private String[] expandDir(String usernam, String passwrd, String machnam, String domainname, String machtyp, String share, String dir, NetFileResource nfRes, SSOToken ssoToken, String s_machine_encoding) throws Throwable {
            if (!machtyp.equalsIgnoreCase("")) {
                if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile netwaredir = new NetWareFile(this.logMgr, s_machine_encoding);
                    return netwaredir.getFTPDir(usernam, passwrd, machnam, share, dir, nfRes);
                }
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    WinFile gpc = new WinFile(this.logMgr, s_machine_encoding, ssoToken, this.pathInfo);
                    return gpc.getPCDir(usernam, passwrd, machnam, share, dir, domainname, nfRes);
                }
                if (machtyp.indexOf("FTP", 0) >= 0) {
                    FtpFile gff = new FtpFile(this.logMgr, s_machine_encoding);
                    return gff.getFTPDir(usernam, passwrd, machnam, share, dir, nfRes);
                }
                if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile gnf = new NfsFile(this.logMgr, s_machine_encoding);
                    return gnf.getNFSDir(usernam, passwrd, share, machnam, dir, "", nfRes);
                }
            }
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Expand over");
            }
            return null;
        }
    }

    class DeleteFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public DeleteFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void deleteFile(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            Vector cachechk = (Vector)data.get("DeleteFiles");
            String domainname = (String)data.get("NTDomName");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String txt = "";
            String mainfilename = "";
            boolean indx = false;
            boolean intflg = true;
            String newstr = "";
            try {
                if (cachechk.size() > 0) {
                    int fil = 0;
                    while (fil < cachechk.size()) {
                        mainfilename = (String)cachechk.elementAt(fil);
                        if (machtyp.equalsIgnoreCase("")) {
                            nfRespGen.setResponseObject("ERROR:" + nfRes.getString("error6"));
                            nfRespGen.setResponseType(2100);
                            return;
                        }
                        if (machtyp.indexOf("NETWARE", 0) >= 0) {
                            NetWareFile n = new NetWareFile(this.logMgr, szCharSet);
                            txt = n.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfRes);
                        } else if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                            WinFile gpc = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                            txt = gpc.delPCFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, nfRes);
                        } else if (machtyp.indexOf("FTP", 0) >= 0) {
                            FtpFile gff = new FtpFile(this.logMgr, szCharSet);
                            txt = gff.delFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, nfRes);
                        } else if (machtyp.indexOf("NFS", 0) >= 0) {
                            NfsFile gfs = new NfsFile(this.logMgr, szCharSet);
                            txt = gfs.delNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, nfRes);
                        }
                        ++fil;
                    }
                }
            }
            catch (NetFileException nfe) {
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
        }
    }

    class CreateDirectory {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public CreateDirectory(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        /*
         * WARNING - void declaration
         */
        void createDir(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String newdir = (String)data.get("NewDirName");
            String domainname = (String)data.get("NTDomName");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String mountdir = "";
            String smbpath = "";
            String mkdirres = "";
            String returnTxt = "";
            String exerr = "";
            try {
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    WinFile winFile = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                    returnTxt = winFile.mkdir(machnam, VMSnam, usernam, passwrd, domainname, dir, newdir, nfRes);
                    nfRespGen.setResponseObject(returnTxt);
                    nfRespGen.setResponseType(2001);
                    return;
                }
                if (machtyp.indexOf("FTP", 0) >= 0) {
                    String oldftpdir = VMSnam + dir;
                    StringBuffer buftxt = new StringBuffer();
                    try {
                        String theLine;
                        FullFtpClient fc = new FullFtpClient(machnam, szCharSet);
                        fc.login(usernam, passwrd);
                        fc.cd(oldftpdir);
                        String prwrkd = fc.pwd();
                        fc.mkdir(newdir);
                        fc.setMachineToAccess(machnam);
                        BufferedReader theList = new BufferedReader(new InputStreamReader(fc.list()));
                        while ((theLine = theList.readLine()) != null) {
                            void var26_37;
                            buftxt.append((String)var26_37).append("\n");
                        }
                        returnTxt = buftxt.toString();
                        theList.close();
                        fc.closeServer();
                    }
                    catch (IOException ex) {
                        exerr = ex.toString();
                    }
                } else {
                    if (machtyp.indexOf("NFS", 0) >= 0) {
                        NfsFile nfsFile = new NfsFile(this.logMgr, szCharSet);
                        returnTxt = nfsFile.mkdir(machnam, VMSnam, usernam, passwrd, dir, newdir, nfRes);
                        nfRespGen.setResponseObject(returnTxt);
                        nfRespGen.setResponseType(2001);
                        return;
                    }
                    if (machtyp.indexOf("NETWARE", 0) >= 0) {
                        String oldnetwaredir = VMSnam + dir;
                        StringBuffer buftxt = new StringBuffer();
                        try {
                            String theLine;
                            FullFtpClient fc = new FullFtpClient(machnam, szCharSet);
                            fc.login(usernam, passwrd);
                            fc.cd(oldnetwaredir);
                            String prwrkd = fc.pwd();
                            fc.mkdir(newdir);
                            fc.setMachineToAccess(machnam);
                            BufferedReader theList = new BufferedReader(new InputStreamReader(fc.list()));
                            while ((theLine = theList.readLine()) != null) {
                                buftxt.append(theLine).append("\n");
                            }
                            returnTxt = buftxt.toString();
                            theList.close();
                            fc.closeServer();
                        }
                        catch (IOException ex) {
                            exerr = ex.toString();
                        }
                    } else {
                        nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error3"));
                        nfRespGen.setResponseType(2100);
                        return;
                    }
                }
                if (exerr.indexOf("File exists", 0) >= 0 || exerr.indexOf("550", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
                if (exerr.indexOf("LoginException", 0) >= 0 || exerr.indexOf("password", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
                if (exerr.indexOf("errsrv", 0) >= 0 || exerr.indexOf("fail", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
                if (exerr.indexOf("errdos", 0) >= 0 || exerr.indexOf("fail", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error6"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
                if (exerr.indexOf("smbclient: not found", 0) >= 0) {
                    nfRespGen.setResponseObject("ERROR:" + newdir + nfRes.getString("error35"));
                    nfRespGen.setResponseType(2100);
                    return;
                }
            }
            catch (NetFileException nfe) {
                SerializedRequestProcessor.this.debug.error("Error creating directory", (Throwable)nfe);
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                nfRespGen.setResponseObject(e.getMessage());
                nfRespGen.setResponseType(2100);
                SerializedRequestProcessor.this.debug.error("Error creating directory", (Throwable)e);
            }
        }
    }

    class FileSearchHandler {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public FileSearchHandler(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void searchFile(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String machnam = (String)data.get("SystemName");
            String usernam = (String)data.get("UserID");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String passwrd = (String)data.get("SharePwd");
            String searchpattern = (String)data.get("SearchPattern");
            String dir = (String)data.get("Dir");
            String domainname = (String)data.get("NTDomName");
            int maxsrchdir = (Integer)data.get("MaxSearchDir");
            String szCharSet = (String)data.get("CharSet");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String localfilenam = "";
            String newname = "";
            String new_repl = "";
            boolean indtxt = false;
            String[] txt = new String[100];
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Searching username=" + usernam + ",machname=" + machnam + ",domain=" + domainname + ",machtype=" + machtyp + ",dir_nam=" + dir + ",VMSname=" + VMSnam + ",search_pattern=" + searchpattern + ",maxsearchdir=" + maxsrchdir);
            }
            try {
                newname = machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0 ? VMSnam + dir : (machtyp.indexOf("NETWARE", 0) >= 0 ? VMSnam + "/" + dir : VMSnam + "/" + dir);
                if (newname.indexOf("//", 0) >= 0) {
                    newname = newname.replace('/', ' ');
                }
                if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    WinFile srpat = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                    txt = srpat.smbDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, domainname, maxsrchdir, nfRes);
                } else if (machtyp.indexOf("FTP", 0) >= 0) {
                    FtpFile srpat = new FtpFile(this.logMgr, szCharSet);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Starting FTP search in directory " + dir + " of VMS " + VMSnam + " with pattern " + searchpattern);
                    }
                    txt = srpat.searchFTPDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfRes);
                } else if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile srpat = new NetWareFile(this.logMgr, szCharSet);
                    txt = srpat.searchFTPDir(usernam, passwrd, machnam, VMSnam, searchpattern, dir, maxsrchdir, nfRes);
                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile nfsFile = new NfsFile(this.logMgr, szCharSet);
                    txt = nfsFile.search(usernam, passwrd, machnam, VMSnam, searchpattern, dir, domainname, maxsrchdir, nfRes);
                    if (txt.length == 0) {
                        txt = new String[]{"    "};
                    }
                } else {
                    nfRespGen.setResponseObject("ERROR:" + nfRes.getString("error1"));
                    nfRespGen.setResponseType(2100);
                }
            }
            catch (NetFileException nfe) {
                nfRespGen.setResponseObject(nfe.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Exception searching files", (Throwable)e);
                nfRespGen.setResponseObject("ERROR: " + e.getMessage());
                nfRespGen.setResponseType(2100);
                return;
            }
            nfRespGen.setResponseType(2001);
            nfRespGen.setResponseObject(txt);
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Search over");
            }
        }
    }

    class MailFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public MailFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void mailFile(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String szCharSet = (String)data.get("CharSet");
            String usernam = (String)data.get("UserID");
            String passwrd = (String)data.get("SharePwd");
            String machnam = (String)data.get("SystemName");
            String machtyp = (String)data.get("SysType");
            String VMSnam = (String)data.get("ShareName");
            String dir = (String)data.get("Dir");
            String tempdir = (String)data.get("sunPortalNetFileTempDir");
            String domainname = (String)data.get("NTDomName");
            String szTo = (String)data.get("ToAddress");
            String szFrom = (String)data.get("FromAddress");
            String szReplyTo = (String)data.get("ReplyToAddress");
            String szCc = (String)data.get("CcAddress");
            String szBcc = (String)data.get("BccAddress");
            String szSubject = (String)data.get("Subject");
            String szMessage = (String)data.get("Message");
            String szMailServer = (String)data.get("MailServer");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            Vector v_files_to_send = (Vector)data.get("FileNames");
            HashMap<String, String> m_files_to_send = new HashMap<String, String>();
            try {
                try {
                    if (v_files_to_send == null) throw new NetFileException(500, nfRes.getString("srp.4"));
                    if (v_files_to_send.size() <= 0) {
                        throw new NetFileException(500, nfRes.getString("srp.4"));
                    }
                    int fil_mail = 0;
                    while (true) {
                        String result;
                        if (fil_mail >= v_files_to_send.size()) {
                            SendFile sendfil = new SendFile();
                            result = sendfil.sendAttachedFile(szTo, szFrom, szReplyTo, szCc, szBcc, szMailServer, szSubject, szMessage, m_files_to_send, "1", szCharSet, nfRes, "");
                            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                                SerializedRequestProcessor.this.debug.message("Number of attachments to be sent is " + m_files_to_send.size());
                            }
                            nfRespGen.setResponseType(2001);
                            nfRespGen.setResponseObject(result);
                            break;
                        }
                        String filename = (String)v_files_to_send.elementAt(fil_mail);
                        result = this.openFile(usernam, passwrd, machnam, domainname, machtyp, dir, VMSnam, (String)v_files_to_send.get(fil_mail), tempdir, nfRes, szCharSet, ssoToken);
                        if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                            SerializedRequestProcessor.this.debug.message("Obtained file " + filename + " for mailing");
                        }
                        if (result.startsWith("ERROR:")) {
                            nfRespGen.setResponseType(2100);
                            nfRespGen.setResponseObject(result);
                            Object var30_31 = null;
                            this.deleteFiles(m_files_to_send);
                            return;
                        }
                        m_files_to_send.put(result, filename);
                        ++fil_mail;
                    }
                }
                catch (NetFileException nfe) {
                    SerializedRequestProcessor.this.debug.error("Error mailing file", (Throwable)nfe);
                    nfRespGen.setResponseType(2100);
                    nfRespGen.setResponseObject(nfe.getMessage());
                    Object var30_33 = null;
                    this.deleteFiles(m_files_to_send);
                    return;
                }
                catch (Exception e) {
                    SerializedRequestProcessor.this.debug.error("Error mailing file", (Throwable)e);
                    nfRespGen.setResponseType(2100);
                    nfRespGen.setResponseObject("ERROR: " + nfRes.getString("error4"));
                    Object var30_34 = null;
                    this.deleteFiles(m_files_to_send);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var30_35 = null;
                this.deleteFiles(m_files_to_send);
                throw throwable;
            }
            Object var30_32 = null;
            this.deleteFiles(m_files_to_send);
        }

        private void deleteFiles(Map mapTempFiles) {
            if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                SerializedRequestProcessor.this.debug.message("Deleting temporary mail files");
            }
            Iterator it = mapTempFiles.keySet().iterator();
            while (it.hasNext()) {
                try {
                    String s_filename = (String)it.next();
                    File delFil = new File(s_filename);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Deleting :" + delFil.getAbsolutePath());
                    }
                    if (!delFil.exists()) continue;
                    delFil.delete();
                }
                catch (Exception e) {
                    SerializedRequestProcessor.this.debug.error("Exception deleting temporary file for mailing", (Throwable)e);
                }
            }
        }

        private String openFile(String username, String password, String machname, String domain, String machtype, String dir_nam, String VMSname, String mainfilenam, String tmpdir, NetFileResource nfr_user_locale_i18n_bucket, String szCharSet, SSOToken ssoToken) throws NetFileException {
            String usernam = username;
            String passwrd = password;
            String machnam = machname;
            String machtyp = machtype;
            String VMSnam = VMSname;
            String dir = dir_nam;
            String tempdir = tmpdir;
            String domainname = domain;
            String mainfilename = "";
            String txt = "";
            try {
                File fLocalTemp = new File(tmpdir);
                if (!fLocalTemp.exists()) {
                    fLocalTemp.mkdirs();
                }
            }
            catch (Exception e) {
                SerializedRequestProcessor.this.debug.error("Error creating temp directory", (Throwable)e);
                throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.5"));
            }
            try {
                mainfilename = mainfilenam;
                if (machtyp.equalsIgnoreCase("")) {
                    throw new NetFileException();
                }
                if (machtyp.indexOf("NETWARE", 0) >= 0) {
                    NetWareFile nf = new NetWareFile(this.logMgr, szCharSet);
                    txt = nf.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                } else if (machtyp.indexOf("WIN", 0) >= 0 || machtyp.indexOf("NT", 0) >= 0) {
                    if (dir.equals(" ") || dir == null || dir.equals("")) {
                        dir = "\\";
                    }
                    WinFile gpc = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Getting " + mainfilename);
                    }
                    txt = gpc.getPCFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, domainname, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Got " + mainfilename);
                    }
                } else if (machtyp.indexOf("FTP", 0) >= 0) {
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Getting(" + mainfilename + ")");
                    }
                    FtpFile gff = new FtpFile(this.logMgr, szCharSet);
                    txt = gff.getFTPFile(usernam, passwrd, machnam, VMSnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                    NfsFile gfs = new NfsFile(this.logMgr, szCharSet);
                    txt = gfs.getNFSFile(usernam, passwrd, VMSnam, machnam, mainfilename, dir, tempdir, nfr_user_locale_i18n_bucket, ssoToken.getTokenID().toString());
                }
                if (txt.indexOf("FileNotFound", 0) >= 0) {
                    throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.6"));
                }
                if (txt.toUpperCase().indexOf("ERROR", 0) >= 0) {
                    throw new NetFileException(500, nfr_user_locale_i18n_bucket.getString("srp.6"));
                }
            }
            catch (Exception e) {
                txt = "ERROR:" + e.getMessage();
                SerializedRequestProcessor.this.debug.error("Problem getting file", (Throwable)e);
            }
            return txt;
        }
    }

    class CompressFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public CompressFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        /*
         * Loose catch block
         */
        void compressFile(Vector nfReqData, NetFileResponseGenerator nfRespGen, NetFileContext nfContext, NetFileResource nfRes) {
            block105: {
                File file32;
                String copied_local_file;
                String target_file;
                String localfilenam;
                String text;
                block91: {
                    Hashtable data = (Hashtable)nfReqData.get(4);
                    String usernam = (String)data.get("UserID");
                    String passwrd = (String)data.get("SharePwd");
                    String machnam = (String)data.get("SystemName");
                    String machtyp = (String)data.get("SysType");
                    String VMSnam = (String)data.get("ShareName");
                    String dir = (String)data.get("Dir");
                    String tempdir = (String)data.get("sunPortalNetFileTempDir");
                    String domainname = (String)data.get("NTDomName");
                    String szCompressMethod = (String)data.get("CompressMethod");
                    SSOToken ssoToken = (SSOToken)nfReqData.get(6);
                    Vector cachechk = (Vector)data.get("FileNames");
                    String szCharSet = (String)data.get("CharSet");
                    String zipdir = null;
                    text = "";
                    String erroredFiles = "";
                    if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                        SerializedRequestProcessor.this.debug.message("Temporary directory=" + tempdir);
                    }
                    String mainfile_name = "";
                    localfilenam = "";
                    target_file = "";
                    copied_local_file = "";
                    if (machtyp.equalsIgnoreCase("")) {
                        throw new NetFileException();
                    }
                    if (cachechk == null || cachechk.size() <= 0) {
                        if (SerializedRequestProcessor.this.debug.messageEnabled()) {
                            SerializedRequestProcessor.this.debug.message("No files selected for compression");
                        }
                        throw new NetFileException();
                    }
                    if (cachechk.size() <= 0) break block91;
                    int fil_zip = 0;
                    while (fil_zip < cachechk.size()) {
                        block93: {
                            Exception e2222;
                            File file22;
                            Object var37_38;
                            InputStream instream;
                            OutputStream outstream;
                            WinFile gpc;
                            NfsFile nfsFile;
                            NetWareFile nwfile;
                            FtpFile gff;
                            block94: {
                                gff = null;
                                nwfile = null;
                                nfsFile = null;
                                gpc = null;
                                outstream = null;
                                instream = null;
                                if (szCompressMethod.equalsIgnoreCase("gzip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".gz";
                                } else if (szCompressMethod.equalsIgnoreCase("zip")) {
                                    mainfile_name = (String)cachechk.elementAt(fil_zip) + ".zip";
                                }
                                if (machtyp.indexOf("FTP", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.error(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    gff = new FtpFile(this.logMgr, szCharSet);
                                    instream = gff.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir, nfRes);
                                    outstream = gff.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir, nfRes);
                                } else if (machtyp.indexOf("NETWARE", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.error(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    nwfile = new NetWareFile(this.logMgr, szCharSet);
                                    instream = nwfile.getInputFTPStream(usernam, passwrd, machnam, VMSnam, (String)cachechk.elementAt(fil_zip), dir, nfRes);
                                    outstream = nwfile.getOutputFTPStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir, nfRes);
                                } else if (machtyp.indexOf("NFS", 0) >= 0) {
                                    SerializedRequestProcessor.this.debug.error(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    nfsFile = new NfsFile(this.logMgr, szCharSet);
                                    instream = nfsFile.getNFSInputStream(usernam, passwrd, VMSnam, machnam, (String)cachechk.elementAt(fil_zip), dir);
                                    outstream = nfsFile.getNFSOutputStream(usernam, passwrd, machnam, VMSnam, mainfile_name, dir);
                                } else {
                                    if (machtyp.indexOf("WIN", 0) < 0 && machtyp.indexOf("NT", 0) < 0) break;
                                    SerializedRequestProcessor.this.debug.error(szCompressMethod + " Processing of file " + (String)cachechk.elementAt(fil_zip));
                                    String szNameFileToGet = (String)cachechk.elementAt(fil_zip);
                                    gpc = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                                    localfilenam = gpc.getPCFile(usernam, passwrd, machnam, VMSnam, szNameFileToGet, dir, domainname, tempdir, nfRes, ssoToken.getTokenID().toString());
                                    RandomNumber rndnum = new RandomNumber();
                                    String ranom = rndnum.randomNumbers();
                                    zipdir = tempdir + "/tmpzip." + ranom;
                                    File fil = new File(zipdir);
                                    if (!fil.exists()) {
                                        fil.mkdir();
                                        if (!fil.exists()) {
                                            throw new NetFileException();
                                        }
                                    }
                                    target_file = zipdir;
                                    instream = new FileInputStream(localfilenam);
                                    copied_local_file = zipdir + "/" + mainfile_name;
                                    outstream = new FileOutputStream(copied_local_file);
                                }
                                try {
                                    block92: {
                                        NetFileCompression nfComp = new NetFileCompression();
                                        nfComp.setCompressMethod(szCompressMethod);
                                        nfComp.doCompress(instream, outstream, cachechk.elementAt(fil_zip));
                                        if (machtyp.indexOf("WIN", 0) < 0 && machtyp.indexOf("NT", 0) < 0) break block92;
                                        text = gpc.putPCFile(usernam, passwrd, machnam, VMSnam, copied_local_file, mainfile_name, dir, domainname, nfRes);
                                    }
                                    var37_38 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        break block93;
                                    }
                                    if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                        break block93;
                                    }
                                    if (nfsFile == null) break block94;
                                }
                                catch (Throwable throwable) {
                                    var37_38 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                    } else if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                    } else if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                    } else if (gpc != null) {
                                        if (instream != null) {
                                            instream.close();
                                        }
                                        if (outstream != null) {
                                            outstream.close();
                                        }
                                        try {
                                            file22 = new File(localfilenam);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                        try {
                                            file22 = new File(target_file);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                        try {
                                            file22 = new File(copied_local_file);
                                            if (file22.exists()) {
                                                file22.delete();
                                            }
                                        }
                                        catch (Exception e2222) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                nfsFile.closeNfsFile();
                                break block93;
                            }
                            if (gpc != null) {
                                if (instream != null) {
                                    instream.close();
                                }
                                if (outstream != null) {
                                    outstream.close();
                                }
                                try {
                                    file22 = new File(localfilenam);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                }
                                catch (Exception e2222) {
                                    // empty catch block
                                }
                                try {
                                    file22 = new File(target_file);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                }
                                catch (Exception e2222) {
                                    // empty catch block
                                }
                                try {
                                    file22 = new File(copied_local_file);
                                    if (file22.exists()) {
                                        file22.delete();
                                    }
                                    break block93;
                                }
                                catch (Exception e2222) {}
                            }
                            break block93;
                            {
                                catch (Exception e3) {
                                    text = "ERROR:";
                                    SerializedRequestProcessor.this.debug.error("Error in compressing file " + (String)cachechk.get(fil_zip) + "to host " + machnam, (Throwable)e3);
                                    if (fil_zip >= cachechk.size()) {
                                        erroredFiles = erroredFiles + (String)cachechk.get(fil_zip) + "<br>";
                                        throw new NetFileException(500, nfRes.getString("srp.2", new Object[]{erroredFiles}));
                                    }
                                    erroredFiles = erroredFiles + (String)cachechk.get(fil_zip) + "<br>";
                                    var37_38 = null;
                                    if (gff != null) {
                                        gff.closeFtpFile();
                                        break block93;
                                    }
                                    if (nwfile != null) {
                                        nwfile.closeFtpFile();
                                        break block93;
                                    }
                                    if (nfsFile != null) {
                                        nfsFile.closeNfsFile();
                                        break block93;
                                    }
                                    if (gpc == null) break block93;
                                    if (instream != null) {
                                        instream.close();
                                    }
                                    if (outstream != null) {
                                        outstream.close();
                                    }
                                    try {
                                        file22 = new File(localfilenam);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {
                                        // empty catch block
                                    }
                                    try {
                                        file22 = new File(target_file);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {
                                        // empty catch block
                                    }
                                    try {
                                        file22 = new File(copied_local_file);
                                        if (file22.exists()) {
                                            file22.delete();
                                        }
                                    }
                                    catch (Exception e2222) {}
                                }
                            }
                        }
                        ++fil_zip;
                    }
                }
                Object var40_41 = null;
                try {
                    file32 = new File(localfilenam);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                try {
                    file32 = new File(target_file);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                try {
                    file32 = new File(copied_local_file);
                    if (file32.exists()) {
                        file32.delete();
                    }
                }
                catch (Exception e4) {
                    // empty catch block
                }
                if (!text.startsWith("ERROR:")) {
                    nfRespGen.setResponseType(2001);
                    nfRespGen.setResponseObject(nfRes.getString("info9"));
                    return;
                }
                break block105;
                {
                    catch (Exception e) {
                        File file32;
                        SerializedRequestProcessor.this.debug.error("Exception compressing file", (Throwable)e);
                        text = "ERROR:";
                        nfRespGen.setResponseType(2100);
                        if (e instanceof NetFileException) {
                            nfRespGen.setResponseObject(e.getMessage());
                        } else {
                            nfRespGen.setResponseObject(nfRes.getString("srp.3"));
                        }
                        Object var40_42 = null;
                        try {
                            file32 = new File(localfilenam);
                            if (file32.exists()) {
                                file32.delete();
                            }
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        try {
                            file32 = new File(target_file);
                            if (file32.exists()) {
                                file32.delete();
                            }
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        try {
                            file32 = new File(copied_local_file);
                            if (file32.exists()) {
                                file32.delete();
                            }
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        if (!text.startsWith("ERROR:")) {
                            nfRespGen.setResponseType(2001);
                            nfRespGen.setResponseObject(nfRes.getString("info9"));
                            return;
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    File file32;
                    Object var40_43 = null;
                    try {
                        file32 = new File(localfilenam);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    try {
                        file32 = new File(target_file);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    try {
                        file32 = new File(copied_local_file);
                        if (file32.exists()) {
                            file32.delete();
                        }
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    if (!text.startsWith("ERROR:")) {
                        nfRespGen.setResponseType(2001);
                        nfRespGen.setResponseObject(nfRes.getString("info9"));
                        return;
                    }
                    throw throwable;
                }
            }
        }
    }

    class DownloadDirectory {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public DownloadDirectory(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void downloadFolder(Vector nfReqData, NetFileResponseGenerator respGen, NetFileContext nfContext, NetFileResource nfRes) {
            try {
                Hashtable data = (Hashtable)nfReqData.get(4);
                String[] files = this.getFilesInDirectory(nfReqData, data, nfContext, nfRes);
                respGen.setResponseType(2001);
                respGen.setResponseObject(files);
                return;
            }
            catch (NetFileException nfe) {
                respGen.setResponseObject(nfe.getMessage());
                respGen.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                respGen.setResponseObject(e.getMessage());
                respGen.setResponseType(2100);
                return;
            }
        }

        String[] getFilesInDirectory(Vector nfReqData, Hashtable data, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            String username = (String)data.get("UserID");
            String password = (String)data.get("SharePwd");
            String machine = (String)data.get("SystemName");
            String type = (String)data.get("SysType");
            String share = (String)data.get("ShareName");
            String directory = (String)data.get("Dir");
            String domain = (String)data.get("NTDomName");
            String szCharSet = (String)data.get("CharSet");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            String[] file_listing = null;
            try {
                DirectoryListingHandler dirListHandler = new DirectoryListingHandler(this.pathInfo, this.logMgr);
                String[] listing = dirListHandler.expandDir(username, password, machine, domain, type, share, directory, nfRes, ssoToken, szCharSet);
                if (listing == null) {
                    throw new NetFileException();
                }
                if (listing[0] == null) {
                    throw new NetFileException();
                }
                if (listing[0].startsWith("ERROR:")) {
                    throw new NetFileException();
                }
                if (listing.length % 4 != 0) {
                    throw new NetFileException();
                }
                Vector<String> v_files_in_directory = new Vector<String>();
                int i_index = 0;
                while (i_index < listing.length) {
                    String s_name;
                    String s_type = listing[i_index];
                    if (s_type == null || (s_name = listing[i_index + 1]) == null) break;
                    if (s_type.equals("-")) {
                        v_files_in_directory.addElement(s_name);
                        if (i_index + 4 >= listing.length) {
                            SerializedRequestProcessor.this.debug.message("breaking");
                            break;
                        }
                    }
                    int i_listing_size = v_files_in_directory.size();
                    file_listing = new String[i_listing_size];
                    int i = 0;
                    while (i < i_listing_size) {
                        file_listing[i] = (String)v_files_in_directory.elementAt(i);
                        ++i;
                    }
                    i_index += 4;
                }
                return file_listing;
            }
            catch (Throwable thr) {
                throw new NetFileException();
            }
        }
    }

    class RenameFile {
        String[] pathInfo = null;
        NetFileLogManager logMgr = null;

        public RenameFile(String[] platInfo, NetFileLogManager log) {
            this.pathInfo = platInfo;
            this.logMgr = log;
        }

        void rename(Vector nfReqData, NetFileResponseGenerator nfResp, NetFileContext nfContext, NetFileResource nfRes) throws NetFileException {
            Hashtable data = (Hashtable)nfReqData.get(4);
            String username = (String)data.get("UserID");
            String password = (String)data.get("SharePwd");
            String machine = (String)data.get("SystemName");
            String type = (String)data.get("SysType");
            String share = (String)data.get("ShareName");
            String oldName = (String)data.get("OldFileName");
            String newName = (String)data.get("NewFileName");
            String directory = (String)data.get("Dir");
            String domain = (String)data.get("NTDomName");
            String szCharSet = (String)data.get("CharSet");
            SSOToken ssoToken = (SSOToken)nfReqData.get(6);
            try {
                if (type.equalsIgnoreCase("WIN") || type.equalsIgnoreCase("NT")) {
                    WinFile winFile = new WinFile(this.logMgr, szCharSet, ssoToken, this.pathInfo);
                    winFile.rename(username, password, machine, domain, share, directory, oldName, newName);
                } else if (type.equalsIgnoreCase("FTP")) {
                    FtpFile ftpFile = new FtpFile(this.logMgr, szCharSet);
                    ftpFile.rename(username, password, machine, share, directory, oldName, newName, nfRes);
                } else if (type.equalsIgnoreCase("NFS")) {
                    NfsFile nfsFile = new NfsFile(this.logMgr, szCharSet);
                    nfsFile.rename(username, password, machine, share, directory, oldName, newName);
                } else if (type.equalsIgnoreCase("NETWARE")) {
                    NetWareFile nwFile = new NetWareFile(this.logMgr, szCharSet);
                    nwFile.rename(username, password, machine, share, directory, oldName, newName, nfRes);
                }
            }
            catch (NetFileException nfe) {
                nfResp.setResponseObject(nfe.getMessage());
                nfResp.setResponseType(2100);
                return;
            }
            catch (Exception e) {
                nfResp.setResponseObject(e.getMessage());
                nfResp.setResponseType(2100);
                return;
            }
            nfResp.setResponseObject("File Renamed");
            nfResp.setResponseType(2001);
        }
    }
}

