/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.netlet.crypt.ciph.CipherGroup;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.econnection.SessionKey;
import com.sun.portal.netlet.eproxy.NetletGroupManager;
import com.sun.portal.netlet.eproxy.NetletProxyRouter;
import com.sun.portal.netlet.eproxy.RWGroupCrypt;
import com.sun.portal.netlet.eproxy.RWGroupForward;
import com.sun.portal.netlet.eproxy.RWGroupFtp;
import com.sun.portal.netlet.eproxy.Redirect;
import com.sun.portal.netlet.eproxy.SessionAuthenticator;
import com.sun.portal.netlet.eproxy.SessionRequest;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.configservlet.client.GetResponseException;
import com.sun.portal.rproxy.configservlet.client.NetletProfile;
import com.sun.portal.rproxy.configservlet.client.SendRequestException;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLocale;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.ServiceIdentifier;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

class ESession
implements KeyConstants,
Runnable {
    protected SessionRequest sessReq = null;
    protected SessionKey sKey;
    protected CipherGroup cipher;
    protected NetletProfile userProfile;
    protected ProxyCipherMsg pMsg;
    protected RWGroupCrypt rwg = null;
    protected RWGroupForward rwgf = null;
    protected RWGroupFtp rwgcf = null;
    protected Socket fromSock;
    protected DataInputStream fromClient;
    protected Integer logId;
    protected SessionAuthenticator sessionAuth;
    protected static boolean useNetletProxy = false;
    protected String netletProxyHost = null;
    protected int netletProxyPort = 10555;
    protected Hashtable cipherList = new Hashtable();

    public ESession(Socket s, Integer _logId) {
        try {
            this.fromClient = new DataInputStream(s.getInputStream());
        }
        catch (IOException e) {
            if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: Unable to create DataInputStream -> ", e);
            }
            return;
        }
        this.logId = _logId;
        this.fromSock = s;
        this.sessionAuth = new SessionAuthenticator();
    }

    public void run() {
        block46: {
            if (this.readSessionId() != 0) {
                this.cleanUp();
                return;
            }
            if (this.sessionAuth.authenticate(this.sessReq) != 0) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: invalid session id");
                }
                this.cleanUp();
                return;
            }
            try {
                SSOTokenManager ssoTokenManager = SSOTokenManager.getInstance();
                SSOToken ssoToken = ssoTokenManager.createSSOToken(this.sessReq.getSessionID());
                ssoTokenManager.refreshSession(ssoToken);
                String dynSessionKey = ssoToken.getProperty("_sessionKey").toString();
                this.sKey = new SessionKey(dynSessionKey);
                this.userProfile = new NetletProfile(ssoToken.getTokenID().toString());
                List algoEnum = NetletProfile.getStringList("Ciphers");
                StringBuffer algoList = new StringBuffer();
                int x = 0;
                while (x < algoEnum.size()) {
                    algoList.append((String)algoEnum.get(x)).append("|");
                    ++x;
                }
                StringTokenizer algoSplitter = new StringTokenizer(algoList.toString(), "|");
                while (algoSplitter.hasMoreElements()) {
                    this.cipherList.put(algoSplitter.nextToken(), algoSplitter.nextToken());
                }
                String dynamicAlgorithm = this.sessReq.getAlgorithm();
                String keyLength = (String)this.cipherList.get(dynamicAlgorithm);
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("\n\nESession: Cipher -> " + dynamicAlgorithm + " KeyLength -> " + keyLength);
                }
                this.cipher = keyLength == null ? new CipherGroup(dynamicAlgorithm, this.sKey, 128) : new CipherGroup(dynamicAlgorithm, this.sKey, Integer.parseInt(keyLength));
            }
            catch (SSOException se) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + (Object)((Object)se));
                }
            }
            catch (GetResponseException gre) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + gre);
                }
            }
            catch (SendRequestException sre) {
                if (!GWDebug.debug.errorEnabled()) break block46;
                GWDebug.debug.error("ESession: Unable to create CipherGroup -> " + sre);
            }
        }
        if (useNetletProxy) {
            String sessionId;
            block47: {
                sessionId = this.sessReq.getSessionID();
                this.netletProxyHost = NetletProxyRouter.getNetletProxyAlive();
                URL nlp_url = null;
                try {
                    nlp_url = new URL(this.netletProxyHost);
                }
                catch (MalformedURLException me) {
                    me.printStackTrace();
                }
                this.netletProxyHost = nlp_url.getHost();
                int nlp_Port = nlp_url.getPort();
                if (nlp_Port != -1) {
                    this.netletProxyPort = nlp_Port;
                }
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("ESession: Netlet proxy host -> " + this.netletProxyHost);
                }
                this.rwgf = new RWGroupForward(this.fromSock, this.cipher, this.netletProxyHost, this.netletProxyPort, sessionId);
                try {
                    NetletGroupManager.getNetletGroupManager();
                    NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgf, sessionId);
                }
                catch (SSOException se) {
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.unregister(sessionId);
                    }
                    catch (Exception e) {
                        if (!GWDebug.debug.errorEnabled()) break block47;
                        GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                    }
                }
            }
            String logmsg = GWLocale.getPFString("es1", new Object[]{this.logId, new String(GWLogManager.getUserId(sessionId)), this.netletProxyHost, new Integer(this.netletProxyPort)});
            if (GWLogManager.loggingEnabled) {
                GWLogManager.write("netlet", logmsg);
            }
        } else {
            this.pMsg = new ProxyCipherMsg(this.cipher);
            if (this.pMsg.readMsg(this.fromClient) == 0) {
                String logmsg;
                block48: {
                    Redirect rd;
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("ESession: srcPort -> " + this.pMsg.getSrcPort());
                    }
                    if ((rd = new Redirect(this.pMsg.getSrcPort(), this.sessReq)).doRedirect()) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: redirect to -> " + rd.getDstPortList() + " " + rd.getDstHost());
                        }
                        logmsg = GWLocale.getPFString("es2", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), rd.getDstHost(), rd.getDstPortList()});
                        this.rwg = new RWGroupCrypt(this.fromSock, this.cipher, this.pMsg.getSrcPort(), rd.getDstPortList(), rd.getDstHost(), this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                        }
                        catch (SSOException se) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block48;
                            }
                            catch (Exception e) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block48;
                            }
                        }
                    }
                    if (this.pMsg.getDstPort().equals("-1")) {
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("ESession: FTP data connection to -> " + rd.getDstHost());
                        }
                        logmsg = GWLocale.getPFString("es4", new Object[]{this.logId, rd.getDstHost()});
                        this.rwgcf = new RWGroupFtp(this.fromSock, this.cipher, this.sessionAuth, this.sessReq);
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwgcf, this.sessReq.getSessionID());
                        }
                        catch (SSOException se) {
                            try {
                                NetletGroupManager.getNetletGroupManager();
                                NetletGroupManager.unregister(this.sessReq.getSessionID());
                                break block48;
                            }
                            catch (Exception e) {
                                if (GWDebug.debug.errorEnabled()) {
                                    GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                                }
                                break block48;
                            }
                        }
                    }
                    logmsg = GWLocale.getPFString("es3", new Object[]{this.logId, new String(GWLogManager.getUserId(this.sessReq.getSessionID())), this.pMsg.getHostName(), this.pMsg.getDstPort()});
                    this.rwg = new RWGroupCrypt(this.fromSock, this.cipher, this.pMsg.getSrcPort(), this.pMsg.getDstPort(), this.pMsg.getHostName(), this.sessionAuth, this.sessReq);
                    try {
                        NetletGroupManager.getNetletGroupManager();
                        NetletGroupManager.registerReaderWriter((ReaderWriterLock)this.rwg, this.sessReq.getSessionID());
                    }
                    catch (SSOException se) {
                        try {
                            NetletGroupManager.getNetletGroupManager();
                            NetletGroupManager.unregister(this.sessReq.getSessionID());
                        }
                        catch (Exception e) {
                            if (!GWDebug.debug.errorEnabled()) break block48;
                            GWDebug.debug.error("ESession: Unable to register/unregister with NetletGroupManager");
                        }
                    }
                }
                if (GWLogManager.loggingEnabled) {
                    GWLogManager.write("netlet", logmsg);
                }
            } else if (GWDebug.debug.errorEnabled()) {
                GWDebug.debug.error("ESession: unable to get proxy config!");
            }
            this.pMsg = null;
        }
    }

    public void stop() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.fromSock != null) {
            try {
                block5: {
                    try {
                        this.fromSock.close();
                        if (!PerfContextObject.ENABLE_PERF) break block5;
                        SocketCount.decrementPlainSockets();
                    }
                    catch (IOException e) {
                        Object var3_2 = null;
                        this.fromSock = null;
                    }
                }
                Object var3_1 = null;
                this.fromSock = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fromSock = null;
                throw throwable;
            }
        }
    }

    public String getSessionID() {
        return this.sessReq.getSessionID();
    }

    public byte[] getSessionKey() {
        byte[] key = new byte[32];
        System.arraycopy(this.sKey.getSessionKey(), 0, key, 0, 32);
        return key;
    }

    public boolean isDone() {
        if (this.rwg != null) {
            return this.rwg.isDone();
        }
        if (this.rwgf != null) {
            return this.rwgf.isDone();
        }
        if (this.rwgcf != null) {
            return this.rwgcf.isDone();
        }
        return this.fromSock == null;
    }

    private int readSessionId() {
        if (this.sessReq == null) {
            SessionKey initKey = new SessionKey("SN1.0SN1.0SN1.0S.SN9.0SN3.0SN.05".getBytes());
            CipherGroup initCipherGroup = new CipherGroup("RC4", initKey, 128);
            this.sessReq = new SessionRequest(initCipherGroup);
        }
        if (this.sessReq.readMsg(this.fromClient) == 0) {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: sessId = " + this.sessReq.getSessionID());
            }
        } else {
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("ESession: negotiateSessionId IOException");
            }
            return -1;
        }
        return 0;
    }

    static {
        useNetletProxy = GatewayProfile.getBoolean("UseNetletProxy", false) && ServiceIdentifier.isGateway();
    }
}

