/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.eproxy;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.eproxy.SConn;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.rproxy.server.HTTPSConnectionManager;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWLogManager;
import com.sun.portal.util.GWThreadPool;
import com.sun.portal.util.LogInfoContainer;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupClear
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean;
    private boolean dst_to_src_clean;

    public RWGroupClear(Socket fromClient, Integer logId) {
        block5: {
            this.src_to_dst_clean = false;
            this.dst_to_src_clean = false;
            this.fromClient = fromClient;
            this.toServer = SConn.connect(HTTPSConnectionManager.rProxyPort, "localhost");
            if (this.toServer == null) {
                if (GWDebug.debug.warningEnabled()) {
                    GWDebug.debug.warning("RWGroupClear cannot open connection to localhost:" + HTTPSConnectionManager.rProxyPort);
                }
                return;
            }
            if (GWDebug.debug.messageEnabled()) {
                GWDebug.debug.message("RWGroupClear opened " + this.toServer);
            }
            GWLogManager.logIdMap.put(new Integer(this.toServer.getLocalPort()), new LogInfoContainer(logId, fromClient));
            this.src_to_dst = new ReaderWriterClear(this, fromClient, this.toServer);
            this.dst_to_src = new ReaderWriterClear(this, this.toServer, fromClient);
            this.src_to_dst.useKeepAliveLogic();
            this.dst_to_src.useKeepAliveLogic();
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", e);
            }
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.cleanup();
        }
    }

    public void cleanup() {
        if (this.fromClient != null) {
            try {
                block12: {
                    try {
                        this.fromClient.close();
                        if (!PerfContextObject.ENABLE_PERF) break block12;
                        if (this.fromClient instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                            break block12;
                        }
                        SocketCount.decrementPlainSockets();
                    }
                    catch (Exception e) {
                        Object var3_2 = null;
                        this.fromClient = null;
                    }
                }
                Object var3_1 = null;
                this.fromClient = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.fromClient = null;
                throw throwable;
            }
        }
        if (this.toServer != null) {
            try {
                block14: {
                    try {
                        this.toServer.close();
                        if (this.toServer instanceof SSLSocket) {
                            SocketCount.decrementSSLSockets();
                            break block14;
                        }
                        SocketCount.decrementPlainSockets();
                    }
                    catch (Exception e) {
                        Object var5_8 = null;
                        this.toServer = null;
                    }
                }
                Object var5_7 = null;
                this.toServer = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.toServer = null;
                throw throwable;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    public long getLastActivityTime() {
        long ctime;
        long stime = this.src_to_dst.getLastActivityTime();
        if (stime > (ctime = this.dst_to_src.getLastActivityTime())) {
            return ctime;
        }
        return stime;
    }

    public synchronized void stopAll() {
        if (this.dst_to_src != null) {
            this.dst_to_src.stop();
        }
        if (this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return 0L;
    }
}

