/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.authentication.AuthPrincipal;
import com.iplanet.sm.SMSException;
import com.iplanet.sm.ServiceConfig;
import com.iplanet.sm.ServiceConfigManager;
import com.iplanet.sm.ServiceNotFoundException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.GatewayRequest;
import com.sun.portal.rproxy.configservlet.Request;
import com.sun.portal.rproxy.configservlet.Response;
import com.sun.portal.rproxy.configservlet.ServiceHandler;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class GatewayServiceHandler
implements ServiceHandler {
    private static final String RETRIEVE_INSTANCE = "retrieveInstance";
    public static final String SERVICE_NAME = "srapGatewayService";
    private static final String SUB_SCHEMA_NAME = "Gateway-Profiles";

    public Response handleRequest(Request request) throws RemoteException {
        String requestType = request.getRequestType();
        if (RETRIEVE_INSTANCE.equals(requestType)) {
            Map returnedObject = GatewayServiceHandler.executeRetrieveInstance(request);
            return new Response(request.getServiceName(), request.getRequestType(), returnedObject);
        }
        return new Response(request.getServiceName(), request.getRequestType(), new RemoteException("Not able to find the method to execute"));
    }

    private static Map executeRetrieveInstance(Request request) throws RemoteException {
        try {
            GatewayRequest gatewayRequest = (GatewayRequest)request;
            String instanceName = gatewayRequest.getInstanceName();
            ServiceConfigManager configManager = new ServiceConfigManager(SERVICE_NAME, GatewayServiceHandler.getSSOToken(request));
            ServiceConfig __config = configManager.getGlobalConfig(null);
            ServiceConfig config = __config.getSubConfig(SUB_SCHEMA_NAME);
            ServiceConfig config2 = config.getSubConfig(instanceName);
            return null != config2 ? config2.getAttributes() : new HashMap();
        }
        catch (ServiceNotFoundException snfe) {
            throw new RemoteException("service Not Found!!!, load service", snfe);
        }
        catch (SMSException smse) {
            throw new RemoteException("SMSException in retrieveing gateway config", smse);
        }
        catch (SSOException smse) {
            throw new RemoteException("SSOException in retrieveing gateway config", smse);
        }
    }

    private static SSOToken getSSOToken(Request request) throws RemoteException {
        try {
            String bindDN = AdminUtils.getAdminDN();
            String password = new String(AdminUtils.getAdminPassword());
            AuthPrincipal ap = new AuthPrincipal(bindDN);
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            return tokenManager.createSSOToken((Principal)ap, password);
        }
        catch (SSOException ssoe) {
            throw new RemoteException("Not able to get the token", ssoe);
        }
    }
}

