/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.configservlet.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.rproxy.configservlet.AMHashMap;
import com.sun.portal.rproxy.configservlet.Response;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UserProfileCache
implements SSOTokenListener {
    private static UserProfileCache instance = null;
    private HashMap cache = new HashMap();
    private int numEntries = 0;
    private int numOfCleanCacheSkips = 0;
    private boolean keepGoing = true;
    NoSuchElementException noSuchElementException = null;

    private UserProfileCache() {
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        int type = -1;
        try {
            type = evt.getType();
        }
        catch (SSOException ssoex) {
            // empty catch block
        }
        if (type == 3 || type == 1 || type == 2) {
            String tokid = evt.getToken().getTokenID().toString();
            this.removeEntry(tokid);
        }
    }

    private synchronized void addEntry(String id, UserSessionListenerTableEntry entry) {
        if (this.cache.put(id, entry) == null) {
            ++this.numEntries;
        }
    }

    private synchronized Object getEntry(String key) {
        return this.cache.get(key);
    }

    private synchronized void removeEntry(String key) {
        if (this.cache.remove(key) != null) {
            --this.numEntries;
        }
    }

    private synchronized boolean containsKey(String sessid) {
        return this.cache.containsKey(sessid);
    }

    private Object getValue(String key) {
        UserSessionListenerTableEntry entry = (UserSessionListenerTableEntry)this.getEntry(key);
        if (entry != null) {
            return entry.getResponse();
        }
        try {
            SSOToken tok = this.getSSOToken(key);
            Response resp = this.fetchUserAttributes(tok);
            this.addNewEntry(tok, key, resp);
            entry = (UserSessionListenerTableEntry)this.getEntry(key);
        }
        catch (Exception ex) {
            return null;
        }
        return entry.getResponse();
    }

    private void addNewEntry(SSOToken tok, String tokid, Response resp) {
        UserSessionListenerTableEntry entry = new UserSessionListenerTableEntry(resp);
        this.addEntry(tokid, entry);
        try {
            tok.addSSOTokenListener((SSOTokenListener)this);
        }
        catch (SSOException ssoex) {
            this.removeEntry(tokid);
        }
    }

    public static void addEntry(SSOToken tok, String tokid, Response resp) {
        instance.addNewEntry(tok, tokid, resp);
    }

    public static Response getResponse(String tokid) {
        return (Response)instance.getValue(tokid);
    }

    public static boolean contains(String sessid) {
        return instance.containsKey(sessid);
    }

    private void setAttributeInternal(String sessid, String attr, Set value) throws NoSuchElementException {
        UserSessionListenerTableEntry entry = (UserSessionListenerTableEntry)this.getEntry(sessid);
        if (entry != null) {
            entry.setAttribute(attr, value);
        } else {
            try {
                SSOToken tok = this.getSSOToken(sessid);
                Response resp = this.fetchUserAttributes(tok);
                this.addNewEntry(tok, sessid, resp);
                entry = (UserSessionListenerTableEntry)this.getEntry(sessid);
                entry.setAttribute(attr, value);
            }
            catch (Exception ex) {
                if (this.noSuchElementException == null) {
                    this.noSuchElementException = new NoSuchElementException("Missing profile object !");
                }
                throw this.noSuchElementException;
            }
        }
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attr, value);
        this.updateDsameProfile(sessid, map);
    }

    public static void setAttribute(String sessid, String attr, Set value) throws NoSuchElementException {
        instance.setAttributeInternal(sessid, attr, value);
    }

    protected SSOToken getSSOToken(String tokid) throws SSOException {
        SSOTokenManager tokenManager = SSOTokenManager.getInstance();
        SSOToken tok = null;
        try {
            tok = tokenManager.createSSOToken(tokid);
        }
        catch (SSOException ex) {
            try {
                tok = tokenManager.createSSOToken(URLEncoder.encode(tokid));
            }
            catch (SSOException ex1) {
                throw ex1;
            }
            catch (Exception gex1) {
                throw ex;
            }
        }
        return tok;
    }

    private Response fetchUserAttributes(SSOToken token) throws AMException, SSOException {
        AMStoreConnection connection = new AMStoreConnection(token);
        AMUser user = connection.getUser(token.getPrincipal().getName());
        Map attr = null;
        Map attr2 = null;
        Map attr3 = null;
        Map attr4 = null;
        int size = 0;
        try {
            attr = user.getServiceAttributes("srapGatewayAccessService");
            if (attr != null) {
                size += attr.size();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            attr2 = user.getServiceAttributes("srapNetletService");
            if (attr2 != null) {
                size += attr2.size();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            attr3 = user.getServiceAttributes("iplanetAMUserService");
            if (attr3 != null) {
                size += attr3.size();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            attr4 = user.getPolicy("srapGatewayAccessService");
            if (attr4 != null && attr4.size() != 0) {
                size += attr4.size();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        AMHashMap allAttributes = new AMHashMap();
        if (attr != null) {
            allAttributes.putAll(attr);
        }
        if (attr2 != null) {
            allAttributes.putAll(attr2);
        }
        if (attr3 != null) {
            allAttributes.putAll(attr3);
        }
        if (attr4 != null) {
            allAttributes.putAll(attr4);
        }
        Response response = new Response("", "", allAttributes);
        return response;
    }

    protected void updateDsameProfile(String tokid, Map toUpdate) {
        try {
            SSOToken token = this.getSSOToken(tokid);
            AMStoreConnection connection = new AMStoreConnection(token);
            AMUser user = connection.getUser(token.getPrincipal().getName());
            if (user.isExists()) {
                user.setAttributes(toUpdate);
                user.store();
            }
        }
        catch (SSOException ex) {
        }
        catch (AMException ex) {
            // empty catch block
        }
    }

    static {
        instance = new UserProfileCache();
    }

    class UserSessionListenerTableEntry {
        private Response resp = null;
        private long timestamp;

        public UserSessionListenerTableEntry(Response resp) {
            this.resp = resp;
            this.timestamp = System.currentTimeMillis();
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public Response getResponse() {
            this.timestamp = System.currentTimeMillis();
            return this.resp;
        }

        public void setAttribute(String attr, Set value) {
            Map entries = (Map)this.resp.getReturnedObject();
            entries.put(attr, value);
            this.resp.setReturnedObject(entries);
            this.timestamp = System.currentTimeMillis();
        }
    }
}

